#define	EOF	0
#define	RP	1
#define	LP1	2
#define	ALT	3
#define	JUX	4
#define	CLO	5
#define	ALP	6
#define	LP2	7

#define	END	0
#define	TRA	1
#define	CHR	2
#define	OR	3
#define	SYN	4
#define	NOP	5

int	sp;
char	stk[10];
int	cp;
char	bcod[10];
char	ecod[10];
int	cc;
char	code[512];
char	ibuf[518];
char	line[512];

main(argc, argv)
char **argv;
{
	register a, c;

	a = 0;
	stk[0] = EOF;

	for(;;)
	switch(c=getchar()) {

	case '\n':
		if(!a)
			error();
		stack(EOF);

	case '\0':
		goto exec;
		return;

	case ')':
		if(!a)
			error();
		stack(RP);
		continue;

	case '|':
		if(!a)
			error();
		a = 0;
		stack(ALT);
		continue;

	case '*':
		if(!a)
			error();
		stack(CLO);
		continue;

	default:
		if(a)
			stack(JUX);
		a = 1;
		stack(ALP);
		out(c);
		continue;

	case '(':
		if(a)
			stack(JUX);
		stack(LP2);
		a = 0;
		continue;
	}

exec:
/*
	for(a=0; a<cc; a++)
		printf("%2d %d\n", a, code[a]);
	printf("\n\n");
 */
	if(argc > 1) {
		if(fopen(argv[1], ibuf) < 0) {
			printf("cannot open %s\n", argv[1]);
			exit();
		}
		execute();
	}
}

error()
{

	printf("error\n");
	exit();
}

stack(p)
{

	while(p <= stk[sp]) {
		if(stk[sp] == LP1) {
			if(p != RP)
				error();
			sp--;
			return;
		}
		out(stk[sp]);
		sp--;
	}
	if(p == LP2)
		p = LP1;
	sp++;
	stk[sp] = p;
}

out(c)
{
	register a, b;

/*
	printf("%d%c", c, c==EOF? '\n': ' ');
 */
	a = cc;
	b = a;
	switch(c) {

	default:
		code[a++] = CHR;
		code[a++] = c;
		bcod[cp] = b;
		ecod[cp] = a;
		cp++;
		cc = a;
		return;

	case EOF:
		code[a++] = END;
		cc = a;
		return;

	case ALT:
		b =+ 5;
		cc = b;
		code[--b] = SYN;
		a = ecod[cp-1];
		while(a > bcod[cp-1])
			code[--b] = code[--a];
		code[--b] = cc-1;
		code[b] =- b-1;
		code[--b] = TRA;
		a = ecod[cp-2];
		while(a > bcod[cp-2])
			code[--b] = code[--a];
		code[--b] = bcod[cp-1]+4;
		code[b] =- b-1;
		code[--b] = OR;
		cp--;
		ecod[cp-1] = cc;
		return;

	case JUX:
		ecod[cp-2] = ecod[cp-1];
		cp--;
		return;

	case CLO:
		b =+ 5;
		cc = b;
		code[--b] = bcod[cp-1];
		code[b] =- b-1;
		code[--b] = TRA;
		a = ecod[cp-1];
		while(a > bcod[cp-1])
			code[--b] = code[--a];
		code[--b] = cc;
		code[b] =- b-1;
		code[--b] = OR;
		code[--b] = SYN;
		ecod[cp-1] = cc;
		return;

	case ALP:
		return;
	}
}

execute()
{
	register char *cl, *nl;
	register pc;
	char *inl, *icl, *fcl, *lp;
	int chr;

	inl = ecod;
	icl = bcod;
	nl = inl;

nline:
	cl = line;
	do {
		pc = getc(ibuf);
		if(pc == -1)
			exit();
		*cl++ = pc;
	} while(pc != '\n');
	*cl++ = '\0';
	chr = 0;
	lp = line;

advance:
	if(chr == '\n')
		goto nline;
	chr = *lp++;
	for(cl = code; pc = *cl;)
		if(pc == SYN || pc == NOP)
			*cl++ = SYN; else
			cl =+ 2;

	*nl++ = 0;
	*nl = -1;
	fcl = nl;
	nl = icl;
	icl = inl;
	inl = nl;
	cl = icl;

adv:
	if((pc = *cl++) < 0)
		goto advance;
sw:
	switch(code[pc]) {

	case END:
		printf("%s", line);
		goto adv;

	case TRA:
		pc =+ code[pc+1];
		goto sw;

	case CHR:
		if(code[pc+1] == chr)
			*nl++ = pc+2;
		goto adv;

	case OR:
		*fcl++ = code[pc+1] + pc;
		*fcl = -1;
		pc =+ 2;
		goto sw;

	case SYN:
		code[pc] = NOP;
		pc++;
		goto sw;

	case NOP:
		goto adv;

	default:
		printf("bad\n");
		abort();
	}
}
