/ DC/KL/DM subroutines

m2741 = 1			/ 2741's handled

hoglimit = 256			/ chars allowed in raw Q

/ transfer raw input Q to canon input Q, doing
/ erase and kill processing, 2741 code conversion,
/ and EOF detection

canon:
	movb	i.rawiq(r4),r1
	tstb	i.delct(r4)		/ any read delimiters?
	bne	2f
	jsr	pc,sleep
	br	canon
2:
	mov	$canonb,r3
1:
	cmp	r3,$ecanonb
	bhis	2f
	jsr	pc,getc
		halt
	mov	r0,r2
	bic	$!177,r0
	jsr	r5,cesc; '#
		br 1b
	jsr	r5,cesc; '@
		br 2b
	movb	r0,(r3)+
	tstb	r2			/ test delimiter
	bpl	1b
	decb	i.delct(r4)		/ delimiter count
	movb	i.caniq(r4),r1
	mov	$canonb,r2
1:
	cmp	r2,r3
	bhis	1f
	movb	(r2)+,r0
	cmp	r0,$004			/ EOT char
	bne	2f
	bit	$040,i.mode(r4)		/ raw mode?
	bne	2f
	cmp	r3,$canonb+1
	bne	1f			/ return immediately
	mov	$377,r0			/ return EOF
2:
	jsr	pc,putc
		br 3f
	br	1b
3:
	jsr	pc,timeout
	br	2b
1:
	rts	pc

cesc:
	cmp	r0,(r5)+
	bne	1f
	cmp	r3,$canonb
	blos	2f
	dec	r3
	cmpb	(r3),$'\\
	bne	2f
1:
	tst	(r5)+
2:
	rts	r5

/ put a character on output list, calculating
/ delays, CR-NL mapping, tab expansion

ttyoutput:
	mov	r0,r2
	beq	2f			/ null, ignore
	cmp	r2,$004			/ EOT char?
	bne	1f
2:
	rts	pc			/ ignore it
1:
	movb	i.canoq(r4),r1
/ first, tab-to-space
	cmp	r0,$011			/ tab
	bne	1f
	bit	$2,i.mode(r4)		/ t-to-s mode
	beq	1f
	mov	$040,r0			/ space
2:
	jsr	pc,1f
		rts pc			/ won't fit
	bitb	$7,i.colct(r4)		/ up to 0 mod 8
	bne	2b
	add	$2,(sp)
	rts	pc
1:
/ CR mode
	cmp	r0,$'\n			/ newline
	bne	1f
	bit	$020,i.mode(r4)		/ CR->NL mode
	beq	1f
	mov	$'\r,r0			/ CR
	jsr	pc,1f
		rts pc
	mov	r2,r0			/ put back NL
1:
/ put the character
	jsr	pc,putc
		rts pc			/ won't fit
/ now delay calculations
	tstb	r0
	bmi	1f			/ already a delay
	movb	partab(r0),r0
	bic	$!17,r0
	beq	2f			/ plain old char
	jmp	*3f-2(r0)
2:
	inc	i.colct(r4)		/ column++
	br	2f

3:
	br	2f			/ non printing
	br	bs
	br	nl
	br	tab
	br	vert
	br	cr

bs:
	decb	i.colct(r4)
	bge	2f
	clrb	i.colct(r4)
	br	2f

nl:
	movb	i.colct(r4),r2		/ col #
	clrb	i.colct(r4)
	ash	$-4,r2			/ col/16
	add	$8,r2
	neg	r2
	br	1f

tab:
	movb	i.colct(r4),r2
	bisb	$7,i.colct(r4)
	incb	i.colct(r4)		/ col = 0 mod 8
	bis	$!7,r2
	sub	$5,r2
	br	1f

vert:
	mov	$-176,r2		/ delay = lots
	br	1f

cr:
	mov	$-13,r2			/ 100ms for TN300
	clrb	i.colct(r4)
	br	1f

1:
	jsr	pc,putc
		rts pc			/ won't fit
2:
	add	$2,(sp)
	rts	pc

/ put char on raw input queue,
/ setting canon delimiter
/ and waking up top half
/ if appropriate, also echoing

ttyinput:
	bic	$!177,r0
	bit	$020,i.mode(r4)		/ CR mode?
	beq	1f
	cmpb	r0,$'\r			/ CR
	bne	1f
	mov	$'\n,r0
1:
	cmpb	r0,$177			/ interrupt
	beq	2f
	cmpb	r0,$034			/ quit
	bne	1f
2:
	bit	$040,i.mode(r4)		/ raw mode
	bne	1f
	jsr	pc,empty
	jsr	pc,signal
	rts	pc
1:
	cmp	c.count(r1),$hoglimit
	bgt	9f			/ creep, ignore char
	bit	$004,i.mode(r4)		/ UC mode?
	beq	1f
	cmp	r0,$'A
	blo	1f
	cmp	r0,$'Z
	bhi	1f
	add	$'a-'A,r0
1:
.if	m2741
	bit	$400,i.mode(r4)		/ 2741?
	beq	3f
	bic	$!77,r0
	cmpb	r0,$55			/ 2741 NL
	beq	2f			/ yes, delimiter
	br	1f
3:
.endif
	bit	$040,i.mode(r4)		/ raw?
	bne	2f
	cmp	r0,$'\n			/ newline?
	beq	2f
	cmp	r0,$004			/ EOT?
	bne	1f
2:
	bis	$200,r0			/ set delimiter
1:
	jsr	pc,putc			/ onto input Q
		rts pc			/ won't go, ignore
	tstb	r0			/ delimiter?
	bpl	1f
	inc	i.delct(r4)
1:
	jsr	pc,wakeup
	bit	$010,i.mode(r4)		/ echo mode?
	beq	1f
	bic	$!177,r0
	mov	r0,r2
	jsr	pc,ttyoutput
		rts pc
1:
	rts	pc

ttyopen:
	cmpb	i.nused(r4),$1		/ first open?
	bne	1f
	clr	i.mode(r4)
	clrb	i.ctl(r4)
	clr	i.delct(r4)
	jsr	pc,allocl
	movb	r1,i.rawiq(r4)
	jsr	pc,allocl
	movb	r1,i.caniq(r4)
	jsr	pc,allocl
	movb	r1,i.canoq(r4)
1:
	rts	pc

ttyclose:
	jsr	pc,empty
	movb	i.rawiq(r4),r1
	jsr	pc,freel
	movb	i.caniq(r4),r1
	jsr	pc,freel
	movb	i.canoq(r4),r1
	jsr	pc,freel
	rts	pc

/ empty tty queues
empty:
	movb	i.caniq(r4),r1
	jsr	pc,empty1
	movb	i.canoq(r4),r1
	jsr	pc,empty1
	movb	i.rawiq(r4),r1
	jsr	pc,empty1
	clrb	i.delct(r4)
	rts	pc

empty1:
	jsr	pc,getc
		rts pc
	br	empty1

.bss

canonb:.=.+256.
ecanonb:

.text

.if m2741
inl938:
	.byte	' , '-, '@, '&, '8, 'q, 'y, 'h
	.byte	'4, 'm, 'u, 'd, 00, 00, 00, 00
	.byte	'2, 'k, 's, 'b, '0, '?, '?, '?
	.byte	'6, 'o, 'w, 'f, 00, 10, 00, 00
	.byte	'1, 'j, '/, 'a, '9, 'r, 'z, 'i
	.byte	'5, 'n, 'v, 'e, 00, 12, 12, 11
	.byte	'3, 'l, 't, 'c, '#, '$, ',, '.
	.byte	'7, 'p, 'x, 'g, 00, 00, 00, 00

inh938:
	.byte	' , '_, '\\, '+, '*, 'Q, 'Y, 'H
	.byte	':, 'M, 'U, 'D, 00, 00, 00, 00
	.byte	'<, 'K, 'S, 'B, '), '?, '?, '?
	.byte	'', 'O, 'W, 'F, 00, 10, 00, 00
	.byte	'=, 'J, '?, 'A, '(, 'R, 'Z, 'I
	.byte	'%, 'N, 'V, 'E, 00, 12, 12, 11
	.byte	';, 'L, 'T, 'C, '", '!, '|, '^
	.byte	'>, 'P, 'X, 'G, 00, 00, 00, 00

out938:
	.byte	077, 077, 077, 077, 077, 077, 077, 077
	.byte	035, 057, 055, 077, 077, 055, 077, 077
	.byte	077, 077, 077, 077, 077, 077, 077, 077
	.byte	077, 077, 077, 077, 077, 077, 077, 077
	.byte	000, 265, 264, 164, 165, 250, 103, 230
	.byte	244, 224, 204, 203, 166, 101, 167, 142
	.byte	124, 140, 120, 160, 110, 150, 130, 170
	.byte	104, 144, 210, 260, 220, 240, 270, 242
	.byte	102, 243, 223, 263, 213, 253, 233, 273
	.byte	207, 247, 241, 221, 261, 211, 251, 231
	.byte	271, 205, 245, 222, 262, 212, 252, 232
	.byte	272, 206, 246, 000, 202, 000, 267, 201
	.byte	230, 143, 123, 163, 113, 153, 133, 173
	.byte	107, 147, 141, 121, 161, 111, 151, 131
	.byte	171, 105, 145, 122, 162, 112, 152, 132
	.byte	172, 106, 146, 000, 266, 000, 000, 077

outcorr:
	.byte	077, 077, 077, 077, 077, 077, 077, 077
	.byte	035, 057, 055, 077, 077, 077, 077, 077
	.byte	077, 077, 077, 077, 077, 077, 077, 077
	.byte	077, 077, 077, 077, 077, 077, 077, 077
	.byte	000, 101, 211, 260, 204, 210, 250, 111
	.byte	264, 244, 270, 223, 173, 167, 121, 107
	.byte	144, 106, 120, 160, 104, 110, 130, 150
	.byte	170, 164, 253, 153, 000, 123, 000, 207
	.byte	220, 271, 266, 272, 252, 212, 263, 243
	.byte	246, 231, 203, 232, 206, 241, 222, 205
	.byte	213, 233, 251, 245, 202, 262, 261, 265
	.byte	242, 247, 224, 240, 230, 140, 201, 267
	.byte	111, 171, 166, 172, 152, 112, 163, 143
	.byte	146, 131, 103, 132, 106, 141, 122, 105
	.byte	113, 133, 151, 145, 102, 162, 161, 165
	.byte	142, 147, 124, 000, 000, 000, 000, 075
.endif

partab:
	.byte 002,202,202,002,202,002,002,202
	.byte 204,010,006,212,012,214,202,002
	.byte 202,002,002,202,002,202,202,002
	.byte 002,202,202,002,202,002,002,202
	.byte 200,000,000,200,000,200,200,000
	.byte 000,200,200,000,200,000,000,200
	.byte 000,200,200,000,200,000,000,200
	.byte 200,000,000,200,000,200,200,000
	.byte 200,000,000,200,000,200,200,000
	.byte 000,200,200,000,200,000,000,200
	.byte 000,200,200,000,200,000,000,200
	.byte 200,000,000,200,000,200,200,000
	.byte 000,200,200,000,200,000,000,200
	.byte 200,000,000,200,000,200,200,000
	.byte 200,000,000,200,000,200,200,000
	.byte 000,200,200,000,200,000,000,202

