#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

/*
 * Invoked by vmread to implement the fetch command.
 */

char userid[9], system[9], myfile[200], hisfile[200];
main()
{
	struct passwd *pw;
	struct stat sb;

	scanf("%s", userid);
	scanf("%s", system);
	scanf("%s", myfile);
	scanf("%s", hisfile);
	if(myfile[0] != '/') { /* unqualified */
		if((pw = getpwnam(userid)) == NULL)
			err("Unqualified file name");
		chdir(pw->pw_dir);
	}
	if(stat(myfile, &sb) < 0)
		err("Non-existent file");
	if((sb.st_mode & 0444) != 0444) /* must be readable by all */
		err("File not publicly readable");
	execl("/bin/vmpunch", "vmpunch", myfile, "-f", hisfile,
		"-i", userid, "-v", system, "-r", "-s", 0);
	exit(1);
}

err(s)
char *s;
{
	char msg[200], dest[20], *vmid();

	sprintf(msg, "Can't fetch \"%s\" from %s: %s.", myfile, vmid(), s);
	sprintf(dest, "%s!%s", system, userid);
	notify(dest, msg, 0);
	exit(1);
}
