%{
#include "style.h"
#include "names.h"
#include "conp.h"
#ifdef NOMIN
FILE *deb;
#endif
int part   = 0;
int pstyle = 0;
int sstyle = 0;
int rstyle = 0;
int estyle = 0;
int nstyle = 0;
int sthresh;
int rthresh;
int nomin;
char s[SCHAR];
char *sptr = s;
struct ss sent[SLENG];
struct ss *sentp = sent;
float wperc();
float sperc();
float typersent();
float vperc();
int numsent = 0;
int qcount = 0;
int icount = 0;
vowel = 0;
numwds = 0;
twds = 0;
numnonf = 0;
letnonf = 0;
int maxsent = 0;
int maxindex = 0;
int minsent = 30;
int minindex = 0;
int simple = 0;
int compound = 0;
int compdx = 0;
int prepc = 0;
int conjc = 0;
int complex = 0;
int tobe = 0;
int adj = 0;
int infin = 0;
int pron = 0;
int passive = 0;
int aux = 0;
int adv = 0;
int verbc = 0;
int tverbc = 0;
int noun = 0;
numlet = 0;
int beg[15]  = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
int sleng[50];
int j,jj,i;
int comma = 0;
int cflg;
int question;
int quote = 0;
char *st;
int over = 1;
%}
C	[A-DF-Za-z]
%%
^{C}:.+	{
collect:
	sentp->cc = sentp->ic = yytext[0];
	if(sentp->cc == NOM)
		sentp->cc = NOUN;
collect1:
	sentp->leng = yyleng-2;
	sentp++->sp = sptr;
	if(sentp >= &sent[SLENG-1]){
		if (over) fprintf (stderr, "style: part: sentence %d has too many words\n", numsent+2);
		over=0;
		sentp--;
	}
	if(sptr+yyleng >= &s[SCHAR-1]){
		if (over) fprintf (stderr, "style: part: sentence %d has too many characters\n", numsent+2);
		over=0;
	}
	else {
		for(i=2;i<yyleng;i++)*sptr++=yytext[i];
		*sptr++ = '\0';
	}
	}
^";:".+	{
	sentp->cc=END;
	sentp->ic = ';';
	goto collect1;
	}
^",:".+	{
	comma++;
	goto collect;
	}
^",:"[:,-]+	{
	comma++;
	goto collect;
	}
[\n]	;
^"\":".+	{
	goto collect;
	}
^E:"/."	{
	cflg = 1;
	goto sdone;
	}
^E:"!"	{
	cflg = 1;
	goto sdone;
	}
^E:.+	{
	cflg = 0;
sdone:
	over=1;
	sentp->cc=sentp->ic=END;
	sentp++->sp = sptr;
	for(i=2;i<yyleng;i++)*sptr++=yytext[i];
	*sptr++='\0';
	if(yytext[2]=='?')question=1;
	else question=0;

	jj=0;
	if(quote == 1 && sent[jj].cc == ED){
		sent[jj].cc = VERB;
		quote = 0;
	}
	if(sent[jj].cc=='"')jj++;
	if(sent[jj].cc==SUBCONJ){
		if(sent[jj+1].cc == ','){
			sent[jj].cc=ADV;
			jj += 2;
			comma--;
		}
		else {
			jj=scan(1,',',0);
			if(jj != -1)jj++;
			comma--;
		}
	}
	if(jj != -1){
		if(sent[jj].cc==CONJ || sent[jj].cc=='"')jj++;
		while((jj=scan(jj,END,cflg)) != -1){
			jj++;
			if(sent[jj].cc == SUBCONJ && sent[jj+1].cc == ','){
				sent[jj].cc=ADV;
				jj += 2;
				comma--;
			}
		}
	}
	st = sent[i].sp;
	if(*(st+1) == '"')
		if(*st == '?' || *st == '!')quote = 1;
	outp();
	sptr=s;
	sentp=sent;
	comma=0;
	}
;.+	{
	if(!part){
		nomin = atoi(&yytext[1]);
	}
	;
	}
%%
yywrap(){
	int ii;
	int ml,mg,lsum,gsum;
	float aindex, avl, avw;
	float cindex,kindex,findex,fgrad;
	float syl, avsy, adjs,snonf;
#ifdef CATCH
	FILE *io;
#endif

	if (!part && !rstyle &&!sstyle && !pstyle && !estyle && !nstyle) {
		if(numwds == 0 || numsent == 0)exit(0);
		avw = (float)(numwds)/(float)(numsent);
		avl = (float)(numlet)/(float)(numwds);
		aindex = 4.71*avl + .50*avw - 21.43;
		syl = .9981*vowel - .3432*twds;
		avsy = syl/twds;
		kindex = 11.80*avsy + .39*avw - 15.59;
		findex = 206.835 - 84.60*avsy - 1.015*avw;
		if (findex < 30.) fgrad = 17.;
		else if(findex > 100.) fgrad = 4.;
		else if(findex > 70.)fgrad=(100.-findex)/10 +5.;
		else if(findex > 60.)fgrad =(70.-findex)/10+8.;
		else if(findex >50.)fgrad=(60.-findex)/5+10;
		else fgrad=(50.-findex)/6.66 +13.;
		adjs = 100 * (float)numsent/(float)numwds;
		cindex = 5.89*avl-.30*adjs-15.80;
		printf("readability:    mean grade level: %4.01f\n",
			(kindex+aindex+cindex+fgrad)/4);
		printf("        Kincaid %4.01f,   ARI %4.01f,",kindex,aindex);
		printf("   Coleman-Liau %4.01f,   Flesch %4.01f\n",cindex,fgrad);
		printf("sentence lengths:    %d sentences, %d words, %d letters\n",
			numsent, numwds, numlet);
		printf("        mean words/sentence: %4.01f,     mean letters/word:   %4.01f\n",
			avw,avl);
		mg = avw + 10.50;
		if(mg > 49)mg = 49;
		ml = avw - 4.50;
		if(ml <= 0)ml = 1;
		else if(ml > 49)ml=48;
		gsum = lsum = 0;
		for(ii=0;ii<50;ii++){
			if(ii < ml)lsum += sleng[ii];
			else if(ii > mg)gsum+= sleng[ii];
		}
		printf("        %d short sentences, <%d words, %4.01f%%, shortest has %d words\n",
			lsum,ml,sperc(lsum),minsent);
		printf("        %d  long sentences, >%d words, %4.01f%%, longest has %d words\n",
			gsum,mg,sperc(gsum),maxsent);
		printf("        %d questions, %d imperative sentences\n",
			qcount,icount);
		if(numnonf != 0){
			snonf = (float)(letnonf)/(float)(numnonf);
		}
		printf("        %4.01f%% non-functional words, mean length: %4.01f letters\n",
			(float)(numnonf)*100/numwds,snonf);
		printf("sentence types:    out of %d total sentences\n",
			numsent);
		printf("        %4d simple   %4.01f%%,    %4d complex    %4.01f%%,\n",
			simple, sperc(simple), complex, sperc(complex));
		printf("        %4d compound %4.01f%%,    %4d cmpd-cmplx %4.01f%%\n",
			compound, sperc(compound), compdx, sperc(compdx));
		printf("sentence beginnings:    out of %d total sentences\n",
			numsent);
		ii=beg[0]+beg[7]+beg[6]+beg[3]+beg[8];
		printf("        %5d prep %4.01f%%, %5d verb%5.01f%%,%6d conjunct %4.01f%%,\n",
			beg[9], sperc(beg[9]), beg[1]+beg[10]+beg[11],
		        sperc(beg[1]+beg[10]+beg[11]), beg[5], sperc(beg[5]));
		printf("        %5d expl %4.01f%%, %5d adv %5.01f%%,%6d sub-conj %4.01f%%,\n",
		        beg[14], sperc(beg[14]), beg[4], sperc(beg[4]),
		        beg[13], sperc(beg[13]));
		printf("        %5d subj %4.01f%%:\n", ii, sperc(ii));
		printf("        %d nouns, %d pronouns, %d possessives, %d adjectives, %d articles\n",
			beg[0],beg[7],beg[6],beg[3],beg[8]);
		printf("word usage:    out of %d total words\n", numwds);
		printf("        %4d prep %4.01f%%, %4d conj %4.01f%%, %4d adv %4.01f%%, %4d nom %4.01f%%,\n",
			prepc, wperc(prepc), conjc, wperc(conjc),
			adv,   wperc(adv),   nomin, wperc(nomin));
		printf("        %4d noun %4.01f%%, %4d pron %4.01f%%, %4d adj %4.01f%%\n",
			noun,  wperc(noun),  pron,  wperc(pron), adj, wperc(adj));
		printf("verb usage:    out of %d total verbs\n",
			tverbc);
		printf("        %d to be %4.01f%%,   %d auxiliary %4.01f%%,   %d infinitives %4.01f%%\n",
			tobe,vperc(tobe),aux,vperc(aux),infin,vperc(infin));
		if(verbc != 0)adjs = (float)(passive)*100/(float)(verbc);
		else adjs=0;
		printf("        %d passive verbs are %2.01f%% of all noninfinitive verbs\n",
			passive,adjs);
#ifdef CATCH
		if((io=fopen(CATCH,"a")) != NULL) {
			fprintf(io,"\nread  %5.01f%5.01f%5.01f%5.01f%5.01f\n",
				kindex, aindex, cindex, findex, fgrad);
			fprintf(io,"sentl %5d%5d%5.01f%5.01f%5d%5d%5d%5.01f\n",
				numsent,numwds,avw,avl,qcount,icount,numnonf,snonf);
			fprintf(io,"l var %5d%5d%5d%5d%5d\n",
				ml,lsum,mg,gsum,maxsent);
			fprintf(io,"t var %5d%5d%5d%5d\n",
				simple,complex,compound,compdx);
			fprintf(io,"verbs %5d%5d%5d%5d%5d%5d\n",
				tverbc,verbc,tobe,aux,infin,passive);
			fprintf(io,"ty    %5d%5d%5d%5d%5d%5d%5d\n",
				prepc,conjc,adv,noun,adj,pron,nomin);
			fprintf(io,"beg   %5d%5d%5d%5d%5d%5d\n",
				beg[0],beg[7],beg[6],beg[3],beg[8],ii);
			fprintf(io,"sbeg  %5d%5d%5d%5d%5d%5d\n",
				beg[9],beg[4],beg[1]+beg[10]+beg[12],beg[13],beg[5],beg[14]);
		}
#endif
	}
	return(1);
}
float
wperc(a)
{
	return((float)(a)*100/numwds);
}
float
sperc(a)
{
	return((float)(a)*100/numsent);
}
float
vperc(a)
{
	if(tverbc == 0)return(0);
	return((float)(a)*100/tverbc);
}
main(argc,argv)
char **argv;
{
	while (--argc > 0 && (++argv)[0][0] == '-' ) {
		switch (argv[0][1]) {
		case 'a':
			pstyle = 1;
			estyle = 1;
			nstyle = 1;
			sstyle = 1;
			rstyle = 1;
			sthresh = 0;
			rthresh = 0;
			part = 0;
			break;
		case 'p':
			pstyle = 1; part = 0;
			break;
		case 'e':
			estyle = 1; part = 0;
			break;
		case 'n':
			nstyle = 1; part = 0;
			break;
		case 's':
			sstyle = 1; part = 0;
			sthresh = atoi(*(++argv));
			break;
		case 'r':
			rstyle = 1; part = 0;
			rthresh = atoi(*(++argv));
			break;
		case 'w':
			part = 1;
			pstyle = 0;
			estyle = 0;
			nstyle = 0;
			sstyle = 0;
			rstyle = 0;
			break;
		default:
			fprintf (stderr, "style: part: unknown %s flag\n", *argv);
			exit(1);
			break;
		}
	}
#ifdef NOMIN
	deb = fopen(NOMIN,"a");  /* save nominalizations */
#endif
	yylex();
}
