/* /usr/lib/makeremind produces an fgrep -f file
 * that will select today's and tomorrow's
 * reminder entries, with special weekend provisions
 *
 * used by remind command
 */
#include <time.h>
#include <sys/types.h>

#define DAY (3600*24L)

char *month[] = {
	"january",   "february",  "march",     "april",
        "may",       "june",      "july",      "august",
        "september", "october",   "november",  "december"
};

char *mon_3[] = {
	"jan",       "feb",       "mar",       "apr",
        "may",       "jun",       "jul",       "aug",
        "sep",       "oct",       "nov",       "dec"
};

char *day[] = {
	"sunday",    "monday",    "tuesday",   "wednesday",
        "thursday",  "friday",    "saturday"
};

struct tm *localtime();

tprint(t)
time_t t;
{
	char date[99];

	struct tm *tm;
	tm = localtime(t);
	sprintf(date, "%s %02d", month[tm->tm_mon], tm->tm_mday);
	put_ul(date);
	sprintf(date, "%s %02d", mon_3[tm->tm_mon], tm->tm_mday);
	put_ul(date);
	printf("%d/%02d\n", tm->tm_mon+1, tm->tm_mday);
	put_ul(day[tm->tm_wday]);
}

put_ul(date)
char *date;
{
	printf("%s\n", date);
	date[0] -= 040;
	printf("%s\n", date);
}

main()
{
	time_t t;
	put_ul("today");
	t = time();
	tprint(t);
	switch(localtime(t)->tm_wday) {
	case 5:
		t += DAY;
		tprint(t);
	case 6:
		t += DAY;
		tprint(t);
	default:
		t += DAY;
		tprint(t);
	}
}
