#include "../h/param.h"
#include "../h/systm.h"
#include "../h/370.h"
#include "../h/dir.h"
#include "../h/user.h"

/*
 * Routines to transfer data between system and user
 */

/*
 * copy from user to system address
 */
copyin(uadd, sadd, length)
caddr_t uadd, sadd;
int length;
{
	register int a, b;
	register caddr_t radd;

	while( length ) {
		a = PSIZE - ((int)uadd & PMASK);
		b = (a > length) ? length : a;
		radd = ldreal( uadd );
		if((int)radd == -1)
			return(1);
		a_mvcl(radd, b, sadd, b);
		sadd += b;
		uadd += b;
		length -= b;
	}
	return( 0 );
}

/*
 * copy from system to user address
 */
copyout(sadd, uadd, length)
caddr_t sadd, uadd;
int length;
{
	register int a, b;
	register caddr_t radd;

	while( length) {
		a = PSIZE - ((int)uadd & PMASK);
		b = (a > length) ? length : a;
		radd = ldreal( uadd );
		if((int)radd == -1)
			return(1);
		if (isk(radd) != USERKEY)
			return(1);
		a_mvcl(sadd, b, radd, b);
		length -= b;
		sadd += b;
		uadd += b;
	}
	return(0);
}

/*
 * set user word
 */
suword(vadd, val)
caddr_t vadd;
int val;
{
	register caddr_t su;

	if (((int) vadd & ~PMASK) != (((int) vadd + 3) & ~PMASK)) {  /* word crosses page boundry */
		if (subyte(vadd, (char) (val << 24)))
			return(-1);
		if (subyte(vadd + 1, (char) (val << 16)))
			return(-1);
		if (subyte(vadd + 2, (char) (val << 8)))
			return(-1);
		return(subyte(vadd + 3, (char) val));
	}
	su = ldreal(vadd);
	if((int)su == -1)
		return(-1);
	if(isk(su) != USERKEY)
		return(-1);
	*(int *)su = val;
	return(0);
}

/*
 * set user byte
 */
subyte(vadd, val)
caddr_t vadd;
char val;
{

	register caddr_t su;

	su = ldreal(vadd);
	if((int)su == -1)
		return(-1);
	if(isk(su) != USERKEY)
		return(-1);
	*su = val;
	return(0);
}

/*
 * fetch user word
 */
fuword(vadd)
caddr_t vadd;
{
	register int *fuw;
	register int t;
	register int r;

	if (((int) vadd & ~PMASK) != (((int) vadd + 3) & ~PMASK)) {  /* word crosses page boundry */
		if ((r = fuword(vadd)) == -1)
			return(-1);
		if ((t = fuword(vadd + 1)) == -1)
			return(-1);
		r = (r << 8) | t;
		if ((t = fuword(vadd + 2)) == -1)
			return(-1);
		r = (r << 8) | t;
		if ((t = fuword(vadd + 2)) == -1)
			return(-1);
		return((r << 8) | t);
	}
	fuw = (int *)ldreal(vadd);
	if((int)fuw == -1)
		return(-1);
	return(*fuw);
}

/*
 * fetch user byte
 */
fubyte(vadd)
caddr_t vadd;
{
	register char *fu;

	fu = (char *)ldreal(vadd);
	if((int)fu == -1)
		return(-1);
	return(*fu);
}
