#include "../h/param.h"
#include "../h/systm.h"

/*
 * This table is the switch used to transfer
 * to the appropriate routine for processing a system call.
 * Each row contains the number of arguments expected
 * and a pointer to the routine.
 */
int	alarm();
int	mpxchan();
int	chdir();
int	chmod();
int	chown();
int	chroot();
int	close();
int	creat();
int	dup();
int	exec();
int	exece();
int	fork();
int	fstat();
int	getgid();
int	getpid();
int	getuid();
int	gtime();
int	gtty();
int	ioctl();
int	kill();
int	link();
int	mknod();
int	nice();
int	nosys();
int	nullsys();
int	open();
int	pause();
int	pipe();
int	ptrace();
int	read();
int	rexit();
int	saccess();
int	sbreak();
int	seek();
int	setgid();
int	setuid();
int	smount();
int	ssig();
int	stat();
int	stime();
int	stty();
int	sumount();
int	ftime();
int	sync();
int	sysacct();
int	times();
int	umask();
int	unlink();
int	utime();
int	wait();
int	write();

int     acctwrt();
int     cpcmnd();
int     freeze();
int     getinf();
int     pio();
int     rsig();
int     setinf();
int     sigtrace();
int     thaw();
int     vmid();

struct sysent sysent[] =
{
	0, nullsys,			/*  0 = indir */
	1, rexit,			/*  1 = exit */
	0, fork,			/*  2 = fork */
	3, read,			/*  3 = read */
	3, write,			/*  4 = write */
	2, open,			/*  5 = open */
	1, close,			/*  6 = close */
	0, wait,			/*  7 = wait */
	2, creat,			/*  8 = creat */
	2, link,			/*  9 = link */
	1, unlink,			/* 10 = unlink */
	2, exec,			/* 11 = exec */
	1, chdir,			/* 12 = chdir */
	0, gtime,			/* 13 = time */
	3, mknod,			/* 14 = mknod */
	2, chmod,			/* 15 = chmod */
	3, chown,			/* 16 = chown; now 3 args */
	1, sbreak,			/* 17 = break */
	2, stat,			/* 18 = stat */
	3, seek,                        /* 19 = seek; now 3 args */
	0, getpid,			/* 20 = getpid */
	3, smount,			/* 21 = mount */
	1, sumount,			/* 22 = umount */
	1, setuid,			/* 23 = setuid */
	0, getuid,			/* 24 = getuid */
	2, stime,			/* 25 = stime */
	4, ptrace,			/* 26 = ptrace */
	1, alarm,			/* 27 = alarm */
	2, fstat,			/* 28 = fstat */
	0, pause,			/* 29 = pause */
	2, utime,			/* 30 = utime */
	2, stty,			/* 31 = stty */
	2, gtty,			/* 32 = gtty */
	2, saccess,			/* 33 = access */
	1, nice,			/* 34 = nice */
	1, ftime,			/* 35 = ftime; formerly sleep */
	0, sync,			/* 36 = sync */
	2, kill,			/* 37 = kill */
	0, nullsys,			/* 38 = switch; inoperative */
	0, nullsys,			/* 39 = setpgrp (not in yet) */
	1, nosys,			/* 40 = tell (obsolete) */
	2, dup,                         /* 41 = dup */
	0, pipe,			/* 42 = pipe */
	1, times,			/* 43 = times */
	0, nosys,                       /* 44 = prof */
	0, nosys,			/* 45 = unused */
	1, setgid,			/* 46 = setgid */
	0, getgid,			/* 47 = getgid */
	2, ssig,			/* 48 = sig */
	0, nosys,			/* 49 = reserved for USG */
	0, nosys,			/* 50 = reserved for USG */
	1, sysacct,			/* 51 = turn acct off/on */
	0, nosys,                       /* 52 = set user physical addresses */
	0, nosys,                       /* 53 = lock user in core */
	3, ioctl,			/* 54 = ioctl */
	0, nosys,			/* 55 = readwrite (in abeyance) */
	4, mpxchan,			/* 56 = creat mpx comm channel */
	0, nosys,			/* 57 = reserved for USG */
	0, nosys,			/* 58 = reserved for USG */
	3, exece,			/* 59 = exece */
	1, umask,			/* 60 = umask */
	1, chroot,			/* 61 = chroot */
	0, nosys,			/* 62 = x */
	0, nosys,                       /* 63 = used internally */
	/* added at  a m d a h l */
	1, freeze,                      /* 64 = freeze filesystem activity */
	1, thaw,                        /* 65 = thaw filesystem activity */
	1, cpcmnd,                      /* 66 = issue CP command */
	1, setinf,                      /* 67 = set user info */
	1, getinf,                      /* 68 = get user info */
	1, vmid,                        /* 69 = get virtual machine ID */
	0, rsig,                        /* 70 = return from signal */
	5, pio,                         /* 71 = child process i/o */
	3, sigtrace,                    /* 72 = specify signals to be traced */
	2, acctwrt,                     /* 73 = write accounting record */
	0, nosys,                       /* 74 = x */
	0, nosys,                       /* 75 = x */
	0, nosys,                       /* 76 = VM error recording */
	0, nosys,                       /* 77 = x */
	0, nosys,                       /* 78 = x */
	0, nosys,                       /* 79 = x */
	0, nosys,                       /* 80 = x */
};

int nsysent = sizeof sysent/sizeof(struct sysent);
