/*/
/   Everything in this file is in two languages:
/   The assembler code (C comments) is what is actually used,
/   the C code (assembler comments) is used by lint for type checking.
/*/

/**/    typedef long cpu_t;
/**/    typedef long tod_t;
/**/    typedef char *caddr_t;

/* Load control registers */
/**/    /*VARARGS 3*/ /*ARGSUSED*/
/**/    a_lctl(from, to, x1) {}
/*/
	entry   a_lctl
a_lctl:
	using   .,r15
	l       r0,0(,sp)       / from register
	n       r0,=x'0000000f'
	sll     r0,4
	l       r1,4(,sp)       / to register
	n       r1,=x'0000000f'
	or      r1,r0
	ex      r1,lctl
	br      r14
lctl:   lctl    0,0,8(sp)
/*/

/* Store TOD clock */
/**/    tod_t a_stck() { return((tod_t)0); }
/*/
	entry   a_stck
a_stck:
	using   .,r15
	l       r1,=a(dbl)
	stck    0(r1)
	lm      r0,r1,0(r1)
	br      r14
/*/

/* Set TOD clock comparator */
/**/    /*ARGSUSED*/
/**/    a_sckc(tod) tod_t tod; {}
/*/
	entry   a_sckc;
a_sckc:
	using   .,r15
	l       r1,=a(dbl)
	mvc     0(8,r1),0(sp)
	sckc    0(r1)
	br      r14
/*/

/* Store TOD clock comparator */
/**/    cpu_t a_stckc() { return((cpu_t)0); }
/*/
	entry   a_stckc;
a_stckc:
	using   .,r15
	l       r1,=a(dbl)
	stckc   0(r1)
	lm      r0,r1,0(r1)
	br      r14
/*/

/* Set CPU timer */
/**/    /*ARGSUSED*/
/**/    a_spt(cpu) cpu_t cpu; {}
/*/
	entry   a_spt
a_spt:
	using   .,r15
	l       r1,=a(dbl)
	mvc     0(8,r1),0(sp)
	spt     0(r1)
	br      r14
/*/

/* Store CPU timer */
/**/    cpu_t a_stpt() { return((cpu_t)0); }
/*/
	entry   a_stpt;
a_stpt:
	using   .,r15
	l       r1,=a(dbl)
	stpt    0(r1)
	lm      r0,r1,0(r1)
	br      r14
/*/

/* Purge translation look-aside buffer */
/**/    a_ptlb() {}
/*/
	entry   a_ptlb
a_ptlb:
	ptlb
	br      r14
/*/

/* Move characters long */
/**/    /*ARGSUSED*/
/**/    a_mvcl(fa, fl, ta, tl) char *fa, *ta; {}
/*/
	entry   a_mvcl
a_mvcl:
/
/       Since mvc is much faster than mvcl on Amdahl machines
/       the following code has been replaced.
/
/       using   .,r15
/       s       sp,=f'16'
/       stm     r2,r5,0(sp)
/       lm      r2,r5,16(sp)
/       mvcl    r4,r2
/       lm      r2,r5,0(sp)
/       a       sp,=f'16'
/       br      r14
/
        drop
        using   .,r15
	s       sp,=f'16'       / drop stack
	st      r2,0(sp)        / save regs
	st      r3,4(sp)
	st      r4,8(sp)
	st      r5,12(sp)
	l       r2,16(sp)       / from addr
	l       r3,20(sp)       / from bytes
	l       r4,24(sp)       / to addr
	l       r5,28(sp)       / to bytes
	ltr     r4,r4           / to addr = 0?
	bz      badmvcl         / yes
	cr      r3,r5           / from bytes = to bytes?
	bne     badmvcl         / no
1:
	c       r3,=f'256'      / more than 256 to go?
	bl      2f              / no - jump out of loop
	mvc     0(256,r4),0(r2) / yes - mvc next 256
	la      r2,256(r2)      / increment from addr
	la      r4,256(r4)      / increment to addr
	s       r3,=f'256'      / decrement count
	b       1b              / back to top of loop
2:
	ltr     r3,r3           / more bytes?
	bz      3f              / no - skip mvc
	s       r3,=f'1'/ decrement for mvc
	ex      r3,mvcinst      / yes - ex mvc
3:
	l       r2,0(sp)        / all done - go home
	l       r3,4(sp)
	l       r4,8(sp)
	l       r5,12(sp)
	la      sp,16(sp)
	br      r14
/
mvcinst:
	mvc     0(,r4),0(r2)
/
badmvcl:
	la      r2,mvclmsg
	st      2,0(sp)
	l       r15,=v(panic)
	balr    r14,r15
/
mvclmsg:
        dc      c'bad call to a_mvcl\0'
/*/

/* Copy one page to another - used by mem.c */
/**/    /*ARGSUSED*/
/**/    copypag(from, to) caddr_t from, to; {}
/*/
	drop
        entry   copypag
        using   copypag,r15
copypag:
	l       r1,0(sp)               / from addr
	st      r2,0(sp)               / save r2
	l       r2,4(sp)               / to addr
	ltr     r2,r2                  / to addr = 0?
	bz      badcpy                 / yes - give up
	mvc     0(256,r2),0(r1)        / copy bytes 0-255
	mvc     256(256,r2),256(r1)    / copy bytes 256-511
	mvc     512(256,r2),512(r1)    / etc.
	mvc     768(256,r2),768(r1)
	mvc     1024(256,r2),1024(r1)
	mvc     1280(256,r2),1280(r1)
	mvc     1536(256,r2),1536(r1)
	mvc     1792(256,r2),1792(r1)
	mvc     2048(256,r2),2048(r1)
	mvc     2304(256,r2),2304(r1)
	mvc     2560(256,r2),2560(r1)
	mvc     2816(256,r2),2816(r1)
	mvc     3072(256,r2),3072(r1)
	mvc     3328(256,r2),3328(r1)
	mvc     3584(256,r2),3584(r1)
	mvc     3840(256,r2),3840(r1)
	l       r2,0(sp)               / restore r2
	br	r14
/
badcpy:
	la      r2,cpymsg
	st      2,0(sp)
	l       r15,=v(panic)
	balr    r14,r15
/
cpymsg:
        dc      c'bad call to copypag\0'
/*/

/* Clear a page to zero - used by mem.c */
/**/    /*ARGSUSED*/
/**/    zeropag(p) caddr_t p; {}
/*/
	drop
	entry   zeropag
	using   zeropag,r15
zeropag:
	l       r1,0(sp)               / page addr
	ltr     r1,r1                  / page zero?
	be      badzero                / yes - give up
	mvi     0(r1),x'00'            / clear byte 0
	mvc     1(255,r1),0(r1)        / clear bytes 1-255
	mvc     256(256,r1),255(r1)    / clear bytes 256-511
	mvc     512(256,r1),511(r1)    / etc.
	mvc     768(256,r1),767(r1)
	mvc     1024(256,r1),1023(r1)
	mvc     1280(256,r1),1279(r1)
	mvc     1536(256,r1),1535(r1)
	mvc     1792(256,r1),1791(r1)
	mvc     2048(256,r1),2047(r1)
	mvc     2304(256,r1),2303(r1)
	mvc     2560(256,r1),2559(r1)
	mvc     2816(256,r1),2815(r1)
	mvc     3072(256,r1),3071(r1)
	mvc     3328(256,r1),3327(r1)
	mvc     3584(256,r1),3583(r1)
	mvc     3840(256,r1),3839(r1)
	br	r14
/
badzero:
	la      r2,zeromsg
	st      2,0(sp)
	l       r15,=v(panic)
	balr    r14,r15
/
zeromsg:
        dc      c'bad call to zeropag\0'
/*/

/* Set storage keys for both halves of a page */
/**/    /*ARGSUSED*/
/**/    a_ssk(p, k) caddr_t p; {}
/*/
	entry   a_ssk
a_ssk:
	using   .,r15
	l       r0,4(,sp)
	sll     r0,4
	l       r1,0(,sp)
	ssk     r0,r1
	la      r1,2048(,r1)
	ssk     r0,r1
	br      r14
/*/

/* Set storage keys for just half of a page */
/**/    /*ARGSUSED*/
/**/    a_ssk2k(p, k) caddr_t p; {}
/*/
	entry   a_ssk2k
a_ssk2k:
	using   .,r15
	l       r0,4(,sp)
	sll     r0,4
	l       r1,0(,sp)
	ssk     r0,r1
	br      r14
/*/

/* Store CPU identification */
/**/    long a_stidp() { return(0L); }
/*/
	entry   a_stidp
a_stidp:
	using   .,r15
	l       r1,=a(dbl)
	stidp   0(r1)
	lm      r0,r1,0(r1)
	br      r14
/*/

/*/
.data
dbl:    ds      d
.text
/*/


/* I/O instructions */
/*/
csw = x'40'
caw = x'48'
/*/

/* Halt Device */
/**/    /*ARGSUSED*/
/**/    a_hdv(dev) int dev; { return(0); }
/*/
	entry   a_hdv
a_hdv:  l       r1,0(,sp)
	xc	csw(8),csw
        hdv     0(r1)
	balr r0,r0;sll r0,2;srl r0,30	/ get cc
	br	r14
/*/

/* Clear I/O */
/**/    /*ARGSUSED*/
/**/    a_clrio(dev) int dev; { return(0); }
/*/
	entry   a_clrio
a_clrio:l       r1,0(,sp)
	xc	csw(8),csw
        clrio   0(r1)
	balr r0,r0;sll r0,2;srl r0,30	/ get cc
	br	r14
/*/

/* Test I/O */
/**/    /*ARGSUSED*/
/**/    a_tio(dev) int dev; { return(0); }
/*/
	entry   a_tio
a_tio:  l       r1,0(,sp)
	xc	csw(8),csw
	tio	0(r1)
	balr r0,r0;sll r0,2;srl r0,30	/ get cc
	br	r14
/*/

/* Start I/O */
/**/    /*ARGSUSED*/
/**/    a_siof(dev, caw) int dev, caw; { return(0); }
/*/
	entry   a_siof
a_siof: l       r1,0(,sp)
	mvc	caw(4),4(sp)
	xc	csw(8),csw
	siof	0(r1)
	balr r0,r0;sll r0,2;srl r0,30	/ get cc
	br	r14
/*/

/* Test Channel */
/**/    /*ARGSUSED*/
/**/    a_tch(ch) int ch; { return(0); }
/*/
	entry   a_tch
a_tch:  l       r1,0(,sp)
	tch	0(r1)
	balr r0,r0;sll r0,2;srl r0,30	/ get cc
	br	r14
/*/

/* Store Channel ID */
/**/    /*ARGSUSED*/
/**/    a_stidc(ch) int ch; { return(0); }
/*/
        entry   a_stidc
a_stidc:
        l       r1,0(,sp)
        stidc   0(r1)
        balr r0,0;sll r0,2;srl r0,30 / get cc
        br      r14
/*/

/*/
