%{
#define input getch
#define output(c)  outch(c)
#define unput ungetch
#define PACK(x, y)  ((x << 16) | y)
#include "y.tab.h"
#include "omak.h"
%}
%%
%{
int c;
int i;
char *p;
%}
"\\\n"			;
"\n"			return('\n');
[ \t]			;
"/*".*  {
        for (i=0;i<80;i++) tmpchr[i]='\0';
	yylval = &tmpchr[0];
	strcpy(yylval, yytext+2);
	return(COMMENT);
	}

"/"[abhwl][doxcv] {
	yylval = PACK(yytext[1], yytext[2]);
	return(PRINTOP);
	}

"/"[abhwl] {
	yylval = PACK(yytext[1], 0);
	return(PRINTOP);
	}

"/"[doxcsivt] {
	yylval = PACK(0, yytext[1]);
	return(PRINTOP);
	}

"/e"[bhwl]"c" {
	yylval = PACK(yytext[2], 'c');
	xlate = 1;
	return(PRINTOP);
	}

"/ec" {
	yylval = PACK(1, 'c');
	xlate = 1;
	return(PRINTOP);
	}

"/ix" {
	yylval = PACK(0, 'j');
	return(PRINTOP);
	}

"//"			return(DIVIDE);
"/"			{ yylval = 0; return(PRINTOP); }
".."			return(DOTDOT);
"~="			return(NE);
"=="			return(EQ);
"<="			return(LE);
">="			return(GE);
"&&"			return(AND);
"||"			return(OR);
;r[0-9]+ {
	if ((yylval = tobinary(yytext+2, 10)) > 15){
		aptstr(aptout,"Illegal register%s",blankchr);
		aptio(aptout,0);
		return(LEXERR);
		}
	return(REG);
	}

;c[0-9]+ {
        yylval = tobinary(yytext+2, 10);
	if ( (yylval < 0) || (yylval > 15) ) {
		aptstr(aptout,"Illegal control register%s",blankchr);
		aptio(aptout,0);
		return(LEXERR);
		}
	return(CNTLREG);
	}

;psw             return(PPSW);
;csw             return(PCSW);
;caw             return(PCAW);
;r               return(PREG);
;c               return(PCNTLREG);
;bp              return(BRKP);
;bpc             return(BRKPCNT);
;int             return(INT);
;trace           return(TRACE);
;go              return(GO);
;v               return(DVIRT);
;cont            return(CONT);
;ss              return(SS);
;quit            return(0);
;brks            return(BREAKS);
;clr             return(CLEAR);
;if              return(IF);
"enter("         return(ENTER);
"ext("           return(EXT);
"io("            return(IO);
"mck("           return(MCK);
"pgm("           return(PGM);
"svc("           return(SSS);
"restart"        return(RESTART);
[A-Za-z0-9_#$@]+	{
	switch(yytext[0]){
		case '0': case '1': case '2': case '3': case '4':
                case '5': case '6': case '7': case '8': case '9':
			yylval = tobinary(yytext,16);
			if (yylval == -1) {
                                         aptstr(aptout,"Illegal number%s",
                                                   blankchr);
                                          aptio(aptout,0);
                                          }
			aptnum = tobinary(yytext,10);
			if (aptnum == -1) aptnum = yylval;
			break;
		default:
			if ((yylval = lookup(yytext)) != NULL)
				return(SYMBOL);
			else  if (yytext[0] == '#') {
			     /* yylval = insert(yytext); */
			     /* return(SYMBOL); */
			        return(LEXERR); /* for now */
			     }
			aptstr(aptout,"symbol not found%s",blankchr);
			aptio(aptout,0);
			return(LEXERR);
		}
	if (yylval == -1) return(LEXERR);
	return(NUMBER);
	}
.		return(yytext[0]);
%%
tobinary(st, b)
char *st;
register int b;{

	register int n, c;
	register char *s;
	int t;

	n = 0;
	s = st;
	while (c = *s++){
		if (c >= '0' && c <= '9') t = c-'0';
		else if (b == 16 && c >= 'a' && c <= 'f') t = c-'a'+10;
		else if (b == 16 && c >= 'A' && c <= 'F') t = c-'A'+10;
		else {
			return(-1);
			}
		n = n*b+t;
		}
	return(n);
	}

static char pushbuf[512];
static char *bufp = pushbuf;

getch(){

	register int c;

	if (bufp > pushbuf) return(*--bufp);
	if ((c = aptchar()) == EOF) return(0);
	return(c);
	}
outch(c)
register int c;{

	if (bufp >= pushbuf+512) {
		aptstr(aptout,"Buffer overflow, wow%s",blankchr);
		aptio(aptout,0);
                }
	*bufp++ = c;
	}

ungetch(c)
register int c;{

	if (bufp >= pushbuf+512) {
		aptstr(aptout,"Buffer overflow, ouch%s",blankchr);
		aptio(aptout,0);
                }
	*bufp++ = c;
	}

gobble(y) int y; {

	register int c;

        if (y) { unput('\n');  unput('}');
                    return; }

        while (((c = input()) != '\n') && ( c != '}') && (c != EOF) );
	unput(c);
	}
