/*
 * Header for dasd driver.
 */

/*
 * Channel commands
 */
#define SEEK    0x07
#define SETSCTR 0x23
#define SRCHIDE 0x31
#define TIC     0x08
#define RDDATA  0x06
#define WRTDATA 0x05
 
/*
 * Sense bits
 */
#define stest(byte,bit) (sense[byte]&(1<<(7-bit)))
#define CMDREJ  stest(0,0)
#define INTREQ  stest(0,1)
#define BUSOUT  stest(0,2)
#define EQCHK   stest(0,3)
#define DATACHK stest(0,4)
#define OVERRUN stest(0,5)
#define PERMERR stest(1,0)
#define CRCTABL stest(2,1)
#define ENVDATA stest(2,3)
 
#define TRKSKP 1                /* tracks skipped on cyl 0 */
#define MAXCYL 1024             /* largest possible cyl # */
 
#define NTYPS   5               /* number of types of DASDs */
#define NCP     10              /* number of simultaneous reads and */
			        /* writes to one disk at a time     */
#define CPSIZE    5             /* size of channel program for one block  */
#define FOREWARD  1             /* direction of head travel (for sorting) */
#define BACKWARD  2             /* direction of head travel (for sorting) */

#define MINT      60            /* missint interrupt time */
 
/*
 * DASD type descriptor
 */
struct dskdesc {
        int     d_blktrk;       /* blocks per track */
        int     d_trkcyl;       /* tracks per cylinder */
        int     d_const;        /* RPS */
        int     d_factor;       /* RPS */
        int     d_divsor;       /* RPS */
};
 
/*
 * DASD descriptor - must be double word aligned
 */
struct dasd {
        ccw_t   d_ccws[NCP][CPSIZE];    /* channel programs */
	struct recloc {           /* record location for channel programs */
	        short   d_bb;     /* bin number (always 0) */
		short   d_cc;     /* cylinder number */
	        short   d_hh;     /* head number */
		short   d_r0;     /* record number */
	        char    d_sector; /* RPS sector */
	} d_recloc[NCP];
	int     d_cpst;           /* starting channel program number (0 to NCP-1) */
	int     d_cpend;          /* ending channel program number plus one (1 to NCP) */
	int     d_dir;            /* direction of head travel (for sorting) */
	int     d_blkno;          /* block no. (for sorting) */
	struct  buf *d_iolist;    /* head of list of active blocks */
			          /* (points to block to be read by channel program d_cpst) */
        struct  dskdesc *d_desc;  /* pointer to type of DASD */
	struct  buf *d_devtab;    /* pointer to buf for this disk */
        int     d_devaddr;        /* device address */
        int     d_maxblk;         /* max block # */
        char    d_init;           /* initialization flag (0 = not open,       */
                                  /* 1 = open or close in progress, 2 = open) */
        char    d_rw;             /* read/write flag (0 = read only, 1 = r/w) */
        char    d_intreq;         /* intervention required */
        char    d_done;           /* synch i/o flag */
	char    d_dead;           /* dead disk flag */
        int     d_qlen;           /* current queue length */
} dasds[NDASD];
