/*
 * SMSG VMCF driver
 */
#include "../h/conf.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/tty.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/vmcf.h"
#include "../h/ioconf.h"

struct smsg {
        struct clist x_q;       /* character queue */
        enum {CLOSED=0, OPEN} x_state;
	char    x_user[8];      /* userid of source */
} smsgdev[NSMSG];

static int smsgcnt;            /* # smsg users */
static int smsgd;              /* VMCF connection # for SMSGs */

/*
 * Open SMSG device
 */
smsgopen(dev, flag)
{
        struct smsg *x;

        if(minor(dev) >= NSMSG || !vm) {
                u.u_error = ENXIO;
                return;
        }
	if(flag) {     /* smsg is read-only */
		u.u_error = EINVAL;
		return;
	}
        x = &smsgdev[minor(dev)];
        if(x->x_state == OPEN) {
                u.u_error = EBUSY;
                return;
        }
	if(smsgcnt == 0) {
		if(smsgauth()) {
			u.u_error = EIO;
			return;
		}
	}
	smsgcnt++;
        x->x_state = OPEN;
	x->x_user[0] = 0;
}

/*
 * Close SMSG device
 */
smsgclose(dev)
{
        struct smsg *x;

        x = &smsgdev[minor(dev)];
        while(x->x_q.c_cc) getc(&x->x_q);
        x->x_state = CLOSED;
        if(--smsgcnt == 0)
                smsguaut();
}

/*
 * Read from SMSG device
 */
smsgread(dev)
{
        struct smsg *x;
        int c;

        x = &smsgdev[minor(dev)];
        while(x->x_q.c_cc == 0) sleep((caddr_t)&x->x_q, TTIPRI);
        while((c = getc(&x->x_q)) != -1 && passc(c) != -1);
}

/*
 * Authorize SMSG
 * Done on first open of a SMSG device
 */
smsgauth()
{
	int smsgint();

	smsgd = vmc_catch("SYSTEM", smsgint, 0);
	if(smsgd < 0) {
                printf("smsg: authorization failed\n");
		return(1);
	}
	return(0);
}

/*
 * Unauthorize SMSG
 * Done on last close of a SMSG device
 */
smsguaut()
{
	vmc_drop(smsgd);
}

/*
 * SMSG interrupt
 */
/* ARGSUSED */
smsgint(arg, h)
struct vmcmhdr *h;
{
        register int i;
        register struct smsg *x;
        register char *cp;
        extern char etatab[];

	for(x = &smsgdev[0]; x < &smsgdev[NSMSG]; x++)
	if(x->x_state == OPEN && cmp8(h->m_use, x->x_user) && x->x_q.c_cc < TTYHOG) {
                cp = h->m_buf;
		for(i=0; i<h->m_lena; i++)
			putc(etatab[*cp++], &x->x_q);
		putc('\n', &x->x_q);
		wakeup((caddr_t)&x->x_q);
	}
	return(1);      /* accept the interrupt: see vmcfint */
}

/*
 * SMSG ioctl
 * Sets the user from whom messages will be received
 */
/* ARGSUSED */
smsgctl(dev, cmd, argp, flag)
dev_t dev;
caddr_t argp;
{
	register struct smsg *x;
	int c, i;
	register char *cp;
	extern char atetab[128];

	x = &smsgdev[minor(dev)];
	switch(cmd) {

	case SMSGUSER:
		while(x->x_q.c_cc > 0)  /* flush */
			getc(&x->x_q);
		cp = x->x_user;
		for(i=0; i<8; i++) {
			c = fubyte(argp);
			if(c == -1) {
				u.u_error = EFAULT;
				return;
			}
			*cp++ = atetab[c&0177] | 0x40;   /* translate, upcase, blank pad */
			if(c) argp++;
		}
		break;

	default:
		u.u_error = ENOTTY;
		break;
	}
}
