#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/io.h"
#include "../h/ios.h"
 
/*
 * I/O services
 */
 
/*
 * Construct an indirect address list from the base
 * and count parameters. 'flag' is 0 for read, 1 for write.
 * 'idaw' should point at a 33 word(max) area.
 */
makidaw(flag, idaw, base, count)
caddr_t *idaw, base;
unsigned count;
{
        caddr_t end, ldreal();
        caddr_t i;
 
        if(count > 65535) {
                u.u_error = EINVAL;
                return;
        }
        end = base + count;
        while(base < end) {
                if((i = ldreal(base)) == (caddr_t)-1) {
                        u.u_error = EFAULT;
                        return;
                }
                if((!flag) && isk(i) != 1) {
                        u.u_error = EFAULT;
                        return;
                }
                *idaw++ = i;
                base += 2048;
                base -= (int)base % 2048;
        }
}
 
/*
 * Issue a CP RESET command for the specified device.
 */
reset(devaddr)
{
        char cmd[20];
        struct chan *ch;
        struct cu *cu;
        struct unit *un;
        int i;
        char *cp, *cp2;
 
        cp = cmd;
        cp2 = "RESET 000";
        while(*cp = *cp2++) cp++;
        for(i=devaddr;i;i >>= 4)
                *--cp = "0123456789ABCDEF"[i & 017];
        cpcmd(cmd);
        if(iolkup(devaddr, &ch, &cu, &un)) return;
        if(un->un_actv) {
                freeq(un->un_actv);
                un->un_actv = 0;
        }
        un->un_state = FREE;
        cu->cu_state = FREE;
        ch->ch_state = FREE;
        qstart(ch, cu, un);
}
 
/*
 * Issue a CP CLOSE command for the specified device
 */
cpclose(devaddr)
{
        char cmd[20];
        char *cp, *cp2;
 
        cp = cmd;
        cp2 = "CLOSE 000";
        while(*cp = *cp2++) cp++;
        for(;devaddr;devaddr >>= 4)
                *--cp = "0123456789ABCDEF"[devaddr & 017];
        cpcmd(cmd);
}

/*
 * Print an I/O error message.
 */
deverr(devaddr, csw)
int devaddr;
csw_t csw;
{
	printf("dev = %x csw = %8x %8x\n", devaddr, csw.cs_word1, csw.cs_word2);
}

/*
 * Set up certain i/o parameters.
 * For now, just mint.
 */
iosetup(devaddr, mint)
int devaddr, mint;
{
	struct chan *ch;
	struct cu *cu;
	struct unit *un;

	if (iolkup(devaddr, &ch, &cu, &un))
		return;
	if (mint)
	        un->un_mint = mint + MINT + 1;
	else
		un->un_mint = 0;
}
