/*
 * CSW analysis routines
 */
#include "../h/io.h"
#include "../h/ios.h"
#include "../h/370.h"
#include "../h/param.h"
#include "../h/stats.h"
 
/*
 * All I/O interrupts come here.
 */
iointr()
{
        struct chan *ch;
        struct cu   *cu;
        struct unit *un;
 
	stats.s_iois++;

	if (CSW.cs_progc) {
		printf("iointr: ioaddr %3x csw %8x%8x\n", IOADDR, CSW.cs_dblw);
		panic("iointr - csw indicates program check");
	}
	if (CSW.cs_protc) {
		printf("iointr: ioaddr %3x csw %8x%8x\n", IOADDR, CSW.cs_dblw);
		panic("iointr - csw indicates protection check");
	}

        if(iolkup(IOADDR, &ch, &cu, &un))
		return;

        switch(CSW.cs_cc) {
 
        case 1:
                istat(un->un_actv, ch, cu, un);
                break;
 
        case 3:
                iocc3(un->un_actv, ch, cu, un);
                break;
 
        default:
                if(un->un_actv)
                        estat(un->un_actv, ch, cu, un);
                else
                        astat(ch, cu, un);
                break;
        }
        qstart(ch, cu, un);
}
 
/*
 * CSW stored by an I/O instruction.
 */
iocc1(q, ch, cu, un)
struct ioq  *q;
struct chan *ch;
struct cu   *cu;
struct unit *un;
{
	if (CSW.cs_progc) {
		printf("iocc1: ioaddr %3x csw %8x%8x\n", q->io_devaddr, CSW.cs_dblw);
		panic("iocc1 - csw indicates program check");
	}
	if (CSW.cs_protc) {
		printf("iocc1: ioaddr %3x csw %8x%8x\n", q->io_devaddr, CSW.cs_dblw);
		panic("iocc1 - csw indicates protection check");
	}

        CSW.cs_cc = 1;

	if(CSW.cs_sm && CSW.cs_busy) { /* CU busy */
		if(CSW.cs_cue) {       /* temporarily busy */
                        iostart(q);
		} else {        /* queue from CU */
                        cu->cu_state = WORKING;
                        ioenq(q, &cu->cu_q);
                }
	} else {
                switch(q->io_type) {
                case SIO:
                        istat(q, ch, cu, un);
                        break;
                case TIO:
                        tiocc1(q, ch, cu, un);
                        break;
                case HIO:
                        hiocc1(q, ch, cu, un);
                        break;
                }
        }
}
 
/*
 * CC 1 for TIO.
 */
tiocc1(q, ch, cu, un)
struct ioq  *q;
struct chan *ch;
struct cu   *cu;
struct unit *un;
{
        switch(CSW.cs_word2 & (UNITSTAT+PCI)) {
 
        case XBUSY:
                un->un_state = WORKING;
                /* fall through */
        case SM:        /* TIO non-functional */
                un->un_csw.cs_dblw = CSW.cs_dblw;
                (*q->io_intr)(q->io_arg, &un->un_csw, un->un_sense);
                freeq(q);
                break;
 
        case UC:
                estat(q, ch, cu, un);
                break;
 
        default:
                ioenq(q, &un->un_q);
                if(un->un_actv)
                        estat(un->un_actv, ch, cu, un);
                else
                        astat(ch, cu, un);
                break;
        }
}
 
/*
 * CC 1 on HIO.
 */
/*ARGSUSED*/
hiocc1(q, ch, cu, un)
struct ioq  *q;
struct chan *ch;
struct cu   *cu;
struct unit *un;
{
        if(CSW.cs_word2 & (UNITSTAT+PCI)) {
		deverr(q->io_devaddr, CSW);
                printf("hio: non-zero status\n");
	}
        freeq(q);
}
 
/*
 * Unusual initial status analysis.
 */
istat(q, ch, cu, un)
struct ioq  *q;
struct chan *ch;
struct cu   *cu;
struct unit *un;
{
        ch->ch_state = FREE;
	un->un_state = FREE;
        un->un_actv = 0;
        if(CSW.cs_busy) {
                if(CSW.cs_sm) {  /* CU busy */
                        if(CSW.cs_cue) { /* temporarily */
                                cu->cu_state = FREE;
                                iostart(q);
                        } else {
                                cu->cu_state = WORKING;
                                ioenq(q, &cu->cu_q);
                        }
                        return;
                }
                if(CSW.cs_word2 & (ATTN+CUE+DE)) {      /* asynchronous */
                        CSW.cs_busy = 0;
                        ioenq(q, &un->un_q);
                        astat(ch, cu, un);
                        return;
                }
                /* plain old busy - probably reserved DASD */
                un->un_state = HUNG;
                ioenq(q, &un->un_q);
                return;
        }
        /* immediate status - treat as ending */
        if(CSW.cs_uc || CSW.cs_ue)
                CSW.cs_de = 1;
        un->un_actv = q;
        estat(q, ch, cu, un);
}
 
/*
 * Asynchronous status analysis.
 */
astat(ch, cu, un)
struct chan *ch;
struct cu   *cu;
struct unit *un;
{
        ch->ch_state = FREE;
        if(CSW.cs_cue) {
                cu->cu_state = FREE;
                CSW.cs_cue = 0;
        }
        if(CSW.cs_de) {
                if(un->un_state == HUNG)
                        CSW.cs_de = 0;
                un->un_state = FREE;
        }
        if(CSW.cs_word2 & (ATTN+DE)) {
                un->un_csw.cs_dblw = CSW.cs_dblw;
                if(un->un_intr)
                        (*un->un_intr)(un->un_arg, &un->un_csw, un->un_sense);
        }
}
 
/*
 * Ending status analysis.
 */
estat(q, ch, cu, un)
struct ioq  *q;
struct chan *ch;
struct cu   *cu;
struct unit *un;
{
        int (*intr)(), arg;
        csw_t save;
 
        if(CSW.cs_word2 & UNITSTAT)       /* not PCI */
                ch->ch_state = FREE;
        if(CSW.cs_word2 & (ATTN+CUE+DE+UC+UE))
                cu->cu_state = FREE;
        if(CSW.cs_word2 & (ATTN+DE+UC)) {
                un->un_state = FREE;
		q->io_mint = 0;
                un->un_actv = 0;
        }
        if(CSW.cs_busy) {        /* chaining stopped by BUSY */
                un->un_actv = 0;
                un->un_state = FREE;
                if(CSW.cs_sm)
                        if(CSW.cs_cue) {
                                cu->cu_state = FREE;
                                iostart(q);
                        } else {
                                cu->cu_state = WORKING;
                                ioenq(q, &cu->cu_q);
                        }
                else {
                        un->un_state = HUNG;
                        ioenq(q, &un->un_q);
                }
                return;
        }
        if((q->io_caw & ADDRMASK) == (int)&un->un_sccw) { /* sense ending */
                if((CSW.cs_word2 & (UC+UE)) && CSW.cs_count == SENSEL) {
			deverr(q->io_devaddr, CSW);
                        ipanic("sense failed\n");
		}
                if(CSW.cs_word2 & (DE+UC+UE)) {
                        (*q->io_intr)(q->io_arg, &un->un_csw, un->un_sense);
                        freeq(q);
                }
                return;
        }
        if(CSW.cs_uc) {    /* get sense */
                un->un_csw.cs_dblw = CSW.cs_dblw;
                q->io_caw = (USERKEY << 28) | (int)&un->un_sccw;
                un->un_sccw.cc_cmd = SENSE;
                un->un_sccw.cc_addr = (int)un->un_sense;
                un->un_sccw.cc_sli = 1;
                un->un_sccw.cc_count = SENSEL;
                q->io_type = SIO;
                iostart(q);
                return;
        }
        save.cs_dblw = CSW.cs_dblw;
        if(CSW.cs_attn) {
                astat(ch, cu, un);
		save.cs_de = 1;
	}
        un->un_csw.cs_word1 = save.cs_word1;
        un->un_csw.cs_word2 = save.cs_word2 & ~(ATTN+SM+CUE+XBUSY);
        intr = q->io_intr;
        arg = q->io_arg;
        if(un->un_actv == 0)
                freeq(q);
        if(un->un_csw.cs_word2 & (CE+DE+UE+PCI+IL))
                (*intr)(arg, &un->un_csw, un->un_sense);
}
 
/*
 * Device not operational.
 */
iocc3(q, ch, cu, un)
struct ioq  *q;
struct chan *ch;
struct cu   *cu;
struct unit *un;
{
        ch->ch_state = FREE;
        cu->cu_state = FREE;
        un->un_state = DEAD;
	un->un_csw.cs_dblw = 0L;
        un->un_csw.cs_cc = 3;
	if (q->io_intr)
	        (*q->io_intr)(q->io_arg, &un->un_csw, un->un_sense);
        freeq(q);
}
