/*
 * Scan data being passed around for things of interest
 */

#include <tcl/tcldefs.h>
#include <stdio.h>

int (*Iscan)() = stdiscan;
int (*Oscan)() = stdoscan;

int escaid = TESTREQ;

/*
 * Scan 3270 input for things of interest
 */
stdiscan()
{
	char aid, *sbap, *p, *q, cmd[100];
	int len, fld;

	if(inbuf.op != READMOD)
		return(S_OK);
	aid = inbuf.data[0];
	if(aid == SOH)
		aid = TESTREQ;
	if(inbuf.len < 4) {     /* short read or aid and cursor only */
		sbap = NULL;
		len = 0;
	} else if(aid != TESTREQ) {     /* normal read */
		sbap = &inbuf.data[3];
		len = inbuf.len - 3;
	} else {      /* TESTREQ read */
		sbap = &inbuf.data[4];
		len = inbuf.len - 4;
	}
	if(aid == escaid && len > 0 && tubitab[sbap[3]] == '!') {
		/* escape sequence */
		len -= 3;
		if(tubitab[sbap[4]] == '!') {
			/* double escape, strip one ! and pass it on */
			p = sbap+3;
			q = sbap+4;
			while(--len) *p++ = *q++;
			*p = 0;
			inbuf.len--;
			return(S_OK);
		}
		p = sbap+4;
		q = cmd;
		while(--len) *q++ = tubitab[*p++];
		*q = 0;
                /* do the command */
		if(cmd[0] == '>') {     /* write screen to file */
			if(cmd[1] == '>')
				wrtscreen(1, cmd+2);
			else
			        wrtscreen(0, cmd+1);
		} else if(cmd[0] == '<') {
			fld = ((sbap[1] & 077) << 6) + (sbap[2] & 077);
			rdscreen(fld, cmd+1);
		} else {
                        fssystem(cmd);
		}
                /* restore screen image */
		outscreen();
                putoutput();
		/* indicate scan successful */
		return(S_NOTOK);
	}
	return(S_OK);
}

/*
 * Scan 3270 output for things of interest
 */
stdoscan()
{
	return(S_OK);
}
