/*
 * Handle I/O to/from the PVM machine (VMCF interface)
 */

#include <tcl/3270.h>
#include <tcl/tclio.h>
#include <stdio.h>
#include <sgtty.h>
#include <errno.h>


extern errno;
extern char atetab[], etatab[];

static struct req {
	int     fld;
	int     senlw;          /* session disc len */
	char    sgnda[8];       /* session disc data */
	char    node[8];        /* specific node */
	short   port;           /* specific port */
	short   real;           /* real terminal addr */
	short   class;          /* terminal class */
	char    model;          /* terminal model */
} req;


/*
 * Open the path to PVM
 */
pvmopen(node)
char *node;
{
	static char ldev[] = "/dev/pvm";
	int i, pvmoutput(), pvminput();

        ldfd = open(ldev, 2);
	if(ldfd == -1) {
		if(errno == EBUSY)
			fprintf(stderr, "PVM link is in use, try later.\n");
		else
                        perror(ldev);
		exit(1);
	}
	ioctl(ldfd, PVMGET, &req);
	req.senlw = 4;
	for(i=0; i<4; i++)
		req.sgnda[i] = atetab['#'];
	if(node && *node) {
                for(i=0; i<8; i++) {
                        req.node[i] = atetab[*node] | 0x40;
                        if(*node) node++;
                }
	}
	ioctl(ldfd, PVMSET, &req);
        _getoutput = pvmoutput;
        _putinput = pvminput;
}

/*
 * Read 3270 output from PVM
 */
pvmoutput()
{
	int i, n;

	n = read(ldfd, (char *)&outbuf, sizeof outbuf - sizeof outbuf.len);
	if(n < 0) {
		perror("pvm read");
		exit(1);
	}
	if(n == 0)
		exit(0);
	outbuf.len = n-1;

	i = 0;
	switch(outbuf.op) {

	case READMOD:
	case READBUF:
		unsolicited = outbuf.op;
		i = 1;
		break;

	case WRITE:
	case EWRITE:
		scroutput();
                if(outbuf.data[0] & RESTORE)
                        kbd = UNLOCKED;
		i = (*Oscan)();
		break;

        case 0: /* error message */
                if(n > 1) {
                        for(i=0; i < n-1; i++)
                                putc(etatab[outbuf.data[i]], stderr);
                        putc('\n', stderr);
                }
                exit(1);

	default:
		fprintf(stderr, "pvm read: unknown op %x\n", outbuf.op);
		i = 1;
	}
	return(i);
}

/*
 * Write 3270 input to PVM
 */
pvminput()
{
	int n;

	n = inbuf.len+1;
	if(write(ldfd, (char *)&inbuf, n) < 0) {
		if(errno == EINVAL) {
			if(inbuf.op == READMOD)
				unsolicited = READBUF;
			else
				unsolicited = READMOD;
			return(1);
		}
		if(errno == EIO) exit(0);       /* pvm terminated */
		perror("pvm write");
	}
	kbd = LOCKED;
	return(0);
}
