/*
 * Routines for dealing with full-screen I/O to real 3270s
 */

#include <tcl/3270.h>
#include <tcl/tclio.h>
#include <stdio.h>
#include <sgtty.h>

static char *tty;

/*
 * Find and open the full-screen device
 */
fsopen()
{
        char *ttyname();

	tty = ttyname(2);
	if(tty == NULL) {
		fprintf(stderr, "Can't find terminal\n");
		exit(1);
	}
	/* change /dev/ttyXX to /dev/tubXX */
	tty[6] = 'u';
	tty[7] = 'b';
	if((fsfd = open(tty, 2)) < 0) {
		fprintf(stderr, "Can't open %s\n", tty);
		exit(1);
	}
}

/*
 * Leave full-screen mode, issue command, re-enter full-screen mode
 */
fssystem(cmd)
char *cmd;
{
	int i;

	close(fsfd);
	ioctl(ldfd, FIOCLEX, 0);
	if(*cmd) {
		system(cmd);
		for(i=0; i<22; i++) putc('\n', stderr);
	} else {
		i = fork();
		if(i == 0) {
			execl("/bin/sh", "sh", 0);
		}
		if(i > 0) while(i != wait((int *)0)) ;
	}
	fsfd = open(tty, 2);
}

/*
 * Read 3270 input
 */
getinput()
{
	int n;

	if(unsolicited) {
		ioctl(fsfd, TUBNATTN, 0);
		ioctl(fsfd, TUBICMD, unsolicited);
	}
	inbuf.len = read(fsfd, inbuf.data, sizeof inbuf.data);
	if(inbuf.len < 0)
		exit(1);
	if(inbuf.len == 0)
		exit(0);
	if(unsolicited) {
		ioctl(fsfd, TUBWATTN, 0);
		ioctl(fsfd, TUBICMD, READMOD);
		inbuf.op = unsolicited;
		unsolicited = 0;
	} else {
		inbuf.op = READMOD;
		if(n = (*Iscan)()) return(n);
		scrinput();
	}
	return(0);
}

/*
 * Write 3270 output
 */
putoutput()
{
	static char prevccw;

	if(outbuf.op != prevccw) {
		ioctl(fsfd, TUBOCMD, outbuf.op);
		prevccw = outbuf.op;
	}
	lastwcc = outbuf.data[0];
	write(fsfd, outbuf.data, outbuf.len);
}
