/
/ Function:
/   STRCAT finds null in s1, copies s2 starting there, returns --> s1.
/
/ Calling Sequence:
/   strcat(s1, s2) { char *s1, *s2 }
/
	entry   strcat
	using   strcat,15
strcat:
	lr	r0,sp
	s	sp,=f'64'
	stm	0,15,0(sp)
	st	0,52(,sp)
	lr	r12,sp

	l       r5,64(,sp)          / Get s1 address
	l       r4,=v(_strtabl)     / Get trt table address
0:
	trt     0(256,r5),0(r4)     / Scan for null
	bc      8,1f                / CC=0?  No null found
	lr      r5,r1               / Else reset r5 to point to end
	b       2f                  / Go do the concat
1:
	la      r5,256(r5)          / Increment address
	b       0b                  / Continue scan
2:
	l       r6,68(,sp)          / Get s2 address
3:
	trt     0(256,r6),0(r4)     / Scan for null
	bc      8,4f                / CC=0?  No null found
	sr      r1,r6               / Else calc length remaining to move
	ex      r1,5f               / Execute move
	l       r0,64(,sp)          / Point to s1
	lm      r1,r15,4(r12)       / and return
	br      r14
4:
	mvc     0(256,r5),0(r6)     / Move into s1
	la      r5,256(r5)          / Increment addresses
	la      r6,256(r6)
	b       3b                  / Continue scan
5:
	mvc     0(,r5),0(r6)        / Model mvc 0(0,r5),0(r6)
