#include <signal.h>
#include <stdioerr.h>

system(s)
char *s;
{
	int status, pid, w;
	register int (*istat)(), (*qstat)();
	register char *sh;
	extern char *getenv();
	extern int errno;

	if ((sh = getenv("SHELL")) == (char *) 0)
		sh = "/bin/sh";
	if ((pid = fork()) == 0) {
		execl(sh, sh, "-c", s, 0);
		_stdioerr(errno, "system", sh);
		_exit(127);
	}
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	while ((w = wait(&status)) != pid && w != -1)
		;
	if (w == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	if (status == -1)
		_stdioerr(errno, "system");
	return(status);
}
