#include <stdio.h>
#include <signal.h>
#include <sgtty.h>

static char *mask[] = {
	"********",
	"\b\b\b\b\b\b\b\b",
	"ZZZZZZZZ",
	"\b\b\b\b\b\b\b\b",
	"pppppppp",
	"\b\b\b\b\b\b\b\b",
	"HHHHHHHH",
	"\b\b\b\b\b\b\b\b",
	"gggggggg",
	"\b\b\b\b\b\b\b\b",
	0
};

char *
getpass(prompt)
char *prompt;
{
	struct sgttyb ttyb;
	int flags;
	register char *p;
	register c;
	FILE *fi;
	static char pbuf[9];
	char **s;
	int (*signal())();
	int (*sig)();

	if ((fi = fopen("/dev/tty", "r")) == NULL)
		fi = stdin;
	else
		setbuf(fi, (char *)NULL);
	fflush(stdout); /* for Au's funny stdout buffering */
	sig = signal(SIGINT, SIG_IGN);
	gtty(fileno(fi), &ttyb);
	flags = ttyb.sg_flags;
	if(flags & ECHO) {      /* 3270 */
	        ttyb.sg_flags &= ~ECHO;
	        stty(fileno(fi), &ttyb);
	        fprintf(stderr, prompt);
	} else {      /* ascii terminal */
		fprintf(stderr, prompt);
		for(s = &mask[0]; *s; s++)
			fprintf(stderr, "%s", *s);
	}
	for (p=pbuf; (c = getc(fi))!='\n' && c!=EOF;) {
		if (p < &pbuf[8])
			*p++ = c;
	}
	*p = '\0';
	if(flags & ECHO) {
	        fprintf(stderr, "\n");
	        ttyb.sg_flags = flags;
	        stty(fileno(fi), &ttyb);
	}
	signal(SIGINT, sig);
	if (fi != stdin)
		fclose(fi);
	return(pbuf);
}
