/*
 * Seek for standard library.  Coordinates with buffering.
 */

#include <stdio.h>
#include <stdioerr.h>

int seek();

fseek(iop, offset, ptrname)
	register FILE *iop;
	int  offset;
{
	extern int errno;
	register int c;
	int  p;

	if (iop == NULL)
		return(_stdioerr(EFPNULL, "fseek"));
	if (iop->_flag&_IOMEM)
		return(_mfseek(iop, offset, ptrname));
	iop->_flag &= ~_IOEOF;
	if (iop->_flag&_IOREAD) {
		if (ptrname < 2 && iop->_base && !(iop->_flag&_IONBF)) {
			c = iop->_cnt;
			p = offset;
			if (ptrname == 0)
				p += c - seek(fileno(iop), 0, 1);
			else
				offset -= c;
			if (!(iop->_flag&_IORW) && c > 0 && p <= c
			    && p >= iop->_base - iop->_ptr){
				iop->_ptr += (int) p;
				iop->_cnt -= (int) p;
				return(0);
			}
		}
		if (iop->_flag & _IORW) {
			iop->_ptr = iop->_base;
			iop->_flag &= ~_IOREAD;
		}
		p = seek(fileno(iop), offset, ptrname);
		iop->_cnt = 0;
	} else if(iop->_flag & (_IOWRT|_IORW)) {
		fflush(iop);
		if (iop->_flag & _IORW) {
			iop->_cnt = 0;
			iop->_flag &= ~_IOWRT;
			iop->_ptr = iop->_base;
		}
		p = seek(fileno(iop), offset, ptrname);
	}
	if (p == -1)
		return(_stdioerr(errno, "fseek", iop->_filename));
	return(0);
}
