/*
 * Unix routine to do an "fopen" on file descriptor
 * The mode has to be repeated because you can't query its
 * status
 */

#include <stdio.h>
#include <stdioerr.h>

FILE *
fdopen(fd, mode)
	register char *mode;
{
	register FILE *iop;
	extern FILE *_findiop();
	extern char *malloc();

	iop = _findiop();

	iop->_cnt = 0;
	iop->_file = fd;
	if (_okalloc())
		iop->_filename = sprintf(malloc(10), "(fd %d)", fd);
	else
		iop->_filename = "(name unknown)";
	switch (*mode) {

	case 'r':
		iop->_flag |= _IOREAD;
		break;

	case 'a':
		seek(fd, 0, 2);
		/* No break */
	case 'w':
		iop->_flag |= _IOWRT;
		break;

	default:
		return(_stdioerr(EMODE, "fdopen", iop->_filename));
	}

	if (mode[1] == '+') {
		iop->_flag &= ~(_IOREAD|_IOWRT);
		iop->_flag |= _IORW;
	}

	return(iop);
}
