/*
 * symbol table routines
 */

#include "stdio.h"
#include "sym.h"
#include "cpp.h"

/*
 * hash macro takes a name string
 * and changes the variable h to the hash value,
 * len has the string length
 * h should be declared as an unsigned int
 */

#define hash(cp) {\
	register char *p;\
\
	h = 0;\
	for (p = cp; *p != '\0'; p++)\
		h += *p;\
	h %= HSHSIZ;\
	len = p-cp;\
	}

#include "keywords"

static SYM *hashp[HSHSIZ];

/*
 * ulookup looks for a USERSYM
 */

SYM *ulookup(name)
char *name;{

	register unsigned int h;
	register SYM *s;
	int len;

	hash(name);
	for (s = hashp[h]; s != NULL; s = s->s_chain) {
		if (s->s_class==USERSYM && strcmp(s->s_name, name)==0)
			break;
		}
	return(s);
	}

/*
 * cntl looks for a CONTROL keyword, returns 0 if it can't find one
 * otherwise it returns the corresponding value
 */

cntl(name)
char *name;{

	register unsigned int h;
	register SYM *s;
	int len;

	hash(name);
	for (s = hashp[h]; s != NULL; s = s->s_chain) {
		if (s->s_class==CONTROL && strcmp(s->s_name, name)==0)
			break;
		}
	if (s == NULL) return(0);
	return(s->s_macro);
	}

/*
 * note: the insert routine defaults the class to USERSYM
 */

SYM *insert(name)
char *name;{

	register unsigned h;
	register SYM *s, *ns;
	char *space, *np, *malloc();
	int len;

	hash(name);
	space = malloc(sizeof(SYM)+len+1);
	ns = (SYM *) &space[0];
	np = &space[sizeof(SYM)];
	s = hashp[h];
	hashp[h] = ns;
	ns->s_chain = s;
	strcpy(np, name);
	ns->s_name = np;
	ns->s_class = USERSYM;
	ns->s_macro = 0;
	ns->s_value = NULL;
	return(ns);
	}

/*
 * delete a symbol, we assume the class is USERSYM
 * it doesn't make sense to delete control keywords
 */

deletesym(name)
char *name;{

	register unsigned h;
	register SYM *s;
	SYM *lasts;
	int len;

	hash(name);
	lasts = NULL;
	for (s = hashp[h]; s != NULL; lasts = s, s = s->s_chain)
		if (s->s_class==USERSYM && strcmp(s->s_name, name)==0)
			break;
	if (s == NULL) return;
	if (lasts == NULL) hashp[h] = s->s_chain;
	else lasts->s_chain = s->s_chain;
	if (s->s_value != NULL)
		free(s->s_value);
	free((char *) s);
	}

/*
 * initialize the symbol table with control keywords
 */

syminit() {

	register SYM *s, *t;
	SYM *last;

	last = &defsym[sizeof(defsym)/sizeof(SYM)];
	for (s = &defsym[0]; s < last; s++) {
		t = insert(s->s_name);
		t->s_class = s->s_class;
		t->s_macro = s->s_macro;
		t->s_value = s->s_value;
		t->s_chain = s->s_chain;
		}
	slineno = insert("_LINENO");
	sfilenm = insert("_FILENM");
	slineno->s_macro = sfilenm->s_macro = 2;
	}
