/*
 * C preprocessor
 */

#include "stdio.h"
#include "ctype.h"
#include "cpp.h"
#include "sym.h"

int lineno[MAXINCL];
char *dir[MAXDIRS];
char **stddirp;
char *filename[MAXINCL];
char *getident(), *getstring(), *getcom();
char *malloc(), *strcpy();
short cntlchar = '#';

static int ndir = 1;
static int warnflg = 0;
static int endif = 0;
static int elseif = 0;
static int errflg = 0;
static int ifsw[MAXIF];

FILE *in = stdin;
FILE *out = stdout;

main(argc, argv)
int argc;
char **argv;{

	register char *p;

	incl = 0;
	bufftop = pbuf;
	filename[0] = "";
	syminit();
	define("unix", "unix", 0);
	while (--argc) {
		++argv;
		if (**argv == '-') switch(*(*argv+1)) {
			case 'P':
				continue;

			case 'I':
				dir[ndir++] = *argv+2;
				if (ndir >= MAXDIRS-3)
					panic("too many include dirs");
				continue;

			case 'U':
				deletesym(*argv+2);
				continue;

			case 'D':
				p = *argv+2;
				while (*p != '=' && *p != '\0') p++;
				if (*p == '=') *p++ = '\0';
				define(*argv+2, p, 0);
				ulookup(*argv+2)->s_filename = "command line";
				continue;
		/*
		 * non-standard options
		 */
			case 'C':
				cntlchar = *(*argv+2);
				continue;

			case 'W':
			        warnflg++;
				continue;

			default:
				panic("unknown flag %s", *argv);
			}
		else {
			if (in == stdin) {
				if ((in = fopen(*argv, "r")) == NULL)
					panic("Can't open %s", *argv);
				getdir(homedir, *argv);
				filename[0] = *argv;
				}
			else if (out == stdout) {
				if ((out = fopen(*argv, "w")) == NULL)
					panic("Can't write %s", *argv);
				}
			else panic("extraneous file %s", *argv);
			}
		}
	dir[0] = homedir;
	stddirp = &dir[ndir];
	if ((p = getenv("INCLUDE")) != NULL) {
		for (;;) {
			dir[ndir++] = p;
                        while (*p != ':' && *p != '\0') p++;
			if (*p == '\0') break;
			else *p++ = '\0';
			}
		}
	dir[ndir++] = INCLDIR;
	dir[ndir] = NULL;
	fp[0] = in;
	lineno[0] = 1;
	fprintf(out, "# 1 \"%s\"\n", filename[0]);
	preprocess();
	if (errflg) exit(1);
	}

/*
 * preprocess a file
 */

preprocess(){

	char line[MAXLINE];

	ifsw[endif] = ON;
	while (getline(line, MAXLINE) > 0) {
		if (line[0] == cntlchar) control(line);
		else if (ifsw[endif] == ON) subst(line);
		putc('\n', out);
		lineno[incl]++;
		}
	}

/*
 * handle a control line
 */

control(lp)
register char *lp;{

	char id[MAXIDENT];
	register int c;
	char *file, **dirp;
	int m;

	for (++lp; *lp==' ' || *lp=='\t'; lp++);
	if (*lp == '\n') return;
	lp = getident(lp, id);
	c = cntl(id);

/*
 * this is a kludge -- but then so are ifdef's
 */
	if (ifsw[endif]==OFF && c!=ENDIF && c!=ELSE) {
		if (c == IFDEF || c == IFNDEF || c == IF) {
			endif++;
			elseif++;
			ifsw[endif] = OFF;
			}
		return;
		}
	switch(c) {
		case DEFINE:
			lp = getident(lp, id);
			if (id[0] == '\0') {
				error("Control syntax");
				return;
				}
			if (*lp == '(') m = 1;
			else {
				m = 0;
				lp++;
				}
			define(id, lp, m);
			return;

		case UNDEF:
			lp = getident(lp, id);
			if (id[0] == '\0') {
				error("Control syntax");
				return;
				}
			deletesym(id);
			return;

		case INCLUDE:
			for (; *lp==' ' || *lp=='\t'; lp++);
			if (*lp == '"') dirp = &dir[0];
			else if (*lp == '<') {
				dirp = stddirp;
				*lp = '>';
				}
			else {
				error("Control syntax");
				return;
				}
			file = lp++;
			for (; *lp != *file && *lp != '\0'; lp++);
			if (*lp == '\0') error("Non-terminated string");
			else *lp = '\0';
			include(file+1, dirp);
			return;

		case IFDEF:
			ifsw[endif+1] = OFF;
		case IFNDEF:
			if (c == IFNDEF) ifsw[endif+1] = ON;
			endif++;
			elseif++;
			lp = getident(lp, id);
			if (ulookup(id) != NULL)
				ifsw[endif] = (!ifsw[endif])&ifsw[endif-1];
			return;

		case ENDIF:
			if (endif == 0) error("If-less endif");
			else --endif;
			return;

		case ELSE:
			if (elseif == 0 || endif == 0)
				error("If-less else");
			else {
				--elseif;
				ifsw[endif] = (!ifsw[endif])&ifsw[endif-1];
				}
			return;

		case LINE:
			sharpline(lp);
			return;

		case IF:
			pushback(lp);
			endif++;
			elseif++;
			ifsw[endif] = OFF;
			if (yyparse()) ifsw[endif] = ifsw[endif-1];
			return;

		default:
			error("Undefined control");
		}
	}

/*
 * define an identifier
 */

define(id, val, mflag)
register char *id, *val;
int mflag;{

	register SYM *s;
	register unsigned int i;

	i = strlen(val);
	if (val[i-1] == '\n') val[i-1] = '\0';
	else i++;
	if (i == 0) i++;
	if ((s = ulookup(id)) == NULL)
		s = insert(id);
	if (strcmp(val, id) == 0) s->s_macro = 2;
	else s->s_macro = mflag;
	if (s->s_value) {
		free(s->s_value);
		if (warnflg)
			error("%s already defined in %s at line %d",
				s->s_name, s->s_filename, s->s_lineno);
		}
	s->s_filename = filename[incl];
	s->s_lineno = lineno[incl];
	def(s, val);
	}
/*
 *  Check for comments extending over several lines
 */
def(s, val)
SYM     *s;
char    *val;
{
	char    buf[MAXLINE];
	char    line[MAXLINE];
	register char   *b, *v;
	register int    bix, eix;
	int     i;

	i = strlen(val);
        if ((bix = sindex(val, "/*")) != -1) {
		if (((eix = sindex(val, "*/")) == -1) || (eix <= bix)) {
			b = buf;
			v = val;
                        while (*v) {
				if (b >= &buf[MAXLINE])
					error("Comment too long\n");
				*b++ = *v++;
                                }
                        for (;;) {
                                if (getline(line, MAXLINE) == 0)
                                        panic("Premature EOF, comment not closed\n");
				lineno[incl]++;
                                line[strlen(line) - 1 ] = '\0';
                                v = line;
                                while (*v) {
                                        if (b >= &buf[MAXLINE])
                                                error("Comment too long\n");
                                        *b++ = *v++;
                                        }
                                if (sindex(line, "*/") != -1)
					break;
                                }
                        i = strlen(buf);
                        val = buf;
                        }
                }
        s->s_value = malloc(i);
        strcpy(s->s_value, val);
	}

/*
 * do an include (recursively perhaps)
 */

include(file, dirp)
char *file;
char **dirp;{

	char ibuf[MAXLINE];

	for (; *dirp; dirp++) {
		if (strcmp(*dirp, ".")==0 || file[0]=='/')
			strcpy(ibuf, file);
		else sprintf(ibuf, "%s/%s", *dirp, file);
		if ((in = fopen(ibuf, "r")) != NULL) {
			fp[++incl] = in;
			if (incl > MAXINCL) {
				error("Unreasonable include nesting");
				return;
				}
			filename[incl] = strdup(ibuf);
			lineno[incl] = 1;
			fprintf(out, "# 1 \"%s\"\n", ibuf);
			preprocess();
			fclose(in);
			in = fp[--incl];
			fprintf(out, "# %d \"%s\"\n", lineno[incl],
                                filename[incl]);
			return;
			}
		}
	error("Can't find include file \"%s\"", file);
	in = fp[incl];
	}

/*
 * Process the # line preprocessor statement.
 * Its format should be:  # line <integer> "<filename>" \n
 * An alternate form is: # line <integer> \n
 * lp points after the word "line".
 */

sharpline(lp)
char *lp;
{
	int n;
	char *file;

	while (*lp == ' ' || *lp == '\t')
		++lp;
	if (!isdigit(*lp)) {
		error("missing line number in #line");
		return;
	}
	n = 0;
	while (isdigit(*lp)) {
		n = 10*n + (*lp-'0');
		++lp;
	}
	while (*lp == ' ' || *lp == '\t')
		++lp;
	if (*lp == '\n') {
		fprintf(out,"# %d\n",n);
		return;
	}
	if (*lp != '"') {
		error("missing \" in #line");
		return;
	}
	++lp;
	file = lp;
	while (*lp && *lp != '"')
		++lp;
	if (*lp != '"') {
		error("missing \" in #line");
		return;
	}
	*lp = 0;
	++lp;
	while (*lp == ' ' || *lp == '\t')
		++lp;
	if (*lp != '\n') {
		error("extra chars in #line");
		return;
	}
	fprintf(out,"# %d \"%s\"",n,file);
	lineno[incl] = n-1;
        /*
         * -1 because of newlines in include
	 * this whole line number business is poorly designed.
	 */
	filename[incl] = malloc((unsigned) strlen(file)+1);
	strcpy(filename[incl], file);
}

/*
 * getdir - get the home directory of a file
 */

getdir(dname, fname)
register char *dname, *fname;{

	register char *p;

	for (p = dname; *fname;)
		*p++ = *fname++;
	while (*--p != '/' && p > dname);
	if (p == dname) *p++ = '.';
	*p = '\0';
	}

/*
 * subst - read a line performing substitution and expansion
 */

subst(lp)
register char *lp;{

	register int c, loop;
	char *line, *start;
	char id[MAXIDENT];
	register SYM *p;

	loop = 0;
	start = lp;
	while ((c = *lp++) != '\n') {
		if (c == '"' || c == '\'') {
			lp = getstring(lp, c);
			continue;
			}
		if (!ALPH(c)) {
			putc(c, out);
			if (c == '/') {
				if (*lp == '*') {
					putc('*', out);
					lp = getcom(start, lp+1);
					continue;
					}
				}
			continue;
			}
		line = lp-1;
		lp = getident(lp-1, id);
		if ((p = ulookup(id)) != NULL && p->s_macro != 2) {
			if (loop++ > LOOPMAX) {
				error("define recursion loop on %s", id);
				return;
				}
			pushback(lp);
			if (p->s_macro) expand(p->s_value);
			else pushback(p->s_value);
			getline(lp, MAXLINE-(lp-start));
			}
		else if (p == slineno)
			fprintf(out, "%d", lineno[incl]);
		else if (p == sfilenm)
			fprintf(out, "\"%s\"", filename[incl]);
		else fwrite(line, 1, lp-line, out);
		}
	}

/*
 * expand a macro, p points to the prototype
 */

static char ebuf[MAXLINE], obuf[MAXLINE], proto[MAXLINE];

expand(p)
register char *p;{

	char *argname[MAXNARGS], *argval[MAXNARGS];
	register char *pbufp = ebuf;
	register char *obufp = obuf;
	register int n;
	char *s, *id;
	int b, c, m, level;

	if (strlen(p) >= MAXLINE) {
		error("define prototype too big");
		return;
		}
	strcpy(proto, p);
	p = proto;

	/*
	 * get argument names from beginning of prototype
	 */
	p++;
	for (n = 0; *p != '\0'; n++, p++) {
		if (n >= MAXNARGS) {
			error("too many define arguments");
			return;
			}
		while (isspace(*p)) p++;
		if (*p == ')') {
			p++;
			break;
			}
		if (!ALPH(*p)) {
			error("define prototype argument error");
			return;
			}
		argname[n] = p;
		while (ALNUM(*p)) p++;
		c = *p;
		*p = '\0';
		if (c != ',' && c != ')' && c != '\0') {
			do { p++; } while (isspace(*p));
			c = *p;
			}
		if (c == ')') {
			p++;
			break;
			}
		if (c == '\0') {
			error("non-terminated macro define");
			return;
			}
		}
	while (isspace(*p)) p++;

	/*
	 * now get values from input
	 */
	do { c = getch(); } while (isspace(c));
	if (c != '(') {
		error("defined function requires arguments");
		return;
		}
	argval[0] = ebuf;
	m = 1;
	for (level = 1; level > 0;) {
		switch(c = getch()) {
			case '(':
				level++;
				break;
			case ')':
				if (--level == 0)
					*pbufp++ = '\0';
				break;
			case '\'':
			case '"':
				*pbufp++ = c;
				while ((b = getch()) != c && b != '\0') {
					*pbufp++ = b;
					if (b == '\\') *pbufp++ = getch();
					if (pbufp >= ebuf+MAXLINE) {
						error("string too long");
						return;
						}
					}
				break;
			case ',':
				if (level == 1) {
					*pbufp++ = '\0';
					argval[m++] = pbufp;
					if (m > MAXNARGS) {
						error("define argument mismatch");
						return;
						}
					continue;
					}
				break;
			case EOF:
			case '\0':
				error("non-terminated macro call");
				return;
			}
		*pbufp++ = c;
		}
	*pbufp = '\0';
	if (n != m-1) {
		error("define argument mismatch");
		return;
		}

	/*
	 * now go back to the prototype, copy it into obuf while substituting
	 * argval's, then push the whole thing back for further processing
	 */
	while (*p) {
		if (!ALPH(*p)) {
			*obufp++ = *p++;
			if (obufp >= obuf+MAXLINE)
				panic("buffer overflow");
			continue;
			}
		id = p;
		while (ALNUM(*p)) p++;
		c = *p;
		*p = '\0';
		if (c != '\0') p++;
		for (n = 0; n < m; n++) {
			if (strcmp(argname[n], id) == 0) {
				for (s = argval[n]; *s;)
					*obufp++ = *s++;
				break;
				}
			}
		if (n == m) {
			for (s = id; *s;) *obufp++ = *s++;
			}
		*obufp++ = c;
		}
	*obufp = '\0';
	pushback(obuf);
	}

pushback(p)
register char *p;{

	register char *s, *t;

	for (s = p; *s != '\0'; s++);
	t = bufftop;
	while (s > p) {
		*t++ = *--s;
		if (t >= pbuf+PBFSIZ) panic("Buffer overflow");
		}
	bufftop = t;
	}

char *getstring(lp, c)
register char *lp;
register int c;{

	register int a;

	putc(c, out);
	while ((a = *lp++) != c && a != '\n') {
		putc(a, out);
		if (a == '\\') putc(*lp++, out);
		}
	if (a == c) {
		putc(c, out);
		return(lp);
		}
	else return(lp-1);
	}

char *getcom(s, lp)
register char *s, *lp;{

	register int c;

	while ((c = *lp++) != '\0') {
		if (c == '*') {
			if (*lp == '/') {
				fprintf(out, "*/");
				return(lp+1);
				}
			}
		else if (c == '\n') {
			lineno[incl]++;
			if (getline(s, MAXLINE) == 0)
				return(s);
			lp = s;
			}
		putc(c, out);
		}
	}

char *getident(lp, id)
register char *lp, *id;{

	register int c;

	while ((c = *lp++) == ' ' || c == '\t');
	if (ALPH(c)) {
		do {
			*id++ = c;
			c = *lp++;
			} while (ALNUM(c));
		}
	*id = '\0';
	return(lp-1);
	}

getline(bufp, maxlen)
register char *bufp;
int maxlen;{

	register int c, count;

	count = 0;
	while ((c = getch()) != '\n' && c != EOF) {
		if (count++ >= maxlen) {
			error("Line too long");
			return(count);
			}
		if (c == '\\') {
			if ((c = getch()) == '\n') {
				lineno[incl]++;
                                putc('\n', out);
				continue;
				}
			*bufp++ = '\\';
			}
		*bufp++ = c;
		}
	*bufp++ = '\n';
	*bufp = '\0';
	if (c == '\n') count++;
	return(count);
	}

/*
 * non-fatal error handling routine
 */

/*VARARGS*/
error(arglist)
char *arglist;{

	fflush(stdout);
	if (*filename[incl]) fprintf(stderr, "%s:", filename[incl]);
	if (lineno[incl]) fprintf(stderr, "%d: ", lineno[incl]);
	fprintf(stderr, "%r", &arglist);
	putc('\n', stderr);
	bufftop = pbuf;
	errflg++;
	}

/*
 * fatal error handling routine
 */

/*VARARGS*/
panic(args)
char *args;{

	error("");
	fprintf(stderr, "%r", &args);
	putc('\n', stderr);
	exit(1);
	}

/*
 * yacc error handling for #if errors
 */

yyerror(s)
char *s;{

	panic("syntax error in #if expression");
	}
