#include "tlbsim.h"
#include "param.h"
#include "manifest.h"
#include "user.h"

struct tlb tlb[TLBSIZE];
int mask[] { 8, 4, 2, 1 };

int *gpr;
int *psw;
int tlbsim_end;
short int saved_ins;

extern struct instype instab[];
extern int omakbp();

tlbsim()
{
        register int *p, *q;
        register short int *loc;
        int tlbbp();


	if (u->u_arg[0] == START) {
		tlbsim_end = 0;
		purge_tlb();                    /* clear the tlb */
		gpr = u->u_ar0;                 /* user gpr's    */
		psw = (char *) u->u_ar0 + 64;   /* user psw      */
                p = SVPSW;                      /* save area for svc psw */
                q = SVCNPSW;                    /* svc new psw -- loc 60 */
		if ( *(q+1) == &omakbp)         /* check if omak is present */
			q = NORSVCN;
		*p = *q;
		*(p+1) = *(q+1);
		*q = 0x00080000;
		*(q+1) = &tlbbp;
		loc = (short int *) next_bp(psw[1]);

		/* set break point */

		saved_ins = *loc;
		*loc = BPSVC;

	} else
		tlbsim_end = 1;          /* stop tlb simulation */
}


next_bp(loc)
register int loc;
{
	register struct cons_ins c;
        register int cc, ins_type, *npsw, tmploc, eff_addr;
	short int *i, *j, value;

        /* check for DAT */

        if (psw[0] & DAT)
                tmploc = ldreal(loc);
        else
	        tmploc = loc;

	j = tmploc;
	c = *(struct cons_ins *) j;

        if ((ins_type = instab[c.opcode].type) == NULL)
                panic("TLBSIM: Illegal opcode\n");

        /* get condition code */

        cc = (psw[0] >> 12) & 0x03;

        switch(ins_type) {
                case RR:
                        switch(c.opcode) {
                                case BALR:
                                        if (c.r2)
                                                loc = GPR(c.r2);
                                        else
                                                loc += BPHW;

                                        break;

                                case BCTR:
                                        if ((GPR(c.r1)-1) == 0)
                                                loc += BPHW;
                                        else
                                                if (c.r2)
                                                        loc = GPR(c.r2);
                                                else
                                                        loc += BPHW;
                                        break;

                                case BCR:
                                        if (mask[cc] & c.r1)
                                                loc = GPR(c.r2);
                                        else
                                                loc += BPHW;
                                        break;

                                default:
                                        loc += BPHW;
                                        break;
                        }

                        break;

                case RX:
                        switch(c.opcode) {
                                case BAL:
                                        loc = c.disp1;

                                        if (c.r2)
                                                loc += GPR(c.r2);

                                        if (c.base1)
                                                loc += GPR(c.base1);

                                        break;

                                case BCT:
                                        if ((GPR(c.r1)-1) == 0)
                                                loc += BPW;
                                        else {
                                                loc = c.disp1;

                                                if (c.r2)
                                                        loc += GPR(c.r2);

                                                if (c.base1)
                                                        loc += GPR(c.base1);
                                        }
                                        break;

                                case BC:
                                        if (mask[cc] & c.r1) {
                                                loc = c.disp1;
                                                if (c.r2)
                                                        loc += GPR(c.r2);
                                                if (c.base1)
                                                        loc += GPR(c.base1);
                                        }
                                        else
                                                loc += BPW;

                                        break;

                                case EX:
					eff_addr = c.disp1;
					if (c.base1)
						eff_addr += GPR(c.base1);
					if (c.r2)
						eff_addr += GPR(c.r2);
                                        if ((tmploc = next_bp(eff_addr)) > BPW + BPHW)
                                                loc = tmploc;
					break;

                                default:
                                        loc += BPW;
                                        break;
                        }

                        break;

                case RS:
                case SI:
                        loc += BPW;
                        break;

                case S:
                        switch(c.sopcode) {
                                case LPSW:
                                        if (c.base1 == 0)
                                                npsw = c.disp1;
                                        else
                                                npsw = GPR(c.base1) + c.disp1;

                                        /* check dat */

                                        if (npsw[0] & DAT)
                                                loc = ldreal(npsw[1]);
                                        else
                                                loc = npsw[1];

                                        break;

                                default:
                                        loc += BPW;
                                        break;
                        }

                        break;

                case SS:
                        loc += BPW + BPHW;
                        break;
        }

        if (psw[0] & DAT)
                   loc = ldreal(loc);

        return(loc);
}


chkoper(gpr_ptr,psw_ptr)
int *gpr_ptr, *psw_ptr;
{
	register int *p, *q, location;
	register short int *i;
	register int virtual;

	gpr = gpr_ptr;
	psw = psw_ptr;

	p = SVPSW;
	q = SVCNPSW;

	if (*(q+1)  == &omakbp)
		q = NORSVCN;

	virtual = 0;

	psw[1] -= BPHW; /* back up by length of svc */

	if (psw[0] & DAT) {
		location = ldreal(psw[1]);
		virtual = 1;
	} else
		location = psw[1];

	if (saved_ins == PTLB) purge_tlb();

	i = location;
	*i = saved_ins;

	if (tlbsim_end) {
		*q = *p;
		*(q+1) = *(p+1);
	} else
                if (virtual) {
                        calc_operand(psw[1]);
                        location = next_bp(psw[1]);
                        i = location;
                        saved_ins = *i;
                        *i = BPSVC;
                }
}


calc_operand(location)
int *location;
{
	register struct cons_ins c;
	register int ins_type, length, eff_addr;
	int virtual;
	int *i, target;

	c = *(struct cons_ins *) location;

        if ((ins_type = instab[c.opcode].type) == NULL)
                panic("TLBSIM: Illegal opcode\n");

        length = instab[c.opcode].len;

	translate(location, (((c.opcode & INSLEN) >> 6) *2) );

	switch(ins_type) {

		case RR:
			if (c.opcode == MVCL) {
			}
			break;

		case RX:
			switch(c.opcode) {

				case LA:
					break;

				case EX:
					eff_addr = c.disp1;
					if (c.base1)
						eff_addr += GPR(c.base1);
					if (c.r2)
						eff_addr += GPR(c.r2);

				        translate(eff_addr, BPW);

					i = eff_addr;
					target = *i;

					if (c.r1)
						target |= GPR(c.r1)<<16;

                                        calc_operand(&target);

                                        break;

				default:
					eff_addr = c.disp1;
					if (c.base1)
						eff_addr += GPR(c.base1);
					if (c.r2)
						eff_addr += GPR(c.r2);

					translate(eff_addr, length);

					break;
			}

			break;

		case RS:
			switch(c.opcode) {

				case STM:
				case LM:
					if (c.r1 < c.r2)
						length = (c.r2 - c.r1 + 1) * BPW;
					else
						length = (c.r1 - c.r2 + 1) * BPW;

					eff_addr = c.disp1;

					if (c.base1)
						eff_addr += GPR(c.base1);

					translate(eff_addr, length);

					break;

				default:
                                                break;
                        }

                        break;

		case SI:
                        eff_addr = c.disp1;

                        if (c.base1)
                                eff_addr += GPR(c.base1);

                        translate(eff_addr, length);

                        break;

		case S:
                        if (c.sopcode == PTLB)
                                purge_tlb();
                        else {
                                eff_addr = c.disp1;

                                if (c.base1)
                                        eff_addr += GPR(c.base1);

                                translate(eff_addr, length);
                        }

                        break;

		case SS:
			switch(c.opcode) {

				case MVC:
				case CLC:
				case XC:
				case TRT:
				break;
                        }

                        break;
        }
}


translate(addr1, len)
register int addr1, len;
{
	register int addr2, index;

	addr2 = (addr1 + len) & ~DISPMSK;
	addr1 &= ~DISPMSK;

	while ( addr1 <= addr2) {
		index = ((addr1 & PGMSK)>> PGSHFT) % TLBSIZE;
		if (tlb[index].key == addr1)
			tlb[index].hit++;
		else {
			tlb[index].key = addr1;
			tlb[index].miss++;
		}
		addr1 += PGSIZE;
	}
}


purge_tlb()
{
	register int index;

	for(index = 0; index < TLBSIZE; index++)
		tlb[index].key = -1;
}
