#include <stdio.h>
#include "ioconf.h"

/*
 * The device type table.
 *   Something is generated for each time a match is made in the table
 *   for a given device type.
 */

struct  type  types[] = {
        "1052",    D_CONS,       "cons",      0600,     "0Z",
        "console", D_CONS,       "cons",      0600,     "0Z",
        "2305",    D_DASD,       "dsk%%%",    0644,     "",
        "2305",    D_RDASD,      "rdsk%%%",   0600,     "",
        "2305",    D_FDASD,      "fdsk%%%",   0644,     "",
        "3330",    D_DASD,       "dsk%%%",    0644,     "",
        "3330",    D_RDASD,      "rdsk%%%",   0600,     "",
        "3330",    D_FDASD,      "fdsk%%%",   0644,     "",
        "3340",    D_DASD,       "dsk%%%",    0644,     "",
        "3340",    D_RDASD,      "rdsk%%%",   0600,     "",
        "3340",    D_FDASD,      "fdsk%%%",   0644,     "",
        "3350",    D_DASD,       "dsk%%%",    0644,     "",
        "3350",    D_RDASD,      "rdsk%%%",   0600,     "",
        "3350",    D_FDASD,      "fdsk%%%",   0644,     "",
        "dasd",    D_DASD,       "dsk%%%",    0644,     "",
        "dasd",    D_RDASD,      "rdsk%%%",   0600,     "",
        "dasd",    D_FDASD,      "fdsk%%%",   0644,     "",
        "3420",    D_TAPE,       "mt%%%",     0666,     "",
        "tape",    D_TAPE,       "mt%%%",     0600,     "",
        "term",    D_TERM,       "tty%%%",    0622,     "10",
        "3270",    D_TUBE,       "tty%%%",    0622,     "11",
        "3270",    D_FULLSCRN,   "tub%%%",    0666,     "",
        "3277",    D_TUBE,       "tty%%%",    0622,     "11",
        "3277",    D_FULLSCRN,   "tub%%%",    0666,     "",
        "3278",    D_TUBE,       "tty%%%",    0622,     "12",
        "3278",    D_FULLSCRN,   "tub%%%",    0666,     "",
        "1403",    D_PRT,        "printer%%%",0200,     "",
        "printer", D_PRT,        "printer%%%",0200,     "",
        "2501",    D_RDR,        "reader%%%", 0400,     "",
        "2540r",   D_RDR,        "reader%%%", 0400,     "",
        "reader",  D_RDR,        "reader%%%", 0400,     "",
        "2540p",   D_PUN,        "punch%%%",  0200,     "",
        "punch",   D_PUN,        "punch%%%",  0200,     "",
        "vm_ldev", D_LDEV,       "ldev%",     0666,     "",
	"vm_smsg", D_SMSG,       "smsg%",     0444,     "",
        "vm_cpcmd",D_CPCMD,      "vcf%",      0600,     "",
        "vm_vmcf", D_VMCF,       "vmcf%",     0666,     "",
        "vm_pvm",  D_PVM,        "pvm",       0666,     "",
        "vio",     D_VIO,        "vio%",      0644,     "",
        NULL,      0,            NULL,        0,        ""
};

/*
 *  Dummy drivers for dummy devices
 */
struct dmydrv dmydrv[] = {
	"root", D_ROOT, NULL,
	"pipe", D_PIPE, NULL,
	"dump", D_DUMP, NULL,
	NULL,   0,      NULL,
};

/*
 *   Table of special types.
 *      One entry is generated for each of these. The terminal type code
 *      is used to specify minor device number in this case.
 */
struct  type spectypes[] = {
        "special",      D_DIR,        "",           0755,       "0",  /* this must be first => /newdev */
        "special",      D_MEM,        "mem",        0644,       "0",
        "special",      D_MEM,        "null",       0666,       "1",
        "special",      D_DIR,        "kmem",       0755,       "0",
        "special",      D_MEM,        "kmem/proc",  0644,       "2",
        "special",      D_MEM,        "kmem/stats", 0644,       "3",
        "special",      D_MEM,        "kmem/inode", 0644,       "4",
        "special",      D_MEM,        "kmem/text",  0644,       "5",
        "special",      D_MEM,        "kmem/file",  0644,       "6",
        "special",      D_DIR,        "tape",       0775,       "0",
        "special",      D_TAGRDR,     "tag",        0400,       "0",
        "special",      D_SYSTTY,     "tty",        0666,       "0",
        NULL,           0,            NULL,         0,          ""
};

/*
 * Table of driver characteristics, and device count information
 */
struct  driver  drivers[] = {
        D_DASD,       "b", 0, 0, "",        "dskopen, dskclose, dskstrat", 0,
        D_VIO,        "b", 0, 0, "",        "nullsys, nullsys, viostrat", 0,
        D_CONS,       "c", 0, 0, "conaddr", "conopen, conclose, conread, conwrite, conioctl, nulldev", 0,
        D_TERM,       "c", 0, 0, "trmaddr", "trmopen, trmclose, trmread, trmwrite, trmioctl, nulldev", 0,
        D_TUBE,       "c", 0, 0, "tubaddr", "tubopen, tubclose, tubread, tubwrite, tubioctl, nulldev", 0,
        D_RDASD,      "c", 0, 0, "rdskaddr", "rwdopen, rwdclose, rwdread, rwdwrite, nottty, nulldev", 0,
        D_FDASD,      "c", 0, 0, "fdskaddr", "fdopen, fdclose, fdread, fdwrite, fdioctl, nulldev", 0,
        D_PRT,        "c", 0, 0, "prtaddr", "propen, prclose, nodev, prwrite, prioctl, nulldev", 0,
        D_PUN,        "c", 0, 0, "punaddr", "punopen, punclose, nodev, punwrite, nottty, nulldev", 0,
        D_RDR,        "c", 0, 0, "rdraddr", "cropen, crclose, crread, nodev, nottty, nulldev", 0,
        D_TAPE,       "c", 0, 0, "tapaddr", "tapopen, tapclose, tapread, tapwrite, tapioctl, nulldev", 0,
        D_FULLSCRN,   "c", 0, 0, "",        "fsopen, fsclose, fsread, fswrite, fsioctl, nulldev", 0,
        D_MEM,        "c", 0, 0, "",        "nulldev, nulldev, mmread, mmwrite, nottty, nulldev", 0,
        D_SYSTTY,     "c", 0, 0, "",        "syopen, nulldev, syread, sywrite, sysioctl, nulldev", 0,
        D_CPCMD,      "c", 0, 0, "",        "vcfopen, vcfclose, vcfread,  vcfwrite, nottty, nulldev", 0,
        D_TAGRDR,     "c", 0, 0, "",        "nulldev, nulldev, tagread, nodev, nottty, nulldev", 0,
        D_SMSG,       "c", 0, 0, "",        "smsgopen, smsgclose, smsgread, nodev, smsgctl, nulldev", 0,
        D_VMCF,       "c", 0, 0, "",        "vmcopen, vmcclose, vmcread, vmcwrite, vmcioctl, nulldev", 0,
        D_LDEV,       "c", 0, 0, "",        "ldsopen, ldsclose, ldsread, ldswrite, ldsioctl, nulldev", 0,
        D_PVM,        "c", 0, 0, "",        "pvmopen, pvmclose, pvmread,  pvmwrite, pvmioctl, nulldev", 0,
        D_DIR,        "d", 0, 0, "",        "",   /* dummy for directories */ 0,
        0,            0,   0, 0, 0,         0, 0
};

/*
 *  Default table for ioconf.h
 */
struct  confhdr confhdr[] = {
        D_TUBE,         "NTUBES",       1,      "/* 3270 tubes */",
        D_TERM,         "NTRMS",        1,      "/* Ascii terminals */",
        D_DASD,         "NDASD",        1,      "/* Dasd (disk) drives */",
        D_TAPE,         "NTAPE",        1,      "/* Tape drives */",
        D_CPCMD,        "NVCF",         1,      "/* Virtual Console Functions devices */",
        D_VMCF,         "NVMCF",        2,      "/* VM Communication Facility lines */",
        D_LDEV,         "NLDEV",        1,      "/* Logical Device Support Facility virtual devices */",
        D_SMSG,         "NSMSG",        1,      "/* Special Messages devices */",
        D_VIO,          "NVIO",         1,      "/* Virtual Dasd devices */",
        NULL,           NULL,           1,      NULL
};

/*
 *  This is the skeleton for generating /etc/spooler/spoollist
 *  The entries must be sorted according to the second field.
 */
struct  spool   spdaems[] = {
	D_PRT,  "o",    "/etc/spooler/oprd",    NULL,
	D_PUN,  "p",    "/etc/spooler/vmpunchd",NULL,
	D_TAPE, "t",    "/etc/spooler/taped",   NULL,
	0,      "",     "",                     NULL
};
