.mt "The Au I/O Configurator" "Design Description"
.au "Alan Ballard"
.fo @_

.hd 1 Introduction
The I/O configurator is a program which can be used to
generate an Au system for a particular hardware configuration.
.pp
Input to the program specifies the addresses and types of
the devices in the system.  The output consists of C source
for the configuration tables and certain other files, as described below.
.pp
The configuration process consists of running _iogen_(3) which requests
input for _ioconf_ and puts it in the file /devicelist. It then runs
_ioconf_ to create the configuration files, and if that is successful
uses _make_(1) to generate the new kernel. Upon successful generation
of the new kernel, it asks if the system should be installed, and if
the response is "yes", it creates the necessary backup files and installs
the new system in /au and /omak.
.pp
Note:
There are a number of other "configuration options" for Au which are
not part of the I/O configuration process.  These include the
number of users, number of processes per user, etc.  These options are
set by definitions in a header file.  Setting these
options is straight forward and should be done using the editor.

.hd 1 Au Configuration Dependencies
Au contains a number of components with dependencies on the actual
I/O configuration.  They are as follows:
.al
.le
/usr/src/sys/conf/conf.c,
containing the tables used to select device drivers and addresses
for particular major/minor device numbers (as well as a number of other
tables).
.le
/usr/src/sys/conf/iotab.c,
containing the channel, control unit and unit structures.
.le
/dev,
which defines all the special files.
.le
/etc/ttys,
which defines all terminal devices for which login processes should be
started.
.le
/etc/rootmtab,
which contains the mount information for the root disk (this is
configuation dependent only insofar as the name of the root disk depends
on the configuration).
.le
Omak and the console driver each require knowledge of the console
address.
.le
The tape mount spooler requires knowledge of the addresses of
tape drives and of the device names for all spooled devices.
.lx
The I/O configurator generates 1-5 of the above.
.pp
Configuration dependencies have been removed from
Omak, the console driver and the tape mount spooler.
They have been changed
to obtain the information from the I/O configuration tables.
A simple kernel service which returns a device address given its special
file name has been implemented. This is now used by the tape
mount spooler in order to obtain the device address of a tape device
(which it needs in order to issue the appropriate CP mount command).
The printer and reader spoolers have been changed so that they can find
devices with names of the form /dev/printerxxx and /dev/readerxxx
(where xxx is a physical device address), as generated
by the I/O configurator.

.hd 1 I/O Configurator Input
The input to the I/O configurator is a series of lines of the form
.dp
   hexaddr[-hexaddr] devicetype
.ed
Each specifies
an address or range of addresses, and the type of device at those
addresses.
.pp
The device types are codes which are used by the I/O configurator to
determine the driver to be used, special files to be generated, etc.
The I/O configurator also supports some types which do not correspond
to actual physical hardware device types.  For these, the address or
address range serves only to indicate the number of these "devices" to be
configured.
.pp
Note that since the Au kernel has no provision for multiple paths or
other more complex I/O structures, it is not considered necessary
for the input to _ioconf_ to have any specific knowledge of
the channels and physical control units.  The required entries for
the I/O tables are inferred from the device addresses.
.pp
Examples:
.pp
.in+3
620-62f 3270
.in
.pp
specifies that addresses 620 through 62f contain 3270 terminals.
_Ioconf_ generates the required channel, control unit and unit
tables. It also generates entries in the table tubaddr,
special files (both /dev/tubnn and /dev/ttynn),
and entries for /etc/ttys.
.pp
.in+3
240-246 3330
.in
.pp
specifies that addresses 240 through 246  contain 3330 disks.  The
program generates the appropriate iotab entries, entries in
bdevsw, rfdaddr, and special files /dev/dskxxx, /dev/fdskxxx, and
/dev/rdskxxx.

.pp
.in+3
1-f ldev
.in
.pp
generates fifteen logical devices (/dev/ldev1 through /dev/ldevf),
together with required entries in any other tables.

.hd 1 Implementation Notes
To facilitate addition by Amdahl of new drivers and supported
device types,
the program is
table driven.  The tables contain all the information required by
the I/O configurator to generate the output described above.
.pp
The program contains the following tables:
.al
.le
device type table
.pp
This contains information describing the
output to be generated for each supported device type.
It contains the following elements:
.vl 15
.le devicetype
A device type identifier as used in the input to _ioconf_
.le drivername
The name of a driver to use, as specified in the driver table.
.le special\ file\ name\ prefix
.br
The device names to be used for the /dev/xxxx entries generated.
.le access\ code
.br
access to be given to user, group and others for the special file
generated.
.le terminal\ type\ code
.br
A code (for terminal types only) to be entered in the /etc/ttys
file.
.lx
There may be more than one entry for a given device type -- in this
case the program generates the output indicated for each.
.pp
Example 1:
.pp
The type 3270 is represented by two table entries, as folllows:
.pp
"3270", "tube",       "tty%%%", "rw--w--w-", "11"
.br
"3270", "fullscreen", "tub%%%", "rw-rw-rw-", ""
.pp
The first of these indicates that devices of type 3270 use the driver
"tube", have special files with names of the form /dev/ttyxxx, which
are permitted rw to the user, w to other members of the group, and w
to all others, and an entry in the /etc/ttys file is to be emitted
with code "11".
.pp
The second line indicates these devices can also use
the driver "fullscreen".  For this, special files with
names of the form /dev/tubxxx will be generated and permitted as
described.

Since no terminal type code is given, there will not
be a line in /etc/ttys.
.pp
Example 2:
.pp
The type 3330 is represented by
the following three lines.
.pp
"3330", "dasd",     "dsk%%%", "rw-r--r--", ""
.br
"3330", "rawdasd",  "rdsk%%%","rw-------", ""
.br
"3330", "fastdasd", "fdsk%%%","rw-rw-r--", ""
.pp
For each 3330 defined, three special files are generated: one to be
used with the "dasd" driver, one with the "rawdasd" driver, and one
with the "fastdasd" driver.
.le
special type table
.pp
There is a table of special types. These types do _not_ correspond to
types used as input to _ioconf_, but are used to generate directories
and other special files that are always present in /dev. One special
file is generated for each entry in this table. The field which contains
the terminal type code in the type table is used here to specify what
minor device number the generated special file is to have. This is
important for the entries in /dev/kmem, and might be useful for other
"special" types.
.pp
Example:
.pp
The special file /dev/mem is created by a table entry of the form:
.pp
"special", "memory",  "mem",   "rw-r--r--", "0"
.le
device driver table
.pp
Another table contains device driver characteristics, and
is used to accumulate device count information.
It contains the following elements:
.vl 15
.le drivername
The names as used in the device type table.
.le driver\ type\ code
A code indicating whether the entry is for a character ("c"),
or block ("b") device.  Special codes are used to distinguish the
entries for the pipe device ("p"), and dummy entries used by
the special types table for directories ("d"), and the root
device ("r").
.le major\ number
This is generated and filled in by the I/O configurator.  For
block devices, a new major number is assigned to each device.
For character devices, the number is assigned the first
time the driver is required, and used by subsequent specifications.
.le device\ list
A list of devices built by the I/O configurator.
.le address\ table
Specifies name of a table to be built for mapping minor device
numbers back to device addresses.
.le entry\ points
A string specifying the names of the entry points for
the driver, used in building bdevsw and cdevsw.
.lx
.pp
Examples:
.pp
The driver table includes the following entries:
.pp
"dasd",    "b", 0, 0, "",
.br
\ \ \ \ \  "dskopen,dskclose,dskstrat"
.br
"rawdasd", "c", 0, 0, "rdskaddr",
.br
\ \ \ \ \  "rwdopen,rwdclose,rwdread,rwdwrite,nottty,nulldev"
.pp
The two 0's in each entry
are initial values of fields to be built by ioconf.
The remaining fields
indicate that the "dasd" driver is a block driver ("b"),
with entries "dskopen", etc., and the "rawdasd" driver is a
character driver with the specified entries, and with an address
mapping table to be built with name "rdskaddr".
.pp
Note that the driver names are not necessarily the same as the device
type identifiers, since some devices are accessed by more than one
driver (e.g., tube and fullscreen for 3270s) and some drivers are
used for more than one type of device (e.g., 3277, 3278s use same driver).
.lx
