%{
/*
 * Description:
 *    This component contains the LEX input for scanning input requests.
 */
%}

%{
#include "y.tab.h"

extern int      yylval; /* returns address or string ptr */
%}
%%
%{
 /*
  * newlines, blanks, etc.
  */
%}
"\\\n"                  ;          /* escaped newline */
"\n"                    return('\n');
[ \t]                   ;          /* ignore blanks and tabs */

"/*"[^\n]*            {         /* comments */
                        return(COMMENT);
                      }

%{
 /*
  * Hex number (when not matched above).
  */
%}
[0-9a-fA-F]                     |
[0-9a-fA-F][0-9a-fA-F]          |
[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]       {
			 yylval = tobinary(yytext,16);
                         return(ADDR);
                       }

%{
 /*
   Device types or mount names
  */
%}
[^- \t\n)]+           {
			yylval = yytext;
			if (yytext[0] == '/')
                                return(MOUNT);
                        return(DEVTYPE);
                      }

%{
 /*
  *  The dash.  Used as separator between addresses.
  */
%}
"-"                     return('-');

%{
 /*
  * Any other single character (always error, currently)
  */
%}
.                       return(yytext[0]);
%%
/*
 *  tobinary converts the specified hex or decimal string to a binary
 *  integer.
 */
tobinary(st, b)
char *st;               /* the string to convert */
register int b;         /* the base (10 or 16) */
{
	register int n, c;
	register char *s;
	int t;

	n = 0;
	s = st;
        while (c = *s++) {
		if (c >= '0' && c <= '9') t = c-'0';
		else if (b == 16 && c >= 'a' && c <= 'f') t = c-'a'+10;
		else if (b == 16 && c >= 'A' && c <= 'F') t = c-'A'+10;
		else {
                        error(0, "Illegal number");
                        /* gobble(); */
                        return(-1);
                }
		n = n*b+t;
        }
	return(n);
}
