/*
 * login [ name ]
 */

#include <sys/types.h>
#include <utmp.h>
#include <acct.h>
#include <signal.h>
#include <pwd.h>
#include <stdio.h>
#include <sys/stat.h>
#define SCPYN(a, b)	strncpy(a, b, sizeof(a))
#define SCMPN(a, b)     strncmp(a, b, sizeof(a))
#define local static
#define TIMEOUT 180

local char    maildir[30] =   "/usr/spool/mail/";
local struct  passwd nouser = {"", "nope"};
local struct  utmp utmp;
local char    minusnam[16] = "-";
local char    homedir[64] = "HOME=";
local char    *envinit[] = {homedir, "PATH=:/bin:/usr/bin", 0};
local struct  passwd *pwd;
local struct acct_log acct_wt = { A_LOGIN };

local struct  passwd *getpwnam();
char	*strcat();
int	setpwent();
char	*ttyname();
char	*crypt();
char	*getpass();
char	*rindex(), *index();
extern	char **environ;

login(name)
char *name;
{
	register char *namep;
	int t, f, c;
	char *ttyn, *pass;
	struct stat statb;

	signal(SIGQUIT, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	nice(-100);
	nice(20);
	nice(0);
	for (t=3; t<20; t++)
		close(t);
	ttyn = ttyname(0);
	if (ttyn==0)
		ttyn = "/dev/tty??";

	SCPYN(utmp.ut_name, name);
	while (utmp.ut_name[0] == '\0') {
    loop:
		namep = utmp.ut_name;
		printf("Name: ");
		alarm(TIMEOUT);
		while ((c = getchar()) != '\n') {
			if(c == ' ')
				c = '_';
			if (c == EOF)
				exit(0);
			if (namep < utmp.ut_name+8)
				*namep++ = c;
		}
		alarm(0);
		if(namep < utmp.ut_name+8)
			*namep = '\0';
	}
	if(SCMPN(utmp.ut_name, "root") != 0 && sysfull()) {
		printf("Maximum number of users has been exceeded.\n");
		goto loop;
	}
	setpwent();
	if ((pwd = getpwnam(utmp.ut_name)) == NULL)
		pwd = &nouser;
	endpwent();
	if (*pwd->pw_passwd != '\0') {
		alarm(TIMEOUT);
		pass = getpass("Password:");
		alarm(0);
		namep = crypt(pass,pwd->pw_passwd);
		if (strcmp(namep, pwd->pw_passwd)) {
			printf("Login incorrect\n");
			goto loop;
		}
	}
	if(chdir(pwd->pw_dir) < 0) {
		printf("No directory\n");
		goto loop;
	}
	utmp.ut_time = time();
	t = ttyslot();
	if (t>0 && (f = open("/etc/utmp", 1)) >= 0) {
		seek(f, t*sizeof(utmp), 0);
		SCPYN(utmp.ut_line, index(ttyn+1, '/')+1);
		write(f, (char *)&utmp, sizeof(utmp));
		close(f);
	}
	acct_wt.al_utmp = utmp;
	acctwrt(&acct_wt, sizeof acct_wt);
	chown(ttyn, pwd->pw_uid, pwd->pw_gid);
	setgid(pwd->pw_gid);
	setuid(pwd->pw_uid);
	if (*pwd->pw_shell == '\0')
		pwd->pw_shell = "/bin/sh";
	environ = envinit;
	strncat(homedir, pwd->pw_dir, sizeof(homedir)-6);
	if ((namep = rindex(pwd->pw_shell, '/')) == NULL)
		namep = pwd->pw_shell;
	else
		namep++;
	strcat(minusnam, namep);
	alarm(0);
	umask(02);
	showmotd();
	if(stat(".../news", &statb) != -1) {
		t = statb.st_mtime;
		if(stat("/usr/spool/mail/news", &statb) != -1) {
			if(t < statb.st_mtime)
				printf("There is news.\n");
		}
	}
	strcat(maildir, pwd->pw_name);
	if(access(maildir,4)==0) {
		stat(maildir, &statb);
		if (statb.st_size)
			printf("You have mail.\n");
	}
	signal(SIGQUIT, SIG_DFL);
	signal(SIGINT, SIG_DFL);
	fflush(stdout);
	execlp(pwd->pw_shell, minusnam, 0);
	printf("No shell\n");
	exit(0);
}

local int     stopmotd;
local catch()
{
	signal(SIGINT, SIG_IGN);
	stopmotd++;
}

local showmotd()
{
	FILE *mf;
	register c;

	signal(SIGINT, catch);
	if((mf = fopen("/etc/motd","r")) != NULL) {
		while((c = getc(mf)) != EOF && stopmotd == 0)
			putchar(c);
		fclose(mf);
	}
	signal(SIGINT, SIG_IGN);
}

local sysfull()
{
	struct utmp ut;
	FILE *fp;
	int nusers = 0;
	int maxusers = 999;

	fp = fopen("/etc/utmp", "r");
	if(fp == NULL)
		return(0);
	while(fread(&ut, sizeof ut, 1, fp) == 1) {
		if(ut.ut_name[0] != 0) nusers++;
	}
	fclose(fp);
	fp = fopen("/etc/maxusers", "r");
	if(fp == NULL)
		return(0);
	if(fscanf(fp, "%d", &maxusers) < 0) {
		fclose(fp);
		return(0);
	}
	return(nusers >= maxusers);
}
