#include <signal.h>
#include <sys/types.h>
#include <sys/stats.h>
#include <utmp.h>
#include <acct.h>
#include <setjmp.h>

#define	TABSIZ	100
#define ALL     p = &ttab[0]; p < &ttab[TABSIZ]; p++
#define	EVER	;;
#define GETTY(tty) getty(tty)
/* formerly:    execl("/etc/getty", minus, tty, (char *)0) */
#define local   static

local   char    shell[] = "/bin/sh";
local   char    minus[] = "-";
local   char    runc[]  = "/etc/rc";
local   char    ifile[] = "/etc/ttys";
local   char    utmpf[]  = "/etc/utmp";
local   char    ctty[]  = "/dev/cons";
local   char    dev[]   = "/dev/";

local struct utmp wtmp;
local struct acct_log acct_wtmp = { A_LOGIN };

local struct
{
	char	line[8];
	char	comn;
	char	flag;
} line;

local struct  tab
{
	char	line[8];
	char	comn;
	int	pid;
} ttab[TABSIZ];

local   int     fi;
local   char    tty[20];
local   jmp_buf sjbuf;

main()
{
	int reset();
	int diskfull();

	signal(SIGNOSPC, diskfull);   /* Not worth dying over. */
	setjmp(sjbuf);
	signal(SIGHUP, reset);
	for(EVER) {
		shutdown();
		single();
		runcom();
		merge();
		multiple();
	}
}

local shutdown()
{
	register i;
	register struct tab *p;

	signal(SIGINT, SIG_IGN);
	for(ALL)
		term(p);
	signal(SIGALRM, reset);
	alarm(60);
	for(i=0; i<5; i++)
		kill(-1, SIGKILL);
	while(wait((int *)0) != -1)
		;
	alarm(0);
	signal(SIGALRM, SIG_DFL);
	for(i=0; i<10; i++)
		close(i);
}

local single()
{
	/* Single user mode for AU is invoked from /etc/rc */
}

local runcom()
{
	register pid;

	pid = fork();
	if(pid == 0) {
		signal(SIGINTR, SIG_IGN);
		signal(SIGQUIT, SIG_IGN);
		open(ctty, 2);
		dup(0);
		dup(0);
		execl(shell, shell, runc, (char *)0);
		exit(0);
	}
	while(wait((int *)0) != pid)
		;
}

local multiple()
{
	register struct tab *p;
	register pid;

	for(EVER) {
		pid = wait((int *)0);
		if(pid == -1)
			return;
		for(ALL)
			if(p->pid == pid || p->pid == -1) {
				rmut(p);
				dfork(p);
			}
	}
}

local term(p)
register struct tab *p;
{

	if(p->pid != 0) {
		rmut(p);
		kill(p->pid, SIGKILL);
	}
	p->pid = 0;
	p->line[0] = 0;
}

local rline()
{
	register c, i;

	c = get();
	if(c < 0)
		return(0);
	if(c == 0)
		goto bad;
	line.flag = c;
	c = get();
	if(c <= 0)
		goto bad;
	line.comn = c;
	for(i=0; i<8; i++)
		line.line[i] = 0;
	for(i=0; i<7; i++) {
		c = get();
		if(c <= 0)
			break;
		line.line[i] = c;
	}
	while(c > 0)
		c = get();
	maktty(line.line);
	if(access(tty, 06) < 0)
		goto bad;
	return(1);

bad:
	line.flag = '0';
	return(1);
}

local maktty(lin)
char *lin;
{
	register i, j;

	for(i=0; dev[i]; i++)
		tty[i] = dev[i];
	for(j=0; lin[j]; j++) {
		tty[i] = lin[j];
		i++;
	}
	tty[i] = 0;
}

local get()
{
	char b;

	if(read(fi, &b, 1) != 1)
		return(-1);
	if(b == '\n')
		return(0);
	return(b);
}

local merge()
{
	register struct tab *p, *q;
	register i;

	close(creat(utmpf, 0644));
	signal(SIGINT, merge);
	fi = open(ifile, 0);
	if(fi < 0)
		return;
	q = &ttab[0];
	while(rline()) {
		if(line.flag == '0')
			continue;
		for(ALL) {
			if(p->line[0] != 0)
			for(i=0; i<8; i++)
				if(p->line[i] != line.line[i])
					goto contin;
			if(p >= q) {
				i = p->pid;
				p->pid = q->pid;
				q->pid = i;
				for(i=0; i<8; i++)
					p->line[i] = q->line[i];
				p->comn = q->comn;
				for(i=0; i<8; i++)
					q->line[i] = line.line[i];
				q->comn = line.comn;
				q++;
			}
			break;
		contin:
			;
		}
	}
	close(fi);
	/*
	 * Write bootstrap accounting record
	 */
	acct_wtmp.al_utmp.ut_name[0] = 0;
	acct_wtmp.al_utmp.ut_line[0] = '~';
	acct_wtmp.al_utmp.ut_line[1] = 0;
	acct_wtmp.al_utmp.ut_time = downtime();
	acctwrt(&acct_wtmp, sizeof acct_wtmp);

	for(; q < &ttab[TABSIZ]; q++)
		term(q);
	for(ALL)
		if(p->line[0] != 0 && p->pid == 0)
			dfork(p);
}

/*
 * Return the time that the system went down
 * for connect-time accounting
 */
local time_t downtime()
{
	struct stats stats;
	int fd;
	time_t t;

	if((fd = open("/dev/kmem/stats", 0)) < 0)
		return(time());
	if(read(fd, &stats, sizeof stats) != sizeof stats)
		t = time();
	else
		t = stats.s_downtime;
	close(fd);
	return(t);
}

local dfork(p)
struct tab *p;
{
	register pid, i;

	pid = fork();
	if(pid == 0) {
		signal(SIGHUP, SIG_DFL);
		signal(SIGINT, SIG_DFL);
		maktty(p->line);
		chown(tty, 0, 0);
		chmod(tty, 0622);
		while(open(tty, 2) != 0) {
			for(i=0; i<15; i++)
				close(i);
			sleep(60);
		}
		dup(0);
		dup(0);
		GETTY(p->comn);
		exit(0);
	}
	p->pid = pid;
}

local rmut(p)
register struct tab *p;
{
	register i, f;

	f = open(utmpf, 2);
	if(f >= 0) {
		while(read(f, (char *)&wtmp, sizeof(wtmp)) == sizeof(wtmp)) {
			if(wtmp.ut_name[0] && strncmp(wtmp.ut_line, p->line, 8) == 0) {
                                seek(f, -sizeof(wtmp), 1);
                                for(i=0; i<8; i++)
                                        wtmp.ut_name[i] = 0;
                                wtmp.ut_time = time();
                                write(f, (char *)&wtmp, sizeof(wtmp));
                                acct_wtmp.al_utmp = wtmp;
                                acctwrt(&acct_wtmp, sizeof acct_wtmp);
			}
		}
		close(f);
	}
}

local reset()
{
	longjmp(sjbuf, 1);
}
/*
 *  diskfull - caught a diskfull signal
 *  Print a message to the console and turn off accounting.
 */
diskfull(sig)
int     sig;
{
	int     fd;
	char    *msg = "Init: disk full, accounting terminated\n";

	acct(0);
	if ((fd = open("/dev/cons", 1)) != -1) {
		write(fd, msg, strlen(msg));
		close(fd);
	}
}
