
# line 2 "cmd.y"
/*
 * p/n
 * Program name:  Dump Formatter Syntax
 * Author:        Alan Ballard
 * Backup:
 * Description:
 *   This component contains the YACC grammar for the dump formatter
 *   program command language.
 */
# define COMMENT 257
# define MEM 258
# define FORM 259
# define ADDR 260
# define PRINT 261
# define SHELL 262
# define NUMBER 263
# define REM 264
# define FILENAME 265
# define SYMBOL 266
# define USER 267
# define TTY 268
# define BUF 269
# define CORETAB 270
# define TEXT 271
# define IOQ 272
# define DASD 273
# define TUBE 274
# define MOUNT 275
# define INODE 276
# define FILSTRUC 277
# define PROC 278
# define ACTIVE 279
# define UID 280
# define PID 281
# define PGROUP 282
# define COMMAND 283
# define STACK 284
# define CHAN 285
# define CU 286
# define UNIT 287

# line 22 "cmd.y"
#include "dump.h"
#include <stdio.h>
#include "tnode.h"

extern int    aptnum;           /* decimal numeric value from scanner */
extern int    cmdecho;          /* echo requests if true */
extern FILE *out;               /* output file */
extern char   prompt[];

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 140 "cmd.y"


/*
 *  tnode allocates a command tree node and sets its fields.
 */
struct tnode *tnode(o, v, l, r)
int o, v;
struct tnode *l, *r;
{
	register struct tnode *p;

	if ((p = calloc(1, sizeof(struct tnode))) == NULL)
                error(2, "out of memory");
	p->t_op = o;
	p->t_val = v;
	p->t_left = l;
	p->t_right = r;
	return(p);
}

/*
 *  yyerror calls are ignored.  synerr is called from the grammar
 *  This is because I can't get yyerror to work reasonably.
 */
yyerror(str)
char    *str;
{
}

/*
 *  synerr does trivial error recovery.  It reports a syntax
 *  error, then flushes to a newline.
 */
synerr()
{
	extern char yytext[];

        error(0, "syntax error: %s", yytext);
        if (yychar != '\n') {
                gobble();
                yyclearin;
        }
        yyerrok;
}

/*
 *  First level of tree evaluation.   This part is a substitute for
 *  equivalent routine in omak and dcon.
 *  The routines that are specific to dump printing are in exec.c
 */

/*
 * doreq is the basic recursive tree evaluation routine.
 *
 * parameter savflag is set if the caller does not want his tree
 * discarded; otherwise the nodes are released as the routine
 * returns.
 */
doreq(p, savflag)
struct tnode *p;
int savflag;
{
	register int v;
	register struct tnode *t1, *t2;
        struct formatentry *formp;
        int r, plen, temp, buf;

	v = p->t_val;
	t1 = p->t_left;
	t2 = p->t_right;
	r = 0;
	switch(p->t_op) {
                /*
                 *  first, the commands...
                 */
                case '!':
			if (v == NULL)
				v = "/bin/sh -i";
			system(v);
			cfree(v);
			printf("!\n");
			break;

                case FORM:
                case PRINT:
                case MEM:
                case ADDR:
                        dodump(p,savflag);
                        break;

                /*
                 *  Operands of expressions ...
                 */
		case NUMBER:
			r = v;
			break;

		case SYMBOL:
                        r = symlook(v);
                        if (r < 0)
                                error(0,"undefined symbol: %s", v);
			break;

		case '+':
		case '-':
		case '*':
                case '/':
                        r = calc(p -> t_op, t1, t2, savflag);
                        break;

		default:
                        error(1, "unknown request %x", p->t_op);
        }
	if (savflag == 0)
                cfree(p);
	return(r);
}

/*
 * calc performs the arithmetic operations.
 */
calc(op, t1, t2, savflag)
int op;
struct tnode *t1, *t2;
int savflag;
{
	register int v1, v2;

        v1 = doreq(t1, savflag);
	if (t2) v2 = doreq(t2, savflag);
	switch(op) {
		case '+':
			return(v1+v2);
		case '-':
			return(v1-v2);
		case '*':
			return(v1*v2);
                case '/':
			return(v1/v2);
		default:
			error(1, "unknown op %d", op);
        }
}

short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 9,
	10, 59,
	-2, 57,
	};
# define YYNPROD 60
# define YYLAST 273
short yyact[]={

  53,  54,  45,  56,  46,  59,  41,  42,  43,  44,
  47,  40,  17,  51,  52,  71,  57,  58,  48,  49,
  50,   4,  27,  25,  31,  26,  13,  28,  29,  74,
  27,  25,  66,  26,  78,  28,  67,  14,  24,  64,
  27,  25,  81,  26,   5,  28,  18,  27,  25,  27,
  26,  80,  28,  79,  28,  30,  70,  69,  68,  32,
  12,   2,  22,  60,  61,  62,  63,  38,  33,  55,
  37,  21,  39,  36,  72,  34,  35,  20,  23,  19,
   3,   1,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  65,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  73,   0,  75,  76,
  77,   0,   0,  82,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  16,   0,   0,  15,   0,
   0,   0,   0,  29,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  11,   6,   7,
  10,   8,   9 };
short yypact[]={

-1000,  11,-1000,  50,-1000,-238,-1000, -28, -28,-1000,
-1000,-1000,-1000,-1000, -20,-1000,-1000, -28,   5,-1000,
-1000,-1000,-241,-267,-1000, -28, -28, -28, -28,-1000,
  -2,-1000,-1000,-267, -91,-1000, -55,  18,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,  17,  16,-1000,-1000,-264,-1000,-1000,-1000,-1000,
   7,   7,-1000,-1000,-1000,-1000,-1000,-235,-234,-235,
-235,-1000, -28, -59,  12,  10,   1, -12,-1000,-1000,
-1000,-1000,-1000 };
short yypgo[]={

   0,  81,  80,  61,  37,  38,  79,  78,  59,  77,
  76,  75,  74,  73,  72,  70,  69,  68,  67,  62 };
short yyr1[]={

   0,   1,   1,   1,   2,   2,   2,   2,   2,   2,
   2,   7,   2,   2,   4,   4,   4,   4,   4,   4,
   4,   5,   6,   6,  12,  10,  11,  11,  13,  13,
  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,
  14,  14,  14,  14,  14,  14,  16,  15,   8,   8,
  17,  17,  17,  17,  17,  18,  18,  19,   9,   3 };
short yyr2[]={

   0,   3,   1,   2,   1,   2,   1,   2,   3,   2,
   2,   0,   3,   1,   1,   1,   3,   3,   3,   3,
   3,   1,   1,   1,   0,   5,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   2,   1,   1,   1,   1,   1,   1,   2,
   1,   1,   4,   4,   1,   4,   4,   0,   2,   0 };
short yychk[]={

-1000,  -1,  -3,  -2,  10,  33, 257, 258, 260, 261,
 259, 256,  10, 264,  -4, 266, 263,  40,  -4,  -6,
  -9,  -3, -19,  -7,  -5,  43,  45,  42,  47, 263,
  -4, 265,  -8, -17, -11, -10, -13, -15, -18, -14,
 278, 273, 274, 275, 276, 269, 271, 277, 285, 286,
 287, 280, 281, 267, 268, -16, 270, 283, 284, 272,
  -4,  -4,  -4,  -4,  41,  -8, 123,  91,  40,  40,
  40, 279, -12,  -5, 263,  -5,  -5,  -4,  93,  41,
  41,  41, 125 };
short yydef[]={

  59,  -2,   2,   0,   3,   4,   6,   0,   0,  -2,
  11,  13,   1,   5,   7,  14,  15,   0,   9,  10,
  22,  23,   0,   0,   8,   0,   0,   0,   0,  21,
   0,  58,  12,  48,  50,  51,  26,  29,  54,  27,
  28,  30,  31,  32,  33,  34,  35,  36,  37,  38,
  47,   0,   0,  39,  40,  41,  43,  44,  45,  46,
  16,  17,  18,  19,  20,  49,  24,   0,   0,   0,
   0,  42,   0,   0,   0,   0,   0,   0,  52,  53,
  55,  56,  25 };
#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

int yydebug = 0; /* 1 for debugging */
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

			if( yydebug ) printf( "error recovery discards char %d\n", yychar );

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

		if( yydebug ) printf("reduce %d\n",yyn);
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 1:
# line 34 "cmd.y"
{ if (yypvt[-1])
                                       doreq(yypvt[-1], 0);
                                   if (cmdecho)
                                       fprintf(out, "\n\n");
                                   fprintf(stderr, prompt);
                                } break;
case 2:
# line 40 "cmd.y"
{ fprintf(stderr, prompt); } break;
case 3:
# line 41 "cmd.y"
{ if (cmdecho)
                                       fprintf(out, "\n\n");
                                   fprintf(stderr, prompt);
                                   yyval = 0;
                                } break;
case 4:
# line 49 "cmd.y"
{ yyval = tnode('!', 0, 0, 0); endshell(); } break;
case 5:
# line 50 "cmd.y"
{ yyval = tnode('!', yypvt[-0], 0, 0); } break;
case 6:
# line 51 "cmd.y"
{ yyval = 0; } break;
case 7:
# line 52 "cmd.y"
{ yyval = tnode(MEM, 0, yypvt[-0], 0); } break;
case 8:
# line 53 "cmd.y"
{ yyval = tnode(MEM, 0, yypvt[-1], yypvt[-0]); } break;
case 9:
# line 54 "cmd.y"
{ yyval = tnode(ADDR, 0, yypvt[-0], 0); } break;
case 10:
# line 55 "cmd.y"
{ yyval = tnode(PRINT, 0, yypvt[-0], 0); } break;
case 11:
# line 57 "cmd.y"
{ strtform(); } break;
case 12:
# line 58 "cmd.y"
{ yyval = tnode(FORM, 0, yypvt[-0], 0);
                                   strtnorm();
                                } break;
case 13:
# line 61 "cmd.y"
{ synerr();  yyval = 0; } break;
case 14:
# line 64 "cmd.y"
{ yyval = tnode(SYMBOL, yypvt[-0], 0, 0); } break;
case 15:
# line 65 "cmd.y"
{ yyval = tnode(NUMBER, yypvt[-0], 0, 0); } break;
case 16:
# line 66 "cmd.y"
{ yyval = tnode('+', 0, yypvt[-2], yypvt[-0]); } break;
case 17:
# line 67 "cmd.y"
{ yyval = tnode('-', 0, yypvt[-2], yypvt[-0]); } break;
case 18:
# line 68 "cmd.y"
{ yyval = tnode('*', 0, yypvt[-2], yypvt[-0]); } break;
case 19:
# line 69 "cmd.y"
{ yyval = tnode('/', 0, yypvt[-2], yypvt[-0]); } break;
case 20:
# line 70 "cmd.y"
{ yyval = yypvt[-1]; } break;
case 21:
# line 73 "cmd.y"
{ yyval = aptnum;     /* decimal value */ } break;
case 22:
# line 76 "cmd.y"
{ /* not implemented yet */ } break;
case 23:
# line 77 "cmd.y"
{ /* not implemented yet */ } break;
case 24:
# line 81 "cmd.y"
{ strtnorm(); } break;
case 25:
# line 82 "cmd.y"
{ yyval = tnode(ADDREXPR, yypvt[-4], yypvt[-1],  0);
                                   strtform();
                                } break;
case 28:
# line 91 "cmd.y"
{ yyval = proccode; } break;
case 30:
# line 93 "cmd.y"
{ yyval = dasdcode; } break;
case 31:
# line 94 "cmd.y"
{ yyval = tubecode; } break;
case 32:
# line 95 "cmd.y"
{ yyval = mountcode; } break;
case 33:
# line 96 "cmd.y"
{ yyval = inodecode; } break;
case 34:
# line 97 "cmd.y"
{ yyval = bufcode; } break;
case 35:
# line 98 "cmd.y"
{ yyval = textcode; } break;
case 36:
# line 99 "cmd.y"
{ yyval = filecode; } break;
case 37:
# line 100 "cmd.y"
{ yyval = chancode; } break;
case 38:
# line 101 "cmd.y"
{ yyval = cucode;} break;
case 39:
# line 104 "cmd.y"
{ yyval = usercode; } break;
case 40:
# line 105 "cmd.y"
{ yyval = ttycode; } break;
case 41:
# line 106 "cmd.y"
{ yyval = ioqcode; } break;
case 42:
# line 107 "cmd.y"
{ yyval = activecode; } break;
case 43:
# line 108 "cmd.y"
{ yyval = coretabcode; } break;
case 44:
# line 109 "cmd.y"
{ yyval = commandcode; } break;
case 45:
# line 110 "cmd.y"
{ yyval = stackcode; } break;
case 47:
# line 116 "cmd.y"
{ yyval = unitcode; } break;
case 49:
# line 120 "cmd.y"
{ yypvt[-1] -> t_right = yypvt[-0]; } break;
case 50:
# line 123 "cmd.y"
{ yyval = tnode(TABLE, yypvt[-0], 0, 0); } break;
case 52:
# line 125 "cmd.y"
{ yyval = tnode(ARR, yypvt[-3], yypvt[-1], 0); } break;
case 53:
# line 126 "cmd.y"
{ yyval = tnode(DEV, yypvt[-1], 0, 0); } break;
case 55:
# line 130 "cmd.y"
{ yyval = tnode(PROC, UID, yypvt[-1], 0); } break;
case 56:
# line 131 "cmd.y"
{ yyval = tnode(PROC, PID, yypvt[-1], 0); } break;
case 57:
# line 135 "cmd.y"
{ strtfn(); } break;
case 58:
# line 136 "cmd.y"
{ yyval = yypvt[-0]; } break;
		}
		goto yystack;  /* stack new state and value */

	}
