/*
 * p/n:
 * Program name:         Dump Formatter main program
 * System name:
 * Author:               Alan Ballard
 * Backup:
 * Project Definition p/n:
 * Executable module:    /bin/dump
 * System Releases:
 *
 * Description:
 *    The dump formatter produces a formatted display of various
 *    Au kernel structures.  It can display from the live system or
 *    or a /DUMP file.
 *
 *    This component contains the main program and error routine.
 *
 * Documentation:
 *    See dump(c) for description of dump program commands.
 *    See "The Au Dump Formatter Implementation Notes" for
 *    implementation guide.
 */

#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include "dump.h"

/*
 * Following is offset of system name in real memory.
 * Really should be someway to get this more automatically.
 */
#define SYSNAME 0xC4

/*
 *  define buffer for standard output
 */
char    obuf[BUFSIZ];

/*
 *  file/device names for core and symbols.
 */
char    *memfile = "/dev/mem";    /* may change in initialization */
char    sysname[16];            /* file name read from mem */
char    *mapfile = NULL;          /* set in initialization */
int     live = 1;                 /* True if debugging live system. */

char    prompt[] = "+ ";
jmp_buf jmpbuf;
FILE    *out = stdout;            /* output file */

/*
 * Main routine - doesn't do much, just gets the name of the system
 *      file, reads the name list
 *	and then calls yyparse().
 *
 * The following flags are processed:
 *      -k       (ignored; for compatibility with dcon version)
 *      -e       specifies commands should be echoed.
 *
 * File name arguments:
 *      first, if given, is dump file (defaults to /dev/mem)
 *      second           is object file (default obtained from core file)
 *
 * Additional undocumented flags for debugging pd:
 *      -d      sets the Yacc debugging variable yydebug.
 */
main(argc, argv)
int argc;
char **argv;
{
        extern int yydebug;        /* YACC debugging option */
        extern int cmdecho;        /* LEX input echo */
	int     sigs();

        setbuf(stdout,NULL);       /* buffer the standard output */

        /*
         * process option parameters
         */
        argc--;  /* skip command name argument */
        argv++;
        while (argc>0 && argv[0][0] =='-' && argv[0][1] !='\0') {
                switch(argv[0][1]) {
			case 'd':
				yydebug = -1;
                                printf("debug mode on\n");
				break;
                        case 'e':
                                cmdecho = 1;
                                break;

                        case 'k':
                                break;

			default:
                                error(1,"invalid option %s",*argv);
                        }
		++argv;
		--argc;
		}

        switch (argc) {
                case 0:
                        break; /* defaults */

                case 1:
                        /* dump file */
                        memfile = *argv;
                        live = 0;
                        break;

                case 2:
                        /* dump file and map file  */
                        memfile = *argv;
                        mapfile = *++argv;
                        live = 0;
                        break;

                default:
                        error(1,"invalid arguments");
                }

	signal(SIGINTR, sigs);
        memop(memfile);   /* initialize for reading blocks of memory */

        /*
         *  If no object file was specified, get the name of the
         *  current system.
         */
        if (mapfile == NULL) {
                char    *retname;
                int     i;

                retname = (char *) getblk(SYSNAME, 15);
                sysname[0] = '/';
                for (i = 1;i <= 15; i++)
                        sysname[i] = *retname++;
                mapfile = sysname;
        }

        getsymtab(mapfile);       /* initialize the symbol table */

        if (live)
                printf("display from live system ");
        else
                printf("display from %s ",memfile);

        printf("with symbol table from %s\n",mapfile);

        /*
         *  Initialization complete; process commands.
         */
	setjmp(jmpbuf);
	yyparse();
	}

/*
 * All-purpose error routine.
 * Basically we just do a fprintf to stderr
 * A non-zero level indicates the error is fatal, program aborts.
 */
/* VARARGS */
error(level, arglist)
int level;
char *arglist;
{
	fprintf(stderr, "%r", &arglist);
	putc('\n', stderr);
	if (level)
                exit(level);
}

sigs(sig)
int     sig;
{
	int     sigs();

	fflush(out);
	signal(sig, sigs);
	longjmp(jmpbuf, 0);
}
