%{
/*
 * p/n:
 * Program Name:       Dump Formatter lexical scanner
 * Author:             Alan Ballard
 * Backup:
 *
 * Description:
 *    This component contains the LEX input for scanning input requests.
 */
%}

%Start PFILEN PSHCMD FORMAT
%{
#include "y.tab.h"
#include "dump.h"

#define input getinput

extern int      yylval;       /* value of hex string */
int             aptnum;       /* value of decimal string */
int             cmdecho = 0;  /* flag for whether to echo input */
char            binsh[] = "/bin/sh -i";

%}
%%
%{
 /*
  * Shell command (in appropriate context).  Takes rest of line.
  */
%}
<PSHCMD>[^\n]*      {
                       if (yyleng > 1) {
                                yylval = calloc(yyleng+1,1);
                                strcpy(yylval, yytext);
			} else
                                yylval = 0;
                        BEGIN 0;        /* return to normal scanning */
                        return(REM);
                     }
"!"   {
                     BEGIN PSHCMD;
                     return('!');
}
%{
 /*
  * newlines, blanks, etc.
  */
%}
"\\\n"                  ;          /* escaped newline */
"\n"        return('\n');
[ \t]                   ;          /* ignore blanks and tabs */

"/*"[^\n]*              {         /* comments */
                           yylval = calloc(yyleng-1, 1);
                           strcpy(yylval, yytext+2);
                           return(COMMENT);
                        }

%{
 /*
  * Filenames (in appropriate context).
  */
%}
<PFILEN>[^ \t\n)]+   { if (yyleng > 0) {
                               yylval = calloc(yyleng+1,1);
                               strcpy(yylval, yytext);
                           } else
                               yylval = 0;
                           BEGIN 0;        /* return to normal scanning */
                           return(FILENAME);
                        }

%{
 /*
  * Reserved words for format command operands (but only in
  * appropriate context)
  */
%}
<FORMAT>user            return(USER);
<FORMAT>tty             return(TTY);
<FORMAT>buf             return(BUF);
<FORMAT>coretab         return(CORETAB);
<FORMAT>text            return(TEXT);
<FORMAT>ioq             return(IOQ);
<FORMAT>dasd            return(DASD);
<FORMAT>proc            return(PROC);
<FORMAT>active          return(ACTIVE);
<FORMAT>uid             return(UID);
<FORMAT>pid             return(PID);
<FORMAT>pgroup          return(PGROUP);
<FORMAT>chan            return(CHAN);
<FORMAT>cu              return(CU);
<FORMAT>unit            return(UNIT);
<FORMAT>inode           return(INODE);
<FORMAT>tube            return(TUBE);
<FORMAT>file            return(FILSTRUC);
<FORMAT>mount           return(MOUNT);
<FORMAT>command         return(COMMAND);
<FORMAT>stack           return(STACK);

%{
 /*
  * Symbol (as long as not picked up by reserved word above)
  */
%}
[A-Za-z_$@][A-Za-z_$@0-9]* {
                           yylval = calloc(yyleng+1,1);
                           strcpy(yylval,yytext);
                           return(SYMBOL);
                        }

%{
 /*
  * Number (when not matched above).  Interprets as both
  * hex and decimal.
  */
%}
[0-9a-fA-F]+          { yylval = tobinary(yytext,16);
                           aptnum = tobinary(yytext,10);
                           return(NUMBER);
                        }

%{
 /*
  * Reserved words for command names
  */
%}
;mem                    return(MEM);
;addr                   return(ADDR);
;format                 return(FORM);
;quit                   return(0);
;print                  return(PRINT);

%{
 /*
  * Any other single character (operators, parens)
  */
%}
.                       return(yytext[0]);
%%
/*
 *  tobinary converts the specified hex or decimal string to a binary
 *  integer.
 */
tobinary(st, b)
char *st;               /* the string to convert */
register int b;         /* the base (10 or 16) */
{
	register int n, c;
	register char *s;
	int t;

	n = 0;
	s = st;
        while (c = *s++) {
		if (c >= '0' && c <= '9') t = c-'0';
		else if (b == 16 && c >= 'a' && c <= 'f') t = c-'a'+10;
		else if (b == 16 && c >= 'A' && c <= 'F') t = c-'A'+10;
		else {
                        /* error(0, "Illegal number"); */
                        /* gobble(); */
                        return(-1);
                }
		n = n*b+t;
        }
	return(n);
}

/*
 *  The following group of functions may be called from the parser
 *  to set the start condition.  This is done to control what strings
 *  are recognized as reserved words vs symbols.
 */

strtsh()                /* start a shell cmd */
{
  BEGIN PSHCMD;
}

endshell()                /* end a shell cmd */
{
  BEGIN 0;
}

strtfn()                /* start a file name */
{
  BEGIN PFILEN;
}

strtform()              /* start format command reserved words */
{
  BEGIN FORMAT;
}

strtnorm()              /* start normal (no reserved symbols) */
{
  BEGIN 0;
}

/*
 *  getinput obtains the next input character.  It is a version of
 *  the default LEX input routine, modified to echo the input if
 *  the echo switch is on.
 */
getinput()
{
        if (yysptr > yysbuf)
                yytchar = U(*--yysptr);
        else {
                yytchar = getc(yyin);
                if (cmdecho)
                        putchar(yytchar);
        }
        if (yytchar == 10)
                yylineno++;
        if (yytchar == EOF)
                return(0);
        return (yytchar);
}

/*
 *  gobble flushes input characters to end-of-line
 */
gobble()
{
        register int c;
        while ((c = input()) != '\n' && c != EOF)
                ;
        unput('\n');
}
