#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#define COLON   ':'
#define SLASH   '/'
#define MAXLINE 512

char    etcpasswd[] = "/etc/passwd";
char    tmppasswd[] = "/etc/deluserXXXXXX";
char    lnpasswd[] = "/etc/deluserXXXXXX";
char    identity[] = "/etc/identity";
char    tmpident[] = "/etc/deluserXXXXXX";
char    lnident[] = "/etc/deluserXXXXXX";
extern  char    *cmdname;

main(argc, argv)
int     argc;
char    **argv;
{
	char    *userid;
	int     uid;
	struct  passwd  *pw;
	struct  passwd  *getpwnam();
	char    buff[MAXLINE];

	setuid(0);
	while (--argc) {
		userid = *++argv;
		if ((pw = getpwnam(userid)) == NULL)
			fprintf(stderr, "%s: userid %s not found\n", cmdname, userid);
		else {
			setpwent();
			sprintf(buff, "rm -r %s", pw->pw_dir);
                        system(buff);
			sprintf(buff, "/usr/spool/mail/%s", userid);
			unlink(buff);
			uid = pw->pw_uid;
			editpasswd(uid);
			editidentity(uid);
			editgroup(userid);
		}
	}
}
/*
 *  editpasswd - remove the user from /etc/passwd
 *  Read each line and compare the uid on the line to the user's uid.
 *  If no match, copy the line to a temp file.
 *  When a match is found, skip that line and then copy
 *  the rest of the file.
 */
editpasswd(uid)
int     uid;
{
	FILE    *fp, *ofp;
	char    line[MAXLINE];
	struct  passwd  *pw, *getpwent();

	chkfile(etcpasswd);
	mktemp(tmppasswd);
	mktemp(lnpasswd);
	fp = fopen(etcpasswd, "r");
	ofp = fopen(tmppasswd, "w");
	setpwent();
	while (fgets(line, sizeof(line), fp) != NULL) {
		pw = getpwent();
		if (pw->pw_uid == uid)
			continue;
		fprintf(ofp, "%s", line);
	}
	endpwent();
	fclose(fp);
	fclose(ofp);
	link(etcpasswd, lnpasswd);
	unlink(etcpasswd);
	link(tmppasswd, etcpasswd);
	unlink(tmppasswd);
	unlink(lnpasswd);
	chmod(etcpasswd, 0664);
}

/*
 *  editidentity - remove the user from /etc/identity
 *  Use the same procedure as for editpasswd
 */
editidentity(uid)
int     uid;
{
	FILE    *fp, *ofp;
	int     u;
	char    line[MAXLINE];
	char    *s;

	chkfile(identity);
	mktemp(tmpident);
	mktemp(lnident);
	fp = fopen(identity, "r");
	ofp = fopen(tmpident, "w");

	fgets(line, MAXLINE, fp);
	fprintf(ofp, "%s", line);
	while (fgets(line, MAXLINE, fp) != NULL) {
		u = 0;
		for (s = line; !isspace(*s); s++)
                        ;
		for (s++; isspace(*s); s++)
			;
                while (*s != SLASH) {
			u = u*10 + (*s - '0');
			s++;
		}
		if (uid == u)
			continue;
		fprintf(ofp, "%s", line);
	}
	fclose(fp);
	fclose(ofp);
	link(identity, lnident);
	unlink(identity);
	link(tmpident, identity);
	unlink(tmpident);
	unlink(lnident);
	chmod(identity, 0664);
}
/*
 *  chkfile - check if a file is currently in use.
 *  If so, sleep and try again.
 *  If not, turn on the execution bits to flag it as in use.
 */
chkfile(file)
char    *file;
{
	int     i;
	extern  int     errno;
	struct  stat    statb;

	for (i = 0; i < 5; i++) {
		stat(file, &statb);
		if ((statb.st_mode & 1) == 0) {
			chmod(file, 0777);
                        return;
                }
                sleep(2);
	}
	fprintf(stderr, "%s: %s is busy\n", cmdname, file);
	exit(1);
}
/*
 *  editgroup - remove a user from all groups
 */
editgroup(userid)
char    *userid;
{
	char    cmd[100];

	sprintf(cmd, "group purge %s", userid);
	system(cmd);
}
