/*
 * Add the contents of a directory to a tar tape.
 * File names beginning with `.' are ignored.
 *
 * If the tape is virgin (although all are sleazy)
 * then start it fresh.
 * If a tape fills, start a new one.
 *
 * cut
 *
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>

FILE *fptfn;
FILE *fpheb;

struct stat statstuf;
struct direct files[4096];

char hebrew[] = "/usr/spool/arch/.hebrew";
char tapes[] = "/usr/spool/arch/.tapes";
char tempcut[] = "/usr/spool/arch/.tempcut";
char filename[20];
char volser[10];
char *tfn;

int tapestate;

main(argc, argv)
int argc;
char *argv[];
{
	struct direct *d;
	FILE *fp;
	char *rindex();

	/*
	 * This is to get around the stdio library al la mal
	 */
	chdir("/usr/spool/arch");
	if((fpheb = fopen(hebrew, "a")) == NULL) {
		fprintf(stderr, "Cut: Cannot open hebrew file\n");
		exit(1);
	}
	if(argc != 1) {
		fprintf(stderr, "Cut: No args to this command\n");
		exit(1);
	}
	tfn = tapes;
        if((fp=fopen(".", "r")) == NULL) {
                fprintf(stderr, "Cut: Cannot open .\n");
                exit(2);
        }
        for(d=files; fread((char *)d, 1, sizeof(struct direct), fp)==sizeof(struct direct); d++)
                ;
        fclose(fp);
        if(d == files) {
                fprintf(stderr, "Cut: No files in %s\n", tfn);
                exit(3);
        }
        for(;d >= files; d--) {
                if(d->d_ino == 0)
                        continue;
                if(d->d_name[0] == '.')
                        continue;
                strncpy(filename, d->d_name, 14);
                stat(filename, &statstuf);
                if((statstuf.st_mode & S_IFDIR) == 0)
                        feather(filename);
	}
	down();
	exit(0);
}

/*
 * free up tape
 */
down()
{
	char cd[256];

        if(tapestate) {
                sprintf(cd, "/bin/tape -u %s", volser);
                system(cd);
        }
        return;
}

/*
 * Use tar to put this file on a tape.
 */
feather(name)
char *name;
{
	char cmd[256];
	char mes[256];
	int  back;
	int  from;

        if(!tapestate) {
                if((fptfn=fopen(tfn, "r")) == NULL) {
                        fprintf(stderr, "Cut: Cannot open tape name file\n");
                        exit(4);
                }
		if(newtape(volser)) {
                        fprintf(stderr, "Cut: No usable tape found in %s\n", tfn);
                        exit(5);
                }
		tapestate = 1;
        }
        /*
         * invoke tar.
         */
	back = 0;
        do {
                sprintf(cmd, "/bin/tar r %s %s", volser, name);
                if((from = (system(cmd) >> 8)) == 0)
                        break;
		sprintf(mes, "/etc/cut: %s exit code %d", cmd, from);
		notify("root", mes, 0);
        } while((back=newtape(volser)) == 0);
	if(back) {
                fprintf(stderr, "Cut: No usable tape found in %s\n", tfn);
                exit(5);
        }
	fprintf(fpheb, "%s %s\n", name, volser);
	unlink(name);
	return;
}


/*
 * get top tape mounted.
 */
newtape()
{
	FILE *popen();
        FILE *fped;
	char *rindex();
	char mand[256];
	char *nl;
	int  fdtar;

	if(tapestate) {
		down();
		fseek(fptfn, 0, 0);
		fped = fopen(tempcut, "w");
		if(fped == NULL) {
			fprintf(stderr, "cut: cannot open temp file %s\n", tempcut);
			return(-1);
		}
		/*
		 * Remove the first line from the file.
		 */
                if(fgets(volser, 8, fptfn) == NULL) {
			notify("backup", "cut: archiver is out of tapes", 0);
                        return(-1);
		}
		/*
		 * If the next line is empty, then out of tapes as well.
		 */
                if(fgets(volser, 8, fptfn) == NULL)
			notify("backup", "cut: archiver is out of tapes", 0);
		else {
			do
				fprintf(fped, "%s", volser);
			while(fgets(volser, 8, fptfn) != NULL);
		}
		fclose(fped);
		fclose(fptfn);
		unlink(tfn);
		link(tempcut, tfn);
		unlink(tempcut);
		fptfn = fopen(tfn, "r");
		if(fptfn == NULL) {
			fprintf(stderr, "cut: cannot reopen tape file\n");
			return(-1);
		}
	}
        if(fgets(volser, 8, fptfn) == NULL)
                return(-1);
        if((nl=rindex(volser, '\n')) != NULL)
                *nl = 0;
        sprintf(mand, "/bin/tape -m -w -s -d 6250 %s", volser);
        system(mand);
        sprintf(mand, "/dev/tape/%s", volser);
        while((fdtar=open(mand, 0)) < 0) {
                sleep(5);
	}
	close(fdtar);
	return(0);
}
