#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>

#define DIRMODE       (S_IFDIR | (S_IREAD | S_IWRITE | S_IEXEC) | \
                                ((S_IREAD | S_IWRITE | S_IEXEC) >> 3) | \
                                ((S_IREAD | S_IEXEC) >> 6))
#define EOS             '\0'
#define USERIDLEN       8
#define DEPTLEN         4
#define PASSWDLEN       8
#define VPASSWDLEN      8
#define VMIDLEN         8
#define TSOIDLEN        8
#define OFFICELEN       7
#define PHONELEN        4
#define MSLEN           3
#define BINNOLEN        3
#define GROUPLEN        8
#define UIDNOLEN        4
#define HOMELEN         25
#define SHELLLEN        25
#define NAMELEN         25
#define MAXLINE         512

char    userid[USERIDLEN + 1];
char    passwd[PASSWDLEN + 1];
char    vpasswd[VPASSWDLEN + 1];
char    group[GROUPLEN + 1];
char    uidno[UIDNOLEN + 1];
char    dept[DEPTLEN + 1];
char    vmid[VMIDLEN + 1];
char    tsoid[TSOIDLEN + 1];
char    binno[BINNOLEN + 1];
char    homedir[HOMELEN + 1];
char    shell[SHELLLEN + 1];
char    office[OFFICELEN + 1];
char    phone[PHONELEN + 1];
char    mailstop[MSLEN + 1];
char    username[NAMELEN + 1];
/*
 *  Various file names (These should eventually start with /etc)
 */
char    etcpasswd[] = "/etc/passwd";
char    tmppasswd[] = "/etc/adduserXXXXXX";
char    lnpasswd[] = "/etc/adduserXXXXXX";
char    identity[] = "/etc/identity";
char    tmpident[] = "/etc/adduserXXXXXX";
char    lnident[] = "/etc/adduserXXXXXX";

char    tripledot[] = "...";
char    usrmail[] = "/usr/spool/mail";
char    news[] = "news";
/*
 *  Error messages
 */
char    *msg = "";
char    nouserid[] = "No userid";
char    dupuser[] = "Userid already exists";
char    nogroup[] = "No group";
char    badgroup[] = "Group does not exist";
char    nopasswd[] = "No password";
char    novpasswd[] = "No validate password";
char    conflpasswd[] = "Conflicting passwords";
char    deptwrong[] = "Department not right length";
char    nohomedir[] = "No home directory";
char    badhomedir[] = "Bad home directory";
char    notdirectory[] = "Not a directory";
char    noname[] = "No user name";
char    baduid[] = "Uid already exists";

char    mkdir[] = "mkdir ";
char    other[] = "other";
char    *crypted;
extern  char    *cmdname;
int     uid;
int     gid;
int     cursor_pos;

main(argc, argv)
int argc;
char **argv;
{
	setuid(0);
	while (1) {
                cursor_pos = 407;
                do {
                        readit();
                } while (verify());
                update();
		reinit();
	}
}
/*
 *  readit - read the screen
 *  Get all the input fields and assign them to variables
 *  via quickscreen.
 */
readit()
{
        at 101;
	panel(erase, cursor = cursor_pos) {
#@101#
        Add a Userid to the System

Name: #IN, username, NAMELEN#
Dept: #IN, dept, DEPTLEN#         Office: #IN, office, OFFICELEN#
Phone: #IN, phone, PHONELEN#        Mailstop: #IN, mailstop, MSLEN#

Userid: #IN, userid, USERIDLEN#
Password: #II, passwd, PASSWDLEN# Validate: #II, vpasswd, VPASSWDLEN#

Vmid: #IN, vmid, VMIDLEN#     Tsoid: #IN, tsoid, TSOIDLEN#
Binno: #IN, binno, BINNOLEN#

Group: #IN, group, GROUPLEN#    (Default: "other")
Homedir: #IN, homedir, HOMELEN#

Uidno: #IN, uidno, UIDNOLEN#        (Default: next available)
Shell: #IN, shell, SHELLLEN#

        #OH, msg, strlen(msg)#

        ENTER:  add the user
        TESTREQ:  quit
	}
	if (qskp == TESTREQ)
		exit(0);
}
/*
 *  verfiy - verify all the input fields.
 *  If a field is bad, set an error message and the
 *  cursor position and return true.
 */
verify()
{
	struct passwd *pw, *getpwnam();
	struct group  *grp, *getgrnam();
	struct  stat    statb;

	msg = "";

	if (username[0] == EOS) {
		msg = noname;
                cursor_pos = qspos(username);
		return(1);
	}

	if (strlen(dept) != DEPTLEN) {
		msg = deptwrong;
                cursor_pos = qspos(dept);
		return(1);
	}

	if (userid[0] == EOS) {
		msg = nouserid;
                cursor_pos = qspos(userid);
		return(1);
	} else if (getpwnam(userid) != NULL) {
		msg = dupuser;
                cursor_pos = qspos(userid);
		return(1);
	}

	if (passwd[0] == EOS) {
                msg = nopasswd;
                cursor_pos = qspos(passwd);
		return(1);
	} else if (vpasswd[0] == EOS) {
                msg = novpasswd;
                cursor_pos = qspos(vpasswd);
		return(1);
	} else if (strcmp(passwd, vpasswd) != 0) {
		msg = conflpasswd;
                cursor_pos = qspos(passwd);
		return(1);
	}

	if (group[0] == EOS)
		strcpy(group, other);
	if ((grp = getgrnam(group)) == NULL) {
		msg = badgroup;
                cursor_pos = qspos(group);
		return(1);
	} else
		gid = grp->gr_gid;

	if (uidno[0] != EOS) {
		uid = atoi(uidno);
	        if (getpwuid(uid) != NULL) {
                        msg = baduid;
                        cursor_pos = qspos(uidno);
                        return(1);
		}
	} else
		uid = -1;

	if (homedir[0] == EOS) {
		msg = nohomedir;
                cursor_pos = qspos(homedir);
		return(1);
	} else if (stat(homedir, &statb) == -1) {
		msg = badhomedir;
                cursor_pos = qspos(homedir);
		return(1);
	} else if ((statb.st_mode & S_IFDIR) == 0) {
		msg = notdirectory;
                cursor_pos = qspos(homedir);
		return(1);
	}

        return(0);
}
/*
 *  update - update /etc/passwd, /etc/identity, and
 *  create the home directory, the triple dot directory,
 *  a news file and a /usr/spool news file.
 */
update()
{
	finduid();
	cryptpasswd();
	editpasswd();
        editidentity();
	addgroup();
	makefiles();
}
/*
 *  finduid - set the uid for this user.
 *  If a uid was specified use it, otherwise
 *  find the largest userid in /etc/passwd and
 *  use a value one larger.
 */
finduid()
{
	struct passwd   *pw, *getpwent();

	if (uid != -1)
		return;

	while ((pw = getpwent()) != NULL)
		if (pw->pw_uid >= uid)
                        uid = pw->pw_uid + 1;
}
/*
 *  editpasswd - add the new entry to /etc/passwd.
 *  Assume the entries are in order according to uid,
 *  and insert the new one in the right place.
 *  Do a song and dance with links to ensure the file
 *  is never completely lost.
 */
editpasswd()
{
	FILE    *fp, *ofp;
	char    line[MAXLINE];
	struct  passwd  *pw, *getpwent();

	chkfile(etcpasswd);
	mktemp(tmppasswd);
	mktemp(lnpasswd);
	fp = fopen(etcpasswd, "r");
	ofp = fopen(tmppasswd, "w");
	setpwent();
	while (1) {
		fgets(line, sizeof(line), fp);
		pw = getpwent();
		if (pw == NULL || pw->pw_uid > uid) {
                        fprintf(ofp, "%s:%s:%d:%d:%s,%s,%s,%s:%s/%s:%s\n",
                                userid, crypted, uid, gid, dept, vmid,
			        tsoid, binno, homedir, userid, shell);
			break;
		}
		fprintf(ofp, "%s", line);
	}
	if (pw != NULL) {
		fprintf(ofp, "%s", line);
		while (fgets(line, sizeof(line), fp) != NULL)
                        fprintf(ofp, "%s", line);
	}
	fclose(fp);
	fclose(ofp);
	link(etcpasswd, lnpasswd);
	unlink(etcpasswd);
	link(tmppasswd, etcpasswd);
	unlink(tmppasswd);
	unlink(lnpasswd);
	chmod(passwd, 0664);
}
/*
 *  editidentity - add the new user to /etc/identity
 */
editidentity()
{
	FILE    *fp, *ofp;
	int     luid;
	char    *r, line[MAXLINE];
	chkfile(identity);
	mktemp(tmpident);
	mktemp(lnident);
	fp = fopen(identity, "r");
	ofp = fopen(tmpident, "w");
	while (1) {
		luid = 0;
		if ((r = fgets(line, sizeof(line), fp)) != NULL) {
			sscanf(line, "%*s %d", &luid);
			if (luid < uid) {
				fprintf(ofp, "%s", line);
				continue;
			}
		}
		break;
	}
        fprintf(ofp, "%-10s%4d/%-2d      %-4s    %-7s   %-4s  %-3s   %s\n",
                userid, uid, gid, dept, office, phone, mailstop,
		username);
	if (r != NULL) {
		fprintf(ofp, "%s", line);
		while (fgets(line, sizeof(line), fp) != NULL)
                        fprintf(ofp, "%s", line);
	}
	fclose(fp);
	fclose(ofp);
	link(identity, lnident);
	unlink(identity);
	link(tmpident, identity);
	unlink(tmpident);
	unlink(lnident);
	chmod(identity, 0664);
}
/*
 *  addgroup - add the new user to /etc/group
 *  If his group is "other" don't bother.
 */
addgroup()
{
	char    grpcmd[40];

	if (strcmp(group, other) == 0)
		return;
	sprintf(grpcmd, "group add %s %s", group, userid);
	system(grpcmd);
}
/*
 *  makefiles - create all the necessary files
 *  They are the home directory, the triple dot directory,
 *  the user's news, and the /usr/spool's mail files.
 */
makefiles()
{
	FILE    *fp;
	char    mkdircmd[20];

	chdir(homedir);
        strcpy(mkdircmd, mkdir);
	strcat(mkdircmd, userid);
	system(mkdircmd);
	chown(userid, uid, gid);

	chdir(userid);
        strcpy(mkdircmd, mkdir);
	strcat(mkdircmd, tripledot);
	system(mkdircmd);
	chown(tripledot, uid, gid);

	chdir(tripledot);
	fp = fopen(news, "w");
	fclose(fp);
	chown(news, uid, gid);

	chdir(usrmail);
	fp = fopen(userid, "w");
	fclose(fp);
	chown(userid, uid, gid);
}
/*
 *  cryptpasswd - encrypt the passwd
 *  This code stolen from the passwd command.
 */
cryptpasswd()
{
	char    saltc[2];
	int     salt, c, i;

	salt = time();
	salt += getpid();

	saltc[0] = salt & 077;
	saltc[1] = (salt >> 6) & 077;
	for (i = 0; i < 2; i++) {
		c = saltc[i] + '.';
		if (c>'9')
			c += 7;
		if (c>'Z')
			c += 6;
		saltc[i] = c;
	}
	crypted = crypt(passwd, saltc);
}
/*
 *  reinit - reinitialize the variables quickscreen uses.
 */
reinit()
{
        userid[0] = EOS;
        passwd[0] = EOS;
        vpasswd[0] = EOS;
        group[0] = EOS;
        uidno[0] = EOS;
        dept[0] = EOS;
        vmid[0] = EOS;
        tsoid[0] = EOS;
        binno[0] = EOS;
        homedir[0] = EOS;
        shell[0] = EOS;
        office[0] = EOS;
        phone[0] = EOS;
        mailstop[0] = EOS;
        username[0] = EOS;
}
/*
 *  chkfile - check if a file is currently in use.
 *  If so, sleep and try again.
 *  If not, turn on the execution bits to flag it as in use.
 */
chkfile(file)
char    *file;
{
	int     i;
	extern  int     errno;
	struct  stat    statb;

	for (i = 0; i < 5; i++) {
		stat(file, &statb);
		if ((statb.st_mode & 1) == 0) {
			chmod(file, 0777);
                        return;
                }
                sleep(2);
	}
	fprintf(stderr, "%s: %s is busy\n", cmdname, file);
	exit(1);
}
