/*
* whois: gives the names of users ... in the absence of any arguments,
*        the names of all logged on users is given.
*/
#include <stdio.h>
#include <ctype.h>
#include <utmp.h>

#define  doforever for(;;)

char utmp[]  = "/etc/utmp";
char ident[] = "/etc/identity";
int  count  = 0;                 /* number of users found           */
int  noargs = 1;                 /* tells if whois had no arguments */
char flag;                       /* set when a match is made        */
char buf[BUFSIZ];

main(argc, argv) char **argv;
{
        FILE *fi, *fid;
	struct utmp p;
        char uname[100];

        setbuf(stdout, buf);
        if (argc > 1) noargs = 0;

        fid = fopen(ident, "r");
        if(fid == NULL) {
                fprintf(stderr, "Cannot open identity file.\n");
                exit(1);
        }

        if (noargs) {
                fi = fopen(utmp, "r");
                if(fi == NULL) {
                        fprintf(stderr, "Cannot open utmp file.\n");
                        exit(1);
                }
        }
        doforever {
                if (noargs) {
                        if (fread((char *)&p, sizeof p, 1, fi) != 1)  {
			        printf("%d Users\n",count);
                                done(0);
			}
                        p.ut_name[7] = NULL;
                        strcpy(uname, p.ut_name);
                } else {
                        if (--argc > 0)
                                strcpy(uname, *(++argv)); else
			        done(0);
                }
                if (uname[0] && uname[0] != ' ')
                        scanput(fid, uname);
        }
}


/*
* scanput: Scans each line in the given ioptr file for the given string.
*          If a match is found, flag is bumped.  Also the first line of
*          the file is output when the first match is made.
*/
scanput(ioptr, s) FILE *ioptr; char *s;
{
        char line[200], head[200];
	int  found;

        rewind(ioptr);
        fgets(head, 200, ioptr);
        while(fgets(line, 200, ioptr) != NULL) {
		found = noargs? match(line, s) : grep(line, s);
                if (found) {
                        if (!flag)
                                printf("%s", head);
                        printf("%s", line);
			count++;
                        flag++;
			if (noargs) return;
                }
        }
}

/*
* grep: Scans line for the string s.  The match is made regardless
*       of case.
*/
grep(line, s) char *line, *s;
{
        register char *s1, *s2, *l, *endl;
        char lowl[200], lows[100];

        cpylow(lowl, line);
        cpylow(lows, s);

        endl = lowl+strlen(lowl)-strlen(lows);
        for (l = lowl; l <= endl; l++) {
                s1 = lows;
                s2 = l;
                while (*s1 != NULL && *s1 != ' ')
                        if (*s1++ != *s2++) goto shift;
                return(1);
shift:  ;
        }
        return(0);
}

/*
* match: Compares the first token of line with the string s.  No case
*        conversion is performed.
*/
match(line, s) register char *line, *s;
{
        while(*line == *s) {
		s++;
		line++;
                if((*s == '\0' || *s == ' ') && *line == ' ')
                        return(1);
	}
        return(0);
}

cpylow(s1, s2) register char *s1, *s2;
{
        while (*s2) {
                *s1 = isupper(*s2) ? tolower(*s2) : *s2;
                s1++;
                s2++;
        }
        *s1 = NULL;
}

done(rc)
{
        if (!flag) printf("Nobody.\n");
        exit(rc);
}
