#include "tp.h"
#include <stdio.h>

main(argc,argv)
char **argv;
{
	register char c,*ptr;
	int     fflag;
	extern cmr(),cmx(), cmt();

	command = cmr;
	if ((narg = rnarg = argc) < 3)
		useerr();

        ptr = argv[1];  /* get first argument */
        targ = &argv[2]; /* pointer to the second argument */
        parg = &argv[3];        /* pointer to third argument */
        while (c = *ptr++)
		switch(c)  {

                case 'f':
                        tname = *targ;
			fflag++;
                        narg--; rnarg--;
                        continue;
                case 'c':
                        flags |= flc;  continue;
                case 'i':
                        flags |= fli;  continue;
                case 'r':
                        flags &= ~flu;  setcom(cmr);  continue;
                case 's':
                        flags |= fls; continue;
                case 't':
                        setcom(cmt);  continue;
                case 'v':
                        flags |= flv;  continue;
                case 'w':
                        flags |= flw;  continue;
                case 'x':
                        setcom(cmx);  continue;
                default:
                        useerr();
        }
	if(!fflag) {
		if(*argv[2] == '/')
			sprintf(magtape, "%s", *targ);
		else
                        sprintf(magtape, namtape, *targ);
		tname = magtape;
	}
	optap();
	top = nptr = nameblk = sbrk(0);
	(*command)();
}

optap()
{
	extern cmr();

        tapsiz = MTSIZ;
        ndirent = MDIRENT;
        if(command == cmr)
                fio = open(tname,2);
        else
                fio = open(tname,0);
	if (fio < 0)  {
		printf("Tape open error\n");
		done();
	}
	ndentb = ndirent/TPB;
	edir = &dir[ndirent];
}

setcom(newcom)
int (*newcom)();
{
	extern cmr();

	if (command != cmr)  	useerr();
	command = newcom;
}

useerr()
{
	printf("Usage: tp rxtvcifw tape_name [ name ... ]\n");
	done();
}

/*/* COMMANDS */

cmr()
{
	if (flags & (flc|flm))
                clrdir();
        else
                rddir();
	getfiles();
	update();
	check();
}

cmt()
{
	extern taboc();
	if (flags & (flc|flw))	useerr();
	rddir();
	if (flags & flv)
		printf("   mode    uid gid tapa    size   date    time name\n");
	gettape(taboc);
	check();
}

cmx()
{
	extern extract();

	if (flags & (flc))		useerr();
	rddir();
	gettape(extract);
	done();
}

check()
{
	usage();
	done();
}

done()
{
	printf("End\n");
	exit(0);
}

encode(pname,dptr)	/* pname points to the pathname
			 * nptr points to next location in nameblk
			 * dptr points to the dir entry		   */
char	*pname;
struct	dent *dptr;
{
	register  char *np;
	register n;

	dptr->d_namep = np = nptr;
	if (np > top - NAMELEN)  {
		if(sbrk(BRKINCR) == (char *)-1) {
			printf("Out of core\n");
			done();
		} else
			top += BRKINCR;
	}
	if((n=strlen(pname)) > NAMELEN) {
		printf("Pathname too long - %s\nFile ignored\n",pname);
		clrent(dptr);
	}
	else {
		nptr += n+1;
		strcpy(np, pname);
	}
}

decode(pname,dptr)	/* dptr points to the dir entry
			 * name is placed in pname[] */
char	*pname;
struct	dent *dptr;
{
	strcpy(pname, dptr->d_namep);
}
