/*
 *	test expression
 *	[ expression ]
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#define EQ(a,b)	((tmp=a)==0?0:(strcmp(tmp,b)==0))

#define DIR 1
#define FIL 2
int	ap;
int	ac;
char	**av;
char	*tmp;

main(argc, argv)
char *argv[];
{

	ac = argc; av = argv; ap = 1;
	if(EQ(argv[0],"[")) {
		if(!EQ(argv[--ac],"]"))
			synbad("] missing","");
	}
	argv[ac] = 0;
	if (ac<=1) exit(1);
	exit(exp()?0:1);
}

char *nxtarg(mt) {

	if (ap>=ac) {
		if(mt) {
			ap++;
			return(0);
		}
		synbad("argument expected","");
	}
	return(av[ap++]);
}

exp() {
	int p1;

	p1 = e1();
	if (EQ(nxtarg(1), "-o")) return(p1 | exp());
	ap--;
	return(p1);
}

e1() {
	int p1;

	p1 = e2();
	if (EQ(nxtarg(1), "-a")) return (p1 & e1());
	ap--;
	return(p1);
}

e2() {
	if (EQ(nxtarg(0), "!"))
		return(!e3());
	ap--;
	return(e3());
}

e3() {
	int p1;
	register char *a;
	char *p2;
	int int1, int2;

	a=nxtarg(0);
	if(EQ(a, "(")) {
		p1 = exp();
		if(!EQ(nxtarg(0), ")")) synbad(") expected","");
		return(p1);
	}

	if(EQ(a, "-r"))
		return(tio(nxtarg(0), 0));

	if(EQ(a, "-w"))
		return(tio(nxtarg(0), 1));

	if(EQ(a, "-x"))
		return(!access(nxtarg(0), 1));

	if(EQ(a, "-d"))
		return(ftype(nxtarg(0))==DIR);

	if(EQ(a, "-f"))
		return(ftype(nxtarg(0))==FIL);

	if(EQ(a, "-s"))
		return(fsizep(nxtarg(0)));

	if(EQ(a, "-t"))
		if(ap>=ac)
			return(isatty(1));
		else
			return(isatty(atoi(nxtarg(0))));

	if(EQ(a, "-n"))
		return(!EQ(nxtarg(0), ""));
	if(EQ(a, "-z"))
		return(EQ(nxtarg(0), ""));

	p2 = nxtarg(1);
	if (p2==0)
		return(!EQ(a,""));
	if(EQ(p2, "="))
		return(EQ(nxtarg(0), a));

	if(EQ(p2, "!="))
		return(!EQ(nxtarg(0), a));

	if(EQ(p2, ":"))
		return(outofdate(a, nxtarg(0)));

	if(EQ(p2, "~")) {
		makepat(nxtarg(0));
		return(match(a));
	}

	if(EQ(p2, "!~")) {
		makepat(nxtarg(0));
		return(!match(a));
	}

	if(EQ(a, "-l")) {
		int1=length(p2);
		p2=nxtarg(0);
	} else{	int1=atoi(a);
	}
	int2 = atoi(nxtarg(0));
	if(EQ(p2, "-eq"))
		return(int1==int2);
	if(EQ(p2, "-ne"))
		return(int1!=int2);
	if(EQ(p2, "-gt"))
		return(int1>int2);
	if(EQ(p2, "-lt"))
		return(int1<int2);
	if(EQ(p2, "-ge"))
		return(int1>=int2);
	if(EQ(p2, "-le"))
		return(int1<=int2);

	synbad("unknown operator ",p2);
}

tio(a, f)
char *a;
int f;
{

	f = open(a, f);
	if (f>=0) {
		close(f);
		return(1);
	}
	return(0);
}

ftype(f)
char *f;
{
	struct stat statb;

	if(stat(f,&statb)<0)
		return(0);
	if((statb.st_mode&S_IFMT)==S_IFDIR)
		return(DIR);
	return(FIL);
}

fsizep(f)
char *f;
{
	struct stat statb;
	if(stat(f,&statb)<0)
		return(0);
	return(statb.st_size>0);
}

synbad(s1,s2)
char *s1, *s2;
{
	write(2, "test: ", 6);
	write(2, s1, strlen(s1));
	write(2, s2, strlen(s2));
	write(2, "\n", 1);
	exit(255);
}

length(s)
	char *s;
{
	char *es=s;
	while(*es++);
	return(es-s-1);
}

outofdate(f1, f2)
char *f1, *f2;
{
	struct stat statb;
	time_t t;

	if(stat(f1, &statb))
		return(1);
	t = statb.st_mtime;
	if(stat(f2, &statb))
		return(1);
	if(t < statb.st_mtime)
		return(1);
	return(0);
}

#include <ctype.h>

#define CHAR 1
#define ANY  2
#define CCL  3
#define NCCL 4
#define STAR 5

char pat[200];
int pi, afterstar;
char escape();

makepat(s)
char s[];
{
	int i, pj;
	char c;

	i = 0;
	pi = 0;
	while (c = s[i++])
		if (c == '?')
			pat[pi++] = ANY;
		else if (c == '*')
			pat[pi++] = STAR;
		else if (c == '[') {
			if (s[i] == '^') {
				pat[pi++] = NCCL;
				++i;
			} else
				pat[pi++] = CCL;
			pj = pi++;
			makeccl(s,&i);
			pat[pj] = pi-pj-1;
		} else if (c != '\\') {
			pat[pi++] = CHAR;
			pat[pi++] = c;
		} else {
			pat[pi++] = CHAR;
			pat[pi++] = escape(s[i++]);
		}
	pat[pi++] = 0;
}

makeccl(s,ai)
char s[];
int *ai;
{
	int i, opi;
	char a, b, c;

	opi = pi;
	i = *ai;
	while ((c = s[i++]) != ']' && c)
		if (c == '\\')
			pat[pi++] = escape(s[i++]);
		else if (c != '-')
			pat[pi++] = c;
		else if (pi == opi)                     /* [-abc] */
			pat[pi++] = '-';
                else if ((c = s[i++]) == ']' || !c) {    /* [a-] or [a- */
			pat[pi++] = '-';
			if (!c)
				--i;
			break;
		} else {
			b = pat[pi-1];
			if (b <= c &&
			    ((isdigit(b) && isdigit(c)) ||     /* [0-9] */
			     (islower(b) && islower(c)) ||     /* [a-m] */
			     (isupper(b) && isupper(c))        /* [D-S] */
			    )
			   )
				for (a = b+1; a <= c; ++a)
					pat[pi++] = a;
			else {                        /* [a-9] or [d-a] */
				pat[pi++] = '-';
				pat[pi++] = c;
			}
		}
	*ai = i;
}

char
escape(c)
char c;
{
        return((c == '\0')? '\\':
               (c == 'n' )? '\n':
               (c == 't' )? '\t':
                               c
              );
}

int
match(name)
char name[];
{
	int ni;

	ni = 0;
	pi = 0;
	afterstar = 0;
	if (eatstars())
		return(1);
	while (name[ni] && (pat[pi] || afterstar))
		if (smatch(name[ni])) {
                        pi += patsize();
		        if (eatstars())
			        return(1);
                        ++ni;
                } else if (afterstar) {
                        if (pi == afterstar)
			        ++ni;
			else
				pi = afterstar;
                }  else
                        return(0);
	return(!name[ni] && !pat[pi]);
}

int
eatstars()
{
        if (pat[pi] == STAR) {
                do {
                        ++pi;
                } while (pat[pi] == STAR);
                if (!pat[pi])
                        return(1);
		afterstar = pi;
	}
	return(0);
}

/*
 * does c match pat[pi]?
 */

int
smatch(c)
char c;
{
	if (!pat[pi] || !c)
		return(0);
	else
	        switch(pat[pi]) {
		case CHAR:
			return(c == pat[pi+1]);
		case ANY:
			return(1);
		case CCL:
			return(indexn(pat+pi+2,c,pat[pi+1]) >= 0);
		case NCCL:
			return(indexn(pat+pi+2,c,pat[pi+1]) <  0);
		default:
			printf("smatch: cannot happen :%c:\n",pat[pi]);
			exit(1);
		}
}

/*
 * if c occurs within the first n chars of s
 * return where else -1.
 */

int
indexn(s,c,n)
char s[];
char c;
int n;
{
	int i;

	for (i = 0; i < n; ++i)
		if (c == s[i])
			return(i);
	return(-1);
}

/*
 * return size of pattern at pat[pi]
 */

int
patsize()
{
	switch(pat[pi]) {
	case CHAR:
		return(2);
	case ANY:
		return(1);
	case CCL:
	case NCCL:
		return(pat[pi+1]+2);
	case STAR:
		return(1);
	default:
		printf("patsize: cannot happen :%c:\n",pat[pi]);
		exit(1);
	}
}
