#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stats.h>
#include <sys/stat.h>
#include <sys/timeb.h>

int aflg = 1;
int iflg, tflg, bflg, cflg, fflg;
int interval = -1;
int count = 1;
int fd;
char *filename = "/dev/kmem/stats";
struct stat st;

main(argc, argv)
int argc;
char **argv;
{
	char *cp;
	struct stats new, old;
	struct timeb t;
	double oldt, newt;

	if (argc > 1) {
		for (cp = argv[1]; *cp; cp++)
		        switch(*cp) {
                        case 'i':
                                iflg++;
                                break;
                        case 't':
                                tflg++;
                                break;
                        case 'b':
                                bflg++;
                                break;
                        case 'a':
                                aflg++;
                                break;
                        case 'c':
                                cflg++;
                                break;
                        case 'f':
                                fflg++;
                                filename = (++argv)[1];
                                argc--;
                                break;
                        default:
                                fprintf(stderr, "Usage: stats itbac[f file] [ interval [ count ] ]\n");
                                exit(1);
                        }
	}
	if(iflg||tflg||bflg) aflg--;
	if(argc > 2)
		interval = atoi(argv[2]);
	if(argc > 3)
		count = atoi(argv[3]);
	if((fd = open(filename, 0)) < 0) {
		fprintf(stdout, "Can't open %s\n", filename);
		exit(1);
	}
	if(interval <= 0) {
		getstats(&stats);
		if (fflg) {
			if (stat(filename, &st))
				fprintf(stdout, "Bad stat of %s\n", filename);
			prstats((double) (st.st_mtime - stats.s_uptime));
		} else
		        prstats((double)(time() - stats.s_uptime));
		exit(0);
	}
	getstats(&new);
	ftime(&t);
	newt = (double)t.time + (double)t.millitm/1000.;
	while(count--) {
		old = new;
		oldt = newt;
		sleep(interval);
		getstats(&new);
                ftime(&t);
                newt = (double)t.time + (double)t.millitm/1000.;
		diff(&new, &old, &stats);
		if(cflg) putchar('\f');
		prstats(newt - oldt);
		fflush(stdout);
	}
}

getstats(st)
struct stats *st;
{
	static flag = 1;
	char c;
	int n1, n2;

	seek(fd, 0, 0);
	n1 = read(fd, (char *)st, sizeof *st);
	if (n1 != sizeof *st || (n2 = read(fd, &c, 1)) > 0) {
		if(flag) {
			flag = 0;
                        fprintf(stderr, "Stats out of phase: recompile this program. %d %d %d\n", n1, n2, sizeof *st);
		}
	}
}

prstats(etime)
double etime;
{
	char *ctime();

	signal(SIGFIXD, SIG_IGN);
	signal(SIGFLTD, SIG_IGN);
	if(aflg) {
                printf("Up since %s", ctime(stats.s_uptime));
                printf("Crash at %s", ctime(stats.s_downtime));
                putchar('\n');
	}
	if(iflg || aflg) {
                interrupts();
                putchar('\n');
	}
	if(tflg || aflg) {
                cputime(etime);
                putchar('\n');
	}
	if(bflg || aflg) {
                bio();
		putchar('\n');
	}
}

interrupts()
{
	printf("Supervisor Calls:    %8d\n", stats.s_svcs);
	printf("Program interrupts:  %8d\n", stats.s_pgms);
	printf("External interrupts: %8d\n", stats.s_exts);
	printf("I/O interrupts:      %8d\n", stats.s_iois);
	printf("Psuedo page faults:  %8d\n", stats.s_ppfs);
	printf("Calls to swtch:      %8d\n", stats.s_swtchs);
}

cputime(etime)
double etime;
{
	double flttime(), cput, vtime;

	printf("Times (in seconds)\n");
	printf("User:    %10.03f\n", flttime(stats.s_utime));
	printf("System:  %10.03f\n", flttime(stats.s_stime));
	printf("I/O:     %10.03f\n", flttime(stats.s_iotime));
	printf("Ext:     %10.03f\n", flttime(stats.s_exttime));
	printf("Swtch:   %10.03f\n", flttime(stats.s_swtime));
	printf("Wait:    %10.03f\n", flttime(stats.s_wtime));
	printf("Total:   %10.03f\n", flttime(stats.s_ttime));
	printf("Elapsed: %10.03f\n", etime);
	cput = flttime(stats.s_ttime) - flttime(stats.s_wtime);
	vtime = flttime(stats.s_ttime);
	printf("Real CPU Usage = %d%%, ", (int)(100*cput/etime));
	printf("Virtual CPU Usage = %d%%, ", (int)(100*cput/vtime));
	printf("Involuntary Wait = %d%%\n", (int)(100*(etime-vtime)/etime));
}

double flttime(t)
cpu_t t;
{
	double x;

	t >>= 12;
	x = (double)t / 1000000.;
	return(x);
}

bio()
{
	printf("Buffer Cache:\n");
	printf("\tReads: %d\n", stats.s_bio.b_nread);
	printf("\tRead aheads: %d\n", stats.s_bio.b_nreada);
	printf("\tWrites: %d\n", stats.s_bio.b_nwrite);
	printf("\tDelayed writes: %d\n", stats.s_bio.b_ndwrite);
	printf("\tRead hit ratio: %d%%\n", 100*stats.s_bio.b_ncache/
		      (stats.s_bio.b_ncache + stats.s_bio.b_nread));
	printf("\tDelayed write ratio: %.2f\n", (double)stats.s_bio.b_ndwrite/
			stats.s_bio.b_nwrite);
}

diff(a, b, c)
struct stats *a, *b, *c;
{
        c->s_ttime = a->s_ttime - b->s_ttime;
        c->s_stime = a->s_stime - b->s_stime;
        c->s_utime = a->s_utime - b->s_utime;
        c->s_wtime = a->s_wtime - b->s_wtime;
        c->s_iotime = a->s_iotime - b->s_iotime;
        c->s_exttime = a->s_exttime - b->s_exttime;
        c->s_swtime = a->s_swtime - b->s_swtime;
        c->s_svcs = a->s_svcs - b->s_svcs;
        c->s_pgms = a->s_pgms - b->s_pgms;
        c->s_exts = a->s_exts - b->s_exts;
        c->s_iois = a->s_iois - b->s_iois;
        c->s_swtchs = a->s_swtchs - b->s_swtchs;
        c->s_ppfs = a->s_ppfs - b->s_ppfs;
        c->s_bio.b_ncache = a->s_bio.b_ncache - b->s_bio.b_ncache;
        c->s_bio.b_nread = a->s_bio.b_nread - b->s_bio.b_nread;
        c->s_bio.b_nreada = a->s_bio.b_nreada - b->s_bio.b_nreada;
        c->s_bio.b_nwrite = a->s_bio.b_nwrite - b->s_bio.b_nwrite;
        c->s_bio.b_ndwrite = a->s_bio.b_ndwrite - b->s_bio.b_ndwrite;
}
