/*
 * Vmpunch.
 * User interface to the virtual punch.
 *
 */

#include <stdio.h>
#include <pwd.h>
#include <ctype.h>
#include "/usr/src/etc/spooler/vmpunch.h"

extern  char    *cmdname;

vmpunch(argc, argv)
int  argc;
char **argv;
{
	struct passwd *pw;             /* Structure of user info */
	struct passwd *getpwnam();
	struct passwd *getpwuid();
	char    *getlogin();
	char    *upper();
	char    *vmid = NULL;           /* VM id to punch to */
	char    *userid = getlogin();   /* UTS user to receive file */
        char    *destfile = NULL;       /* UTS file to receive file */
	char    *class = "B";           /* punch class */
	char    *fromfile = NULL;
	char    *tag = NULL;
	char    *log;
	int     mode = 0;              /* Numeric punch mode        */
	int     fileout = 0;           /* Set if file to be deleted */
	FILE    *fdin = stdin;         /* file discriptor input     */

        /*
         * Read the flags and arguments.
         */
	*argv++;
        while(--argc > 0) {
		if(**argv != '-') {
			if (destfile == NULL)
			        destfile = *argv;
			fromfile = *argv;
			if (access(*argv, 4) == -1) {
				fprintf(stderr, "%s: read access denied to %s\n", cmdname, *argv);
				return(0);
                        }
			fdin = fopen(*argv, "r");
			if (fdin == NULL) {
				fprintf(stderr, "%s: cannot open %s\n",
					cmdname, *argv);
				return(0);
			}
		}
		else {
		        switch(*(*argv + 1)) {
		        case 'd' :
			        fileout = 1;
			        break;
                        case 'h' :
                                mode |= HEADER;
                                break;
		        case 'r' :
			        mode |= RAW;
			        break;
		        case 's' :
			        mode |= STREAM;
			        break;
		        case 'q' :
			        mode |= QUIET;
			        break;
			default:
				if (--argc <= 0) {
                                        fprintf(stderr, "%s: missing argument for %s option\n",
                                                cmdname, *argv);
					return(0);
				}
                                switch(*(*argv + 1)) {
                                case 'v' :
                                        vmid = *++argv;
                                        break;
                                case 'c' :
                                        class = *++argv;
                                        break;
                                case 'f' :
                                        destfile = *++argv;
                                        mode |= HEADER;
                                        break;
                                case 'i' :
                                        userid = *++argv;
                                        mode |= HEADER;
                                        break;
                                case 'x' :
                                        destfile = *++argv;
                                        mode |= (EXECUTE | QUIET | HEADER);
                                        break;
				case 't':
                                        tag = *++argv;
                                        break;
                                default :
                                        fprintf(stderr, "%s: what is '%s' doing here ?\n",
                                                cmdname, *argv);
                                        return(0);
                                }
                        }
		}
	        argv++;
        }
	if (fdin == stdin && destfile == NULL)
		destfile = "from.punch";
	/*
	 * If no VM destination was specified use default listed
	 * in /etc/passwd.
	 */
	if (vmid == NULL) {
		log = getlogin();
		if(log != NULL)
                        pw = getpwnam(getlogin());
		else
			pw = getpwuid(getuid());
		if(pw == NULL) {
			fprintf(stderr, "No default Vmid.\n");
			return(0);
		}
		vmid = pw->pw_vmid;
		if(vmid == NULL) {
			fprintf(stderr, "No default Vmid.\n");
			return(0);
		}
	}
	/*
	 * Write the CP commands and the header information.
	 */
	if (tag == NULL) {
		printf("1\n");
		printf("SPOOL PUNCH TO %s CLASS %s\n",
			upper(vmid), upper(class));
	} else {
		printf("2\n");
		printf("SPOOL PUNCH TO %s CLASS %s\n",
			upper(vmid), upper(class));
                printf("TAG DEV PUN %s\n", upper(tag));
	}
        if (userid == NULL) {
		pw = getpwuid(getuid());
		if (pw == NULL) {
			fprintf(stderr, "%s: unknown userid %d\n", cmdname, getuid());
			exit(1);
		}
		userid = pw->pw_name;
	}
	printf("%d %s %s\n", mode, userid, destfile);
	if(!kopy(fdin))
	        return(0);
	fclose(fdin);
	if(fileout && (fromfile != NULL))
		unlink(fromfile);
	return(1);
}

kopy(fd)
FILE *fd;
{
        static  char    buf[BUFSIZ];
        int     n;

        while ((n = fread(buf, 1, BUFSIZ, fd)) > 0) {
                if (fwrite (buf, 1, n, stdout) == NULL) {
                        fprintf(stderr, "error writing spool file\n");
                        return(0);
                }
        }
	return(1);
}

/*
 * upper - translate lower case letter to upper case
 * within a string.
 */
char *
upper(string)
char    *string;
{
	char    *s = string;

        while (*s) {
		if (islower(*s))
			*s = toupper(*s);
		s++;
	}
	return(string);
}
