#include        <stdio.h>
#include	"defs.h"

extern char	chkid();
static  char    *envp;

struct  namnod  ps2nod  = { NULL, NULL, ps2name },
		fngnod  = { NULL, NULL, fngname },
		pathnod = { NULL, NULL, pathname },
		ifsnod  = { NULL, NULL, ifsname },
		ps1nod  = { &pathnod, &ps2nod, ps1name },
		homenod = { &fngnod, &ifsnod, homename },
		mailnod = { &homenod, &ps1nod, mailname };

struct	namnod	*namep = &mailnod;


/* ========	variable and string handling	======== */

syslook(w, syswds)
register char	*w;
struct	sysnod  syswds[];
{
	register char	first;
	register char	*s;
	register struct	sysnod	*syscan;

	syscan = syswds;
	first = *w;

	while (s = syscan->sysnam) {
		if (first == *s
		    && eq(w, s)) { 
			return(syscan->sysval);
		}
		syscan++;
	}
	return(0);
}

setlist(arg, xp)
register struct	argnod	*arg;
register int	xp;
{
	while (arg != NULL) {
		register char   *s = mactrim(arg->argval);
		setname(s, xp);
		arg = arg->argnxt;
		if (flags & EXECPR) {
			fprintf(stderr, "%s%c", s, (arg != NULL)? ' ': '\n');
		}
                free(s);
        }
}

setname(argi, xp)
register char	*argi;
register int	xp;
{
	register char   *argscan = argi;
	register struct	namnod	*n;

	if (letter(*argscan)) {	  
		while (alphanum(*argscan)) { 
			argscan++;
		}
		if (*argscan == '=') {
			*argscan = 0;
			n = lookup(argi);
			*argscan++ = '=';
			attrib(n, xp);
			if (xp&N_ENVNAM) {	
				replace(&n->namval, argscan);
				replace(&n->namenv, argscan);
			} 
			else {	
				assign(n, argscan);
			}
			return;
		}
	}
	failed(argi, notid);
}

replace(a, v)
register char	**a;
register char	*v;
{
        if (*a != NULL) {
                free(*a);
	}
	*a = make(v);
}

dfault(n, v)
register struct	namnod	*n;
register char	*v;
{
	if (n->namval==0) {	
		assign(n, v);
	}
}

assign(n, v)
register struct	namnod	*n;
register char	*v;
{
	if (n->namflg & N_RDONLY)
		failed(n->namid, wtfailed);
	else
		replace(&n->namval, v);
}

readvar(names)
register char	**names;
{
	register int    c;
	register int  rc = 0;
	register struct  namnod  *n = lookup(*names++);
	char    *bp;
	int     svflg, svflin;
	FILE    *svfp;

	svflg = cflg;
	svfp = cfp;
	svflin = flin;
	cflg = 0;
	cfp = stdin;

	bp = buf;
	for (;;) {	
		c = nextc(0);
		if (((*names != NULL) && any(c, ifsnod.namval)) || eolchar(c)) {
			*bp = '\0';
			assign(n, buf);
			if (*names) {	
				n = lookup(*names++);
			} 
			else {	
				n = 0;
			}
			if (eolchar(c)) {	
				break;
			}
		} 
		else {	
			*bp++ = c;
		}
	}
	while (n) { 
		assign(n, nullstr);
		if (*names) { 
			n=lookup(*names++); 
		} 
		else { 
			n=0; 
		}
	}

	if (c == EOF) {
		rc=1;
	}
	cfp = svfp;
	cflg = svflg;
	flin = svflin;

	return(rc);
}

assnum(p, i)
register char	**p;
register int	i;
{
	sprintf(numbuf, "%d", i);
	replace(p, numbuf);
}

char    *
make(v)
register char	*v;
{
	register char   *p = NULL;
	int     i;

	if (v != NULL) {
		i = strlen(v) + 1;
		p = malloc(i);
		strcpy(p, v);
	}
        return(p);
}


struct  namnod  *
lookup(nam)
register char	*nam;
{
	register struct	namnod	*nscan=namep;
	register struct	namnod	**prev;
	register int  LR;

	if (!chkid(nam)) {	
		failed(nam, notid);
	}
	while (nscan) {	     
		if ((LR = strcmp(nam, nscan->namid))==0)
			return(nscan);
		else if (LR<0)
			prev = &(nscan->namlft);
		else
			prev = &(nscan->namrgt);
		nscan = *prev;
	}
	/*
	 *  Add a name node
	 */
	nscan = (struct namnod *) malloc(sizeof *nscan);
	nscan->namlft = nscan->namrgt = NULL;
	nscan->namid  = make(nam);
	nscan->namval = 0;
	nscan->namflg = N_DEFAULT;
	nscan->namenv = 0;
	return(*prev = nscan);
}

char
chkid(nam)
register char	*nam;
{
	register char   *cp = nam;

	if (!letter(*cp)) {	
		return(FALSE);
	} 
	else {	  
		while (*++cp) {      
			if (!alphanum(*cp)) {	
				return(FALSE);
			}
		}
	}
	return(TRUE);
}

static int (*namfn)();

namscan(fn)
register int	(*fn)();
{
	namfn=fn;
	namwalk(namep);
}

namwalk(np)
register struct	namnod	*np;
{
	if (np) {	
		namwalk(np->namlft);
		(*namfn)(np);
		namwalk(np->namrgt);
	}
}

printnam(n)
register struct	namnod	*n;
{
	register char	*s;

	sigchk();
	if (s=n->namval)
		fprintf(stderr, "%s=%s\n", n->namid, s);
}

char     *
staknam(n)
register struct	namnod	*n;
{
	register char   *s;
	register char   *rs;

	rs = envp;
	s = n->namid;
	while(*s)
		*envp++ = *s++;
	*envp++ = '=';
	s = n->namenv;
	while(*s)
		*envp++ = *s++;
	*envp++ = '\0';
	return(rs);
}

exname(n)
register struct	namnod	*n;
{
	if (n->namflg & N_EXPORT) {
		if (n->namenv != NULL) {
                        free(n->namenv);
		}
		n->namenv = make(n->namval);
	} 
	else {	
		if (n->namval != NULL) {
                        free(n->namval);
		}
		n->namval = make(n->namenv);
	}
}

printflg(n)
register struct	namnod	*n;
{
	if (n->namflg & N_EXPORT) {
		fprintf(stderr, "%s ", export);
	}
	if (n->namflg & N_RDONLY) {
		fprintf(stderr, "%s ", readonly);
	}
	if (n->namflg & (N_EXPORT | N_RDONLY)) {
		fprintf(stderr, "%s\n", n->namid);
	}
}

getenv()
{
	register char   **e = environ;

	while (*e) { 
		setname(*e++, N_ENVNAM);
	}
}

static int  namec;

/*ARGSUSED*/
int	countnam(n)
register struct	namnod	*n;
{
	namec++;
}

static char	**argnam;

pushnam(n)
register struct	namnod	*n;
{
	if (n->namval) {	
		*argnam++ = staknam(n);
	}
}

char    **
setenv()
{
	register char	**er;

	envp = malloc(SHBUFSIZ);
	namec = 0;
	namscan(countnam);
	argnam = er = (char **) malloc((namec + 1)*sizeof(char *));
	namscan(pushnam);
	*argnam++ = NULL;
	return(er);
}
