#include        <stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#define DIRSIZ 15
#include	<sys/dir.h>
#include	"defs.h"


/* globals (file name generation)
 *
 * "*" in params matches r.e ".*"
 * "?" in params matches r.e. "."
 * "[...]" in params matches character class
 * "[...a-z...]" in params matches a through z.
 * "[^...]" in parms matches class of all but the given chars
 *
 */

extern int  addg();

int	expand(as, rflg)
char	*as;
{
	int  count;
	char	dir=0;
	char	*rescan = 0;
	register char	*s, *cs;
	struct	argnod	*schain = gchain;
	struct	direct	entry;
	struct	stat	statb;
	FILE    *dfp, *fopen();

	if (trapnote&SIGSET) { 
		return(0); 
	}

	s=cs=as; 
	entry.d_name[DIRSIZ-1]=0; /* to end the string */

	/* check for meta chars */
	{
		register char	slash; 
		slash=0;
		while (!fngchar(*cs)) {	     
			if (*cs++==0) {	     
				if (rflg && slash) { 
					break; 
				} 
				else { 
					return(0);
				}
			} 
			else if (*cs=='/') {	
				slash++;
			}
		}
	}

	for (;;) {	     
		if (cs==s) {	
			s=nullstr;
			break;
		} 
		else if (*--cs == '/') {	
			*cs=0;
			if (s==cs) { 
				s="/";
			}
			break;
		}
	}
	if (stat(s, &statb)>=0
	    && (statb.st_mode&S_IFMT)==S_IFDIR
	    && (dfp = fopen(s, "r")) != NULL) {
		dir++;
	}
	count=0;
	if (*cs==0) { 
		*cs++=0200;
	}
	if (dir) {	/* check for rescan */
		register char	*rs; 
		rs=cs;

		do {	     
			if (*rs=='/') { 
				rescan=rs; 
				*rs=0; 
				gchain=0;
			}
		} 
		while (*rs++);
		while(fread((char *) &entry, 16, 1, dfp) == 1 &&
		     (trapnote & SIGSET) == 0) {
			if (entry.d_ino==0 ||
			    (*entry.d_name=='.' && *cs!='.')) {	
				continue;
			}
			if (gmatch(entry.d_name, cs)) {	
				addg(s, entry.d_name, rescan); 
				count++;
			}
		}
		fclose(dfp);

		if (rescan) {	
			register struct	argnod	*rchain;
			rchain=gchain; 
			gchain=schain;
			if (count) {	
				count=0;
				while (rchain) {	
					count += expand(rchain->argval, 1);
					rchain=rchain->argnxt;
				}
			}
			*rescan='/';
		}
	}

	{
		register char	c;
		s=as;
		while (c = *s) {	
			*s++=(c&STRIP?c:'/');
		}
	}
	return(count);
}

gmatch(s, p)
register char	*s, *p;
{
	register int  scc;
	char	c;

	if (scc = *s++) {	     
		if ((scc &= STRIP)==0) {	
			scc=0200;
		}
	}
	switch (c = *p++) {

	case '[':
		{
			char	ok; 
			int  lc;
			ok=0; 
			lc=077777;
			if (*p=='^'       /* match chars not in class */) {
				p++;
				while (c = *p++) {           
					if (c==']') {    
						return(ok?gmatch(s, p):0);
					} 
					else if (c==MINUS) {         
						if (lc>scc || scc>(*p++)) { 
							ok++;
						}
					} 
					else {         
						if (scc!=(lc=(c&STRIP)) && *p!=MINUS) { 
							ok++;
						}
					}
				}
			} 
			else {
				while (c = *p++) {           
					if (c==']') {    
						return(ok?gmatch(s, p):0);
					} 
					else if (c==MINUS) {         
						if (lc<=scc && scc<=(*p++)) { 
							ok++;
						}
					} 
					else {         
						if (scc==(lc=(c&STRIP))) { 
							ok++;
						}
					}
				}
			}
			return(0);
		}

	default:
		if ((c&STRIP)!=scc) { 
			return(0);
		}

	case '?':
		return(scc?gmatch(s, p):0);

	case '*':
		if (*p==0) { 
			return(1);
		}
		--s;
		while (*s) {       
			if (gmatch(s++, p)) { 
				return(1);
			} 
		}
		return(0);

	case 0:
		return(scc==0);
	}
}

addg(as1, as2, as3)
register char    *as1, *as2;
char    *as3;
{
	register int  c;
	register char   *bp = buf;
	struct  argnod  *argp;

	argp = (struct argnod *) malloc(ARGSIZ);
	argp->argmk = 0;
	while (c = *as1++) {
		if ((c &= STRIP) == 0) {
			*bp++ = '/';
			break;
		}
		*bp++ = c;
	}
	while (*as2)
		*bp++ = *as2++;
	if (as3 != NULL) {
		*bp++ = '/';
		while (*bp++ = *++as3)
                        ;
	}
	*bp = '\0';
	argp->argval = malloc(strlen(buf) + 1);
	strcpy(argp->argval, buf);
	makearg(argp);
}

makearg(args)
register struct argnod   *args;
{
	args->argnxt=gchain;
	gchain=args;
}
