/*
 * This section of code contains all the PLI command routines
 * to actually do the full-screen prompting for the required
 * parameters.
 */

#include  "pli.h"

jobparms(type) char *type;

/* Display the jobcard defaults and prompt for changes */
{
        int  ok, curspos, i;
        char mesg[31];
        extern int qskp;

        mesg[0] = NULL;
  paintscreen:
        ok = 0;
        panel (erase) {
        #@102#ENTER JOBPARMS FOR PL/I #2type# #@151##2mesg,30#
        #@402#JOBNAME: #8pm.jobname,8#
        #@602#ACCOUNT: #5pm.account,13# #@628#BIN NUMBER: #5pm.bin,3#
        #@651#YOUR NAME: #5pm.name,16#
        #@802#EST. CPU SECONDS: #5pm.cputime,3#
        #@1202#PRINTOUT ROUTING:
        #@1311#OUTPUT CLASS  ==> #5pm.outclass,1#
        #@1335#E1BLDG ==> #5pm.e1bldg,3# (yes or no)
        #@1506#or   UNIX FILENAME ==> #5pm.unixfile,50#
        #@2402#HIT PF3 TO ABORT PLI COMMAND, HIT PF12 TO CONTINUE
        }
        while (!ok) {
                if (qskp==3) cancel();
                if (qskp==28 /* clear */)  goto paintscreen;
                for(i=0; i<31; i++) mesg[i] = NULL;
                curspos = qspos(pm.jobname);
                /* Validate the parms */
                ok = nonnull(pm.jobname, &curspos, mesg);
                if (ok) ok = nonnull(pm.account , &curspos, mesg);
                if (ok) ok = nonnull(pm.bin     , &curspos, mesg);
                if (ok) ok = nonnull(pm.name    , &curspos, mesg);
                if (ok) ok = nonnull(pm.cputime , &curspos, mesg);
                if (ok) ok = nonnull(pm.outclass, &curspos, mesg);
                if (ok) ok = nonnull(pm.e1bldg  , &curspos, mesg);
                strip(pm.unixfile);
                if (ok) ok = nonnumb(pm.cputime , &curspos, mesg);
                if (ok) ok = checkyn(pm.e1bldg  , &curspos, mesg);

                /* can't get out unless they hit pf12 */
                if (qskp != 12) ok = 0;
                if (!ok) {
                        panel (noerase,cursor=curspos) {
                        #@151##2mesg,30#
                        }
                }
        } /* end of while */
}


plicparms()

/* Ask the user if they want the files to go to an object module,  */
/* and if yes, prompt for member names for the output.  Also       */
/* allow specification of Compiler Input libraries.                */
{
        int  ok, curspos, i;
        char mesg[31], *ddn[MAXFILES], *fname[MAXFILES];
        extern int qskp;

        mesg[0] = NULL;
  paint1screen:
        ok = 0;
        panel (erase) {
        #@102#COMPILER INPUT LIBRARIES (no quotes):
        #@151##2mesg,30#
        #@202#==> #8pm.plinpt1,44#
        #@302#==> #5pm.plinpt2,44#
        #@502#COMPILER OUTPUT LIBRARY  #@551#COMPILER OPTIONS:
        #@602#==> #5pm.object,44#      #@651#==> #5pm.cops,50#
        #@2402#HIT PF3 TO ABORT PLI COMMAND, HIT PF12 TO CONTINUE
        }
        while (!ok) {
                if (qskp==3) cancel();
                if (qskp==28 /* clear */) goto paint1screen;
                ok = 1;
                for(i=0; i<31; i++) mesg[i] = NULL;
                curspos = qspos(pm.plinpt1);
                strip(pm.plinpt1);
                strip(pm.plinpt2);
                if(pm.plinpt1[0]==NULL && pm.plinpt2[0]!=NULL)
                        ok = nonnull(pm.plinpt1, &curspos, mesg);
                strip(pm.object);
                strip(pm.cops  );

                /* can't get out unless they hit pf12 */
                if (qskp!=12) ok = 0;
                if (!ok) {
                        panel (noerase,cursor=curspos) {
                        #@151##2mesg,30#
                        }
                }
        } /* end of while */

        if (pm.object[0] != NULL) { /* this is a big 'if'  */
        for(i=0; i<MAXFILES; i++)
                ddn[i] = fname[i] = "";
        for(i=0; i<filecnt; i++) {
                ddn[i] = dfiles[files[i]].memb;
                fname[i] = dfiles[files[i]].filename;
        }
        mesg[0] = NULL;
  paint2screen:
        ok = 0;
        pliscreen(ddn, fname, mesg);
        while (!ok) {
                if (qskp==3) cancel();
                if (qskp==28 /* clear */) goto paint2screen;
                /* Validate the parms */
                ok = 1;
                for(i=0; i<31; i++) mesg[i] = NULL;
                curspos = qspos(ddn[0]);
                for(i=0; ok && i<filecnt; i++)
                        ok = nonnull(ddn[i], &curspos, mesg);

                /* can't get out unless they hit pf12 */
                if (qskp!=12) ok = 0;
                if (!ok) {
                        panel (noerase,cursor=curspos) {
                        #@151##2mesg,30#
                        }
                }
        } /* end of while */
        } /* end of if    */
}

pliscreen(ddn, fname, mesg) char **ddn, **fname, *mesg;
{
        char dashes[81];
        int  i;

        if(filecnt>6 || mode==2) {
        panel (erase) {
        #@102#ENTER OUTPUT MEMBER NAMES
        #@151##2mesg,30#
        #@302#MEMBER_NAME    SOURCE_UNIX_FILE_NAME____________________
        #@402##8ddn[0],8#       #1fname[0],50#
        #@502##5ddn[1],8#       #1fname[1],50#
        #@602##5ddn[2],8#       #1fname[2],50#
        #@702##5ddn[3],8#       #1fname[3],50#
        #@802##5ddn[4],8#       #1fname[4],50#
        #@902##5ddn[5],8#       #1fname[5],50#
        #@1002##5ddn[6],8#       #1fname[6],50#
        #@1102##5ddn[7],8#       #1fname[7],50#
        #@1202##5ddn[8],8#       #1fname[8],50#
        #@1302##5ddn[9],8#       #1fname[9],50#
        #@1402##5ddn[10],8#       #1fname[10],50#
        #@1502##5ddn[11],8#       #1fname[11],50#
        #@1602##5ddn[12],8#       #1fname[12],50#
        #@1702##5ddn[13],8#       #1fname[13],50#
        #@1802##5ddn[14],8#       #1fname[14],50#
        #@1902##5ddn[15],8#       #1fname[15],50#
        #@2002##5ddn[16],8#       #1fname[16],50#
        #@2102##5ddn[17],8#       #1fname[17],50#
        #@2202##5ddn[18],8#       #1fname[18],50#
        #@2302##5ddn[19],8#       #1fname[19],50#
        #@2402#HIT PF3 TO ABORT PLI COMMAND, HIT PF12 TO CONTINUE
        }
        }
        else {
        for(i=0; i<80; i++) dashes[i] = '-';
        panel (noerase) {
        #@151##2mesg,30#
        #@1301##5dashes,80#
        #@1402#ENTER OUTPUT MEMBER NAMES
        #@1602#MEMBER_NAME    SOURCE_UNIX_FILE_NAME____________________
        #@1702##8ddn[0],8#       #1fname[0],50#
        #@1802##5ddn[1],8#       #1fname[1],50#
        #@1902##5ddn[2],8#       #1fname[2],50#
        #@2002##5ddn[3],8#       #1fname[3],50#
        #@2102##5ddn[4],8#       #1fname[4],50#
        #@2202##5ddn[5],8#       #1fname[5],50#
        #@2402#HIT PF3 TO ABORT PLI COMMAND, HIT PF12 TO CONTINUE
        }
        }
}


pliclparms()

/* Ask the user if they want the files to go to a load module,     */
/* and if yes, prompt for member names for the output.  Also       */
/* allow specification of Compiler and Link Edit input libraries.  */
{
        int  ok, curspos, i;
        char mesg[31], *ddn[MAXFILES], *fname[MAXFILES];
        extern int qskp;

        mesg[0] = NULL;
  paint1screen:
        ok = 0;
        panel (erase) {
        #@102#COMPILER INPUT LIBRARIES (no quotes):
        #@151##2mesg,30#
        #@202#==> #8pm.plinpt1,44#       #@251#COMPILER OPTIONS:
        #@302#==> #5pm.plinpt2,44#       #@351#==> #5pm.cops,50#
        #@502#LINKEDIT INPUT LIBRARIES:
        #@602#==> #5pm.linkin1,44#
        #@702#==> #5pm.linkin2,44#
        #@902#LINKEDIT OUTPUT LIBRARY:   #@951#LINKEDIT OPTIONS:
        #@1002#==> #5pm.loadmod,44#      #@1051#==> #5pm.linkops,50#
        #@2402#HIT PF3 TO ABORT PLI COMMAND, HIT PF12 TO CONTINUE
        }
        while (!ok) {
                if (qskp==3) cancel();
                if (qskp==28 /* clear */) goto paint1screen;
                ok = 1;
                for(i=0; i<31; i++) mesg[i] = NULL;
                curspos = qspos(pm.plinpt1);
                strip(pm.plinpt1);
                strip(pm.plinpt2);
                strip(pm.cops   );
                if(pm.plinpt1[0]==NULL && pm.plinpt2[0]!=NULL)
                        ok = nonnull(pm.plinpt1, &curspos, mesg);
                strip(pm.linkin1);
                strip(pm.linkin2);
                if(ok && pm.linkin1[0]==NULL && pm.linkin2[0]!=NULL)
                        ok = nonnull(pm.plinpt1, &curspos, mesg);
                strip(pm.loadmod);
                strip(pm.linkops);

                /* can't get out unless they hit pf12 */
                if (qskp!=12) ok = 0;
                if (!ok) {
                        panel (noerase,cursor=curspos) {
                        #@151##2mesg,30#
                        }
                }
        } /* end of while */

        if (pm.loadmod[0] != NULL) { /* this is a big 'if'  */
        for(i=0; i<MAXFILES; i++)
                ddn[i] = fname[i] = "";
        for(i=0; i<filecnt; i++) {
                ddn[i] = dfiles[files[i]].memb;
                fname[i] = dfiles[files[i]].filename;
        }
        mesg[0] = NULL;
  paint2screen:
        ok = 0;
        pliscreen(ddn, fname, mesg);
        while (!ok) {
                if (qskp==3) cancel();
                if (qskp==28 /* clear */) goto paint2screen;
                /* Validate the parms */
                ok = 1;
                for(i=0; i<31; i++) mesg[i] = NULL;
                curspos = qspos(ddn[0]);
                for(i=0; ok && i<filecnt; i++)
                        ok = nonnull(ddn[i], &curspos, mesg);

                /* can't get out unless they hit pf12 */
                if (qskp!=12) ok = 0;
                if (!ok) {
                        panel (noerase,cursor=curspos) {
                        #@151##2mesg,30#
                        }
                }
        } /* end of while */
        } /* end of if    */
}

pliclgparms()

/* Ask the user if they have any GO step parms and files to be     */
/* used as test input.  Also allow specification of Compiler and   */
/* Link Edit input libraries.                                      */
{
        int  ok, curspos, i;
        char mesg[31];
        extern int qskp;

        mesg[0] = NULL;
  paint1screen:
        ok = 0;
        panel (erase) {
        #@102#COMPILER INPUT LIBRARIES (no quotes):
        #@151##2mesg,30#
        #@202#==> #8pm.plinpt1,44#     #@251#COMPILER OPTIONS:
        #@302#==> #5pm.plinpt2,44#     #@351#==> #5pm.cops,50#
        #@502#LINKEDIT INPUT LIBRARIES:
        #@602#==> #5pm.linkin1,44#
        #@702#==> #5pm.linkin2,44#
        #@902#GO STEP INPUT FILES (Either MVS or UNIX, but UNIX filename must
        begin with a slash):
        #@1202#    DDNAME__      FILENAME_____________________________
        #@1302#==> #5pm.datadd1,8#  ==> #5pm.testdt1,44#
        #@1402#==> #5pm.datadd2,8#  ==> #5pm.testdt2,44#
        #@1502#==> #5pm.datadd3,8#  ==> #5pm.testdt3,44#
        #@1702#GO STEP PARAMETERS:
        #@1802#==> #5pm.goops,50#
        #@2402#HIT PF3 TO ABORT PLI COMMAND, HIT PF12 TO CONTINUE
        }
        while (!ok) {
                if (qskp==3) cancel();
                if (qskp==28 /* clear */) goto paint1screen;
                ok = 1;
                for(i=0; i<31; i++) mesg[i] = NULL;
                curspos = qspos(pm.plinpt1);
                strip(pm.plinpt1);
                strip(pm.plinpt2);
                strip(pm.cops   );
                if(pm.plinpt1[0]==NULL && pm.plinpt2[0]!=NULL)
                        ok = nonnull(pm.plinpt1, &curspos, mesg);
                strip(pm.linkin1);
                strip(pm.linkin2);
                if(ok && pm.linkin1[0]==NULL && pm.linkin2[0]!=NULL)
                        ok = nonnull(pm.plinpt1, &curspos, mesg);
                strip(pm.goops);
                if (ok) ok = checkdd(pm.datadd1, pm.testdt1, &curspos,
                                     mesg);
                if (ok) ok = checkdd(pm.datadd2, pm.testdt2, &curspos,
                                     mesg);
                if (ok) ok = checkdd(pm.datadd3, pm.testdt3, &curspos,
                                     mesg);
                /* can't get out unless they hit pf12 */
                if (qskp!=12) ok = 0;
                if (!ok) {
                        panel (noerase,cursor=curspos) {
                        #@151##2mesg,30#
                        }
                }
        } /* end of while */
}

checkdd(dd, fil, curspos, mesg) int *curspos; char *dd, *fil, *mesg;

/* Check the given go step ddname and file for validity, and set     */
/* curspos and mesg appropriately.                                   */
{
       strip(dd);
       strip(fil);
       if(dd[0]==NULL && fil[0]==NULL) return(1);
       if(dd[0]==NULL && fil[0]!=NULL) {
               *curspos = qspos(dd);
               cpright(mesg, "ENTER REQUIRED DDNAME", 30);
               return(0);
       }
       if(dd[0]!=NULL && fil[0]==NULL) {
               *curspos = qspos(fil);
               cpright(mesg, "ENTER REQUIRED FILENAME", 30);
               return(0);
       }
       return(1);
}
