#define DEBUG

#define EOF     -1        /* end-of-file */
#define NULL     0        /* no pointer */
#define BLANK   ' '       /* ascii blank */
#define NEWLINE '\n'      /* ascii newline */
#define TAB     '\t'      /* ascii tab */
#define EOS     '\0'      /* end-of-string */
#define FNLEN    8        /* max length of a function name */
#define FILELEN  21       /* max length of a file name */
#define TYPELEN  12       /* max length of a "type" */
#define TRUE    1
#define FALSE   0

struct  node    {
        struct  node    *n_bro;         /* ptr to brother */
        struct  node    *n_son;         /* ptr to son */
        struct  node    *n_dad;         /* ptr to father */
        struct  node    *n_clone;       /* ptr to duplicate occurrences */
        struct  anchor  *n_anch;        /* ptr to anchor */
        char    n_comp;                 /* flag - TRUE when a node is fully defined */
};

struct  anchor  {
        struct  anchor  *a_fwd;         /* ptr to next anchor */
        struct  anchor  *a_back;        /* ptr to previous anchor */
        struct  node    *a_node;        /* ptr to linked list of nodes */
        struct  cmt     *a_cmts;        /* ptr to commments */
        int     a_ncnt;                 /* number of nodes in the chain */
        char    a_name[FNLEN+1];        /* function name */
};

struct  cmt     {
        struct  cmt     *c_nxt;         /* ptr to next cmt */
        char    *c_text;                /* ptr to text of comment */
};

#define err()   fprintf(stderr, "%c\n?\n", 007)   /* print "?" and BEEP */
/* Get a new node.
*  If free storage exists, carve the node out of it.
*  Otherwise, make a system call to get another page of storage.
*  Initialize the node.
*  Returns:  a pointer to the new node.
*/
struct node *
nextnode(func_name)
   char *func_name;               /* The function name for the new node */
{
   struct node *newnode;

   if (freenodes != NULL) {
      newnode = freenodes;
      freenodes = freenodes->bro;
   }
   else{
      if (free_stor + sizeof(*newnode) > last_stor) {
         sbrk(4096);
         last_stor = free_stor + 4096;
      }
      newnode = free_stor;
      free_stor = free_stor + sizeof(*newnode);
   }

   newnode->complete = TRUE;
   newnode->son = NULL;
   newnode->bro = NULL;
   newnode->dad = NULL;
   newnode->clone = newnode;

   newnode->anch = anchor(newnode, func_name);
   return(newnode);
}


/* Add a node to the anchor list.
*  Search the anchor list for the anchor of this node.
*  If no anchor is found, create one and insert it into
*  the sorted list.
*  If the anchor is found, add this node to the linked list
*  emmanating from the anchor.
*  Returns:  a pointer to the newnodes anchor
*/
struct anchor *
anchor(p, func_name)
   struct node *p;            /* pointer to the node to add */
   char *func_name[ ];      /* function name of new node */
{
   struct anchor *a;
   struct node *q;
   int ret;

   for (a = banchor->fwdanch; a != banchor; a = a->fwdanch)
      if ((ret = strcmp(func_name, a->fname)) < 0)
         return(addanchor(a->backanch, p, func_name));
      else if (ret == 0) {
         a->nodecnt = a->nodecnt + 1;
         q = a->nodeptr;
         p->clone = q->clone;
         q->clone = p;
         return(a);
      }
   return(addanchor(banchor->backanch, p, func_name));
}


/* Add an anchor to the anchor list
*  Get storage for an anchor node.  Add it to the anchor list and
*  initialize it to point to its first node.
*  Returns:  nothing.
*/
struct anchor *
addanchor(a, p, func_name)
   struct anchor *a;          /* pointer to the anchor to add after    */
   struct node *p;            /* pointer to the first node to point at */
   char *func_name[ ];      /* function name of new node */
{
   struct anchor *newanch;    /* pointer to the new anchor */
   int i;

   if (freeanchs != NULL) {
      newanch = freeanchs;
      freeanchs = freeanchs->fwdanch;
   }
   else {
      if (free_stor + sizeof(*a) > last_stor) {
         sbrk(4096);
         last_stor = free_stor + 4096;
      }
      newanch = free_stor;
      free_stor = free_stor + sizeof(*a);
   }
   newanch->fwdanch = a->fwdanch;
   newanch->backanch = a;
   a->fwdanch->backanch = newanch;
   a->fwdanch = newanch;

   strcpy(newanch->fname, func_name);
   newanch->nodecnt = 1;
   newanch->nodeptr = p;
   newanch->cmts = NULL;
   return(newanch);
}

/* Add a call to a node.
*  Either add the call as the direct son of the node or to the end
*  of the brother chain of the first son.
*  Returns:  a pointer to the new son, or
*            NULL if the node already has a son by that name.
*/
struct node *
addcall(p, name)
   struct node *p;
   char *name;
{
   struct node *q;
   int ret;

   if (p->son == NULL) return(getson(p, p, name));
   else {
      for (q = p->son; q->bro != NULL; q = q->bro)
         if (strcmp(name, q->anch->fname) == 0) return(NULL);
      return(getbro(q, p, name));
   }
}

