#include <stdio.h>
#include "/usr/src/cmd/mip/manifest"
#include "/usr/src/usrlib/lint/lmanifest"

#define FNLEN           8       /* function name length */
#define NEWLINE         '\n'
#define DQUOTE          '"'
#define EOS             '\0'

char    *cmdname;

/* scnf - scan's filter
*  From the output of the first pass of lint, print lines
*  of the form:
*               function-name filename type
*  where type is either "defintion" or "call".
*/
main(argc, argv)
int     argc;
char    **argv;
{
	FILE    *fd;

	cmdname = *argv++;
	if (--argc > 0)
		while (argc--) {
			if ((fd = fopen(*argv, "r")) == NULL)
                                fprintf(stderr, "%s: %s: unable to open\n", cmdname, *argv);
			else
				filter(fd);
			argv++;
		}
	else
		filter(stdin);
}

filter(fd)
FILE    *fd;
{
	char    name[FNLEN+1];
	char    filename[64];
	char    *fn;
	int     type;
	int     class;
	int     num;
	int     match;          /* number of fields matched by fscanf() */

	while ((match = fscanf(fd, "%s %d %o %d", name, &type, &class, &num)) != EOF)     {
		if (match != 4) {
			fprintf(stderr, "%s: Bad input format\n", cmdname);
			exit(match);
		}
		if (num < 0)
			num = -num;
		while (num--)
                        fscanf(fd, "%*s");
                fscanf(fd, "%s", filename);
		filename[strlen(filename) - 1] = EOS;
		fn = &filename[1];
		if (*fn == EOS)
                        strcpy(fn, "stdin");

		if (ISFTN(class) && type == LDI)
			printf("%s %s definition\n", name, fn);
		else if (ISFTN(class))
			if (type == LRV || type == LUV || type == LUE)
                                printf("%s %s call\n", name, fn);
		while (getc(fd) != NEWLINE)
			;
	}
}
