/*------------ source/sccs4/com/putline.c --------*/
# include       "../hdr/defines.h"
 
/* SCCSID(@(#)putline      1.4); */
/*
        Routine to write out either the current line in the packet
        (if newline is zero) or the line specified by newline.
        A line is actually written (and the x-file is only
        opened) if pkt->p_upd is non-zero.  When the current line from
        the packet is written, pkt->p_wrttn is set non-zero, and
        further attempts to write it are ignored.  When a line is
        read into the packet, pkt->p_wrttn must be turned off.
*/
 
int     Xcreate;
FILE    *Xiop;
 
 
putline(pkt,newline)
struct packet *pkt;
char *newline;
{
        static char obf[BUFSIZ];
        char *xf;
        register char *p;
 
        if(pkt->p_upd == 0) return;
 
        if(!Xcreate) {
                stat(pkt->p_file,&Statbuf);
                xf = auxf(pkt->p_file,'x');
                Xiop = xfcreat(xf,Statbuf.st_mode);
                setbuf(Xiop,obf);
                chown(xf,Statbuf.st_uid,Statbuf.st_gid);
        }
        if (newline)
                p = newline;
        else {
                if(!pkt->p_wrttn++)
                        p = pkt->p_line;
                else
                        p = 0;
        }
        if (p) {
                fputs(p,Xiop);
                if (Xcreate)
                        while (*p)
                                pkt->p_nhash =+ *p++;
        }
        Xcreate = 1;
}
 
 
flushline(pkt,statts)
struct packet *pkt;
struct stats *statts;
{
        register char *p;
        char ins[6], del[6], unc[6], hash[17];
 
        if (pkt->p_upd == 0)
                return;
        putline(pkt,0);
        rewind(Xiop);
 
        if (statts) {
                sprintf(ins,"%5u",statts->s_ins);
                sprintf(del,"%5u",statts->s_del);
                sprintf(unc,"%5u",statts->s_unc);
                for (p = ins; *p; p++)
                        pkt->p_nhash =+ (*p - '0');
                for (p = del; *p; p++)
                        pkt->p_nhash =+ (*p - '0');
                for (p = unc; *p; p++)
                        pkt->p_nhash =+ (*p - '0');
        }
 
	if (pkt->p_nhash < 0) pkt->p_nhash = -pkt->p_nhash;
        sprintf(hash,"%16d",pkt->p_nhash);
        zeropad(hash);
        fprintf(Xiop,"%c%c%s\n",CTLCHAR,HEAD,hash);
        if (statts)
                fprintf(Xiop,"%c%c %s/%s/%s\n",CTLCHAR,STATS,ins,del,unc);
        fclose(Xiop);
}
 
 
xrm(pkt)
struct packet *pkt;
{
        if (Xiop)
                fclose(Xiop);
        Xiop = Xcreate = 0;
}
