#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "save.h"

extern  char    *cmdname;       /* name of this command */
char    *filestor;              /* malloc'ed space for the + file */
struct  version *verhdr = NULL; /* version info */
int     maxver = 0;             /* max saved versions */
int     nver = 0;               /* number of versions */
/*
 * restore - restore a file
 * Begin feeding the lines of the base file to a pipeline
 * of version application routines (one for each version).
 */
restore(ifp, ofp, ver)
FILE    *ifp;           /* input savefile */
FILE    *ofp;           /* output file */
int     ver;            /* version to restore */
{
	char    buff[MAXLINE];
	char    *malloc();
	char    *b;
	struct  stat    statbuf;
	struct  version *v;
	struct  version **vp;
	int     len, i;

	verhdr = NULL;
	maxver = 0;
	nver = 0;
	fstat(fileno(ifp), &statbuf);
	b = malloc(statbuf.st_size);
	filestor = b;
	vp = &verhdr;
	while (fgets(buff, MAXLINE, ifp) != NULL) {
		if (buff[0] == CNTRLCHAR) {
			switch (buff[1]) {
			case NVERSIONS:
				sscanf(buff, "%*s %d", &maxver);
				break;
			case INFO:
				nver++;
				v = (struct version *) malloc(sizeof(struct version));
				v->v_sptr = v->v_ptr = b;
				v->v_next = NULL;
				v->v_ln = v->v_start = v->v_dlen = 0;
				v->v_cmd = EOS;
				*vp = v;
				vp = &v->v_next;
				break;
			case ENDVER:
				v->v_eptr = b;
				getcmd(v);
				break;
			}
		}
		len = strlen(buff);
		buff[len - 1] = EOS;            /* null the newline */
                strcpy(b, buff);
                b += len;
	}
	if (ver < 0)
		if ((ver += nver) <= 0) {
                        fprintf(stderr, "%s: %d: pre-historic version\n",
                                cmdname, ver-nver);
                        return;
		}
	if (ver > 0) {
                i = ver;
                for (v = verhdr; --i; v = v->v_next) {
                        if (v == NULL) {
                                fprintf(stderr, "%s: %d: non-existent version\n",
                                        cmdname, ver);
                                return;
                        }
                }
                if (v == NULL) {
                        fprintf(stderr, "%s: %d: non-existent version\n",
                                cmdname, ver);
                        return;
                }
                v->v_next = NULL;
	}
        feed(verhdr, "", ofp);
}
/*
 * ver - apply a version
 * Accept lines from feed() and apply a given version
 */
ver(v, line, ofp)
struct  version *v;
char    *line;
FILE    *ofp;
{
	char    buff[MAXLINE];

	if (v->v_cmd == EOS)
		feed(v->v_next, line, ofp);
	else if (v->v_ln++ >= v->v_start) {
		switch (v->v_cmd) {
                case ADD:
                        feed(v->v_next, line, ofp);
			while (strcmp(v->v_ptr, ".") != 0) {
                                strcpy(buff, v->v_ptr);
                                strcat(buff, "\n");
                                feed(v->v_next, buff, ofp);
                                v->v_ptr += strlen(v->v_ptr) + 1;
			}
                        v->v_ptr += strlen(v->v_ptr) + 1;
			getcmd(v);
			break;
		case DELETE:
			if (--v->v_dlen == 0)
                                getcmd(v);
			break;
		case CHANGE:
			if (!--v->v_dlen) {
                                while (strcmp(v->v_ptr, ".") != 0) {
                                        strcpy(buff, v->v_ptr);
                                        strcat(buff, "\n");
                                        feed(v->v_next, buff, ofp);
                                        v->v_ptr += strlen(v->v_ptr) + 1;
                                }
                                v->v_ptr += strlen(v->v_ptr) + 1;
                                getcmd(v);
			}
			break;
                }
	} else
		feed(v->v_next, line, ofp);
}
/*
 * getcmd - get a diff command
 */
getcmd(v)
struct  version   *v;
{
	int     n1, n2;

	while (v->v_ptr < v->v_eptr && *(v->v_ptr) == CNTRLCHAR)
		v->v_ptr += strlen(v->v_ptr) + 1;
	if (v->v_ptr >= v->v_eptr) {
		v->v_ptr = v->v_sptr;
		v->v_ln = v->v_start = v->v_dlen = 0;
		v->v_cmd = EOS;
		return;
	}
	if (sscanf(v->v_ptr, "%1s %d %d", &v->v_cmd, &n1, &n2) == 2)
		n2 = n1;
	v->v_start = n1;
	if (v->v_cmd == ADD)
		v->v_dlen = 0;
	else
		v->v_dlen = n2 - n1 + 1;
	v->v_ptr += strlen(v->v_ptr) + 1;
}
/*
 *  isnum - check if a string contains a number.
 *  LINTLIBRARY
 */
isnum(s)
char    *s;
{
	while (*s) {
		if (!isdigit(*s) && !isspace(*s) && *s != '-' && *s != '+')
                        return(0);
		s++;
	}
	return(1);
}
