#include "ac.h"
extern
#include "ad.h"
extern
#include "av.h"
/*
 * CAT interface
 */

char codetab[256-32] = {	/*cat codes*/
00,	/*space*/
0145,	/*!*/
0230,	/*"*/
0337,	/*#*/
0155,	/*$*/
053,	/*%*/
050,	/*&*/
032,	/*' close*/
0132,	/*(*/
0133,	/*)*/
0122,	/***/
0143,	/*+*/
047,	/*,*/
040,	/*- hyphen*/
044,	/*.*/
043,	/*/*/
0110,	/*0*/
0111,	/*1*/
0112,	/*2*/
0113,	/*3*/
0114,	/*4*/
0115,	/*5*/
0116,	/*6*/
0117,	/*7*/
0120,	/*8*/
0121,	/*9*/
0142,	/*:*/
023,	/*;*/
0303,	/*<*/
0140,	/*=*/
0301,	/*>*/
0147,	/*?*/
0222,	/*@*/
0103,	/*A*/
075,	/*B*/
070,	/*C*/
074,	/*D*/
072,	/*E*/
0101,	/*F*/
065,	/*G*/
060,	/*H*/
066,	/*I*/
0105,	/*J*/
0107,	/*K*/
063,	/*L*/
062,	/*M*/
061,	/*N*/
057,	/*O*/
067,	/*P*/
055,	/*Q*/
064,	/*R*/
076,	/*S*/
056,	/*T*/
0106,	/*U*/
071,	/*V*/
0104,	/*W*/
0102,	/*X*/
077,	/*Y*/
073,	/*Z*/
0134,	/*[*/
0241,	/*\*/
0135,	/*]*/
0336,	/*^*/
0240,	/*_*/
030,	/*` open*/
025,	/*a*/
012,	/*b*/
027,	/*c*/
011,	/*d*/
031,	/*e*/
014,	/*f*/
045,	/*g*/
001,	/*h*/
006,	/*i*/
015,	/*j*/
017,	/*k*/
005,	/*l*/
004,	/*m*/
003,	/*n*/
033,	/*o*/
021,	/*p*/
042,	/*q*/
035,	/*r*/
010,	/*s*/
002,	/*t*/
016,	/*u*/
037,	/*v*/
041,	/*w*/
013,	/*x*/
051,	/*y*/
007,	/*z*/
0332,	/*{*/
0151,	/*|*/
0333,	/*}*/
0342,	/*~*/
00,	/*narrow space*/
040,	/*hyphen*/
0146,	/*bullet*/
0154,	/*square*/
022,	/*3/4 em*/
026,	/*rule*/
034,	/*1/4*/
036,	/*1/2*/
046,	/*3/4*/
0123,	/*minus*/
0124,	/*fi*/
0125,	/*fl*/
0126,	/*ff*/
0131,	/*ffi*/
0130,	/*ffl*/
0136,	/*degree*/
0137,	/*dagger*/
0355,	/*section*/
0150,	/*foot mark*/
0334,	/*acute accent*/
0335,	/*grave accent*/
0240,	/*underrule*/
0304,	/*slash (longer)*/
00,	/*half nar sp*/
00,	/**/
0225,	/*alpha*/
0212,	/*beta*/
0245,	/*gamma*/
0211,	/*delta*/
0231,	/*epsilon*/
0207,	/*zeta*/
0214,	/*eta*/
0202,	/*theta*/
0206,	/*iota*/
0217,	/*kappa*/
0205,	/*lambda*/
0204,	/*mu*/
0203,	/*nu*/
0213,	/*xi*/
0233,	/*omicron*/
0221,	/*pi*/
0235,	/*rho*/
0210,	/*sigma*/
0237,	/*tau*/
0216,	/*upsilon*/
0215,	/*phi*/
0227,	/*chi*/
0201,	/*psi*/
0251,	/*omega*/
0265,	/*Gamma*/
0274,	/*Delta*/
0256,	/*Theta*/
0263,	/*Lambda*/
0302,	/*Xi*/
0267,	/*Pi*/
0276,	/*Sigma*/
00,	/**/
0306,	/*Upsilon*/
0255,	/*Phi*/
0242,	/*Psi*/
0257,	/*Omega*/
0275,	/*square root*/
0262,	/*terminal sigma (was root em)*/
0261,	/*root en*/
0327,	/*>=*/
0326,	/*<=*/
0330,	/*identically equal*/
0264,	/*equation minus*/
0277,	/*approx =*/
0272,	/*approximates*/
0331,	/*not equal*/
0354,	/*right arrow*/
0234,	/*left arrow*/
0236,	/*up arrow*/
0223,	/*down arrow*/
0232,	/*equation equal*/
0323,	/*multiply*/
0324,	/*divide*/
0325,	/*plus-minus*/
0260,	/*cup (union)*/
0305,	/*cap (intersection)*/
0270,	/*subset of*/
0271,	/*superset of*/
0350,	/*improper subset*/
0246,	/* improper superset*/
0244,	/*infinity*/
0273,	/*partial derivative*/
0253,	/*gradient*/
0307,	/*not*/
0266,	/*integral sign*/
0247,	/*proportional to*/
0343,	/*empty set*/
0341,	/*member of*/
0353,	/*equation plus*/
0141,	/*registered*/
0153,	/*copyright*/
0346,	/*box rule (was parallel sign)*/
0127,	/*cent sign*/
0345,	/*dbl dagger*/
0250,	/*right hand*/
0340,	/*left hand*/
0347,	/*math * */
0243,	/*bell system sign*/
0226,	/*or (was star)*/
0351,	/*circle*/
0311,	/*left top (of big curly)*/
0314,	/*left bottom*/
0315,	/*right top*/
0317,	/*right bot*/
0313,	/*left center of big curly bracket*/
0316,	/*right center of big curly bracket*/
0312,	/*bold vertical*/
0321,	/*left floor (left bot of big sq bract)*/
0320,	/*right floor (rb of ")*/
0322,	/*left ceiling (lt of ")*/
0310};	/*right ceiling (rt of ")*/

/* default width tables */
/*modified for Commercial II*/
char W1[256-32] = {	/*Times Roman widths*/
12,	 /*space*/
12,	 /*!*/
0,	 /*"*/
0,	 /*#*/
19,	 /*$*/
29,	 /*%*/
28,	 /*&*/
12,	 /*' close*/
16,	 /*(*/
16,	 /*)*/
16,	 /***/
36,	 /*+*/
12,	 /*,*/
13,	 /*- hyphen*/
10,	 /*.*/
17,	 /*/*/
19+0200, /*0*/
19+0200, /*1*/
19+0200, /*2*/
19+0200, /*3*/
19+0200, /*4*/
19+0200, /*5*/
19+0200, /*6*/
19+0200, /*7*/
19+0200, /*8*/
19+0200, /*9*/
10,	 /*:*/
12,	 /*;*/
0,	 /*<*/
36,	 /*=*/
0,	 /*>*/
20,	 /*?*/
0,	 /*@*/
29+0200, /*A*/
23+0200, /*B*/
26+0200, /*C*/
30+0200, /*D*/
24+0200, /*E*/
23+0200, /*F*/
30+0200, /*G*/
29+0200, /*H*/
13+0200, /*I*/
16+0200, /*J*/
28+0200, /*K*/
24+0200, /*L*/
35+0200, /*M*/
29+0200, /*N*/
27+0200, /*O*/
22+0200, /*P*/
27+0300, /*Q*/
27+0200, /*R*/
20+0200, /*S*/
24+0200, /*T*/
29+0200, /*U*/
27+0200, /*V*/
36+0200, /*W*/
28+0200, /*X*/
27+0200, /*Y*/
23+0200, /*Z*/
14,	 /*[*/
0,	 /*\*/
14,	 /*]*/
0,	 /*^*/
0,	 /*_*/
12,	 /*` open*/
17,	 /*a*/
20+0200, /*b*/
16,	 /*c*/
20+0200, /*d*/
18,	 /*e*/
13+0200, /*f*/
18+0100, /*g*/
21+0200, /*h*/
10+0200, /*i*/
9+0300, /*j*/
20+0200, /*k*/
10+0200, /*l*/
32,	 /*m*/
21,	 /*n*/
20,	 /*o*/
19+0100, /*p*/
19+0100, /*q*/
14,	 /*r*/
15,	 /*s*/
12+0200, /*t*/
21,	 /*u*/
20,	 /*v*/
26,	 /*w*/
20,	 /*x*/
18+0100, /*y*/
17,	 /*z*/
0,	 /*{*/
2,	 /*|*/
0,	 /*}*/
0,	 /*~*/
6,	 /*narrow space*/
13,	 /*hyphen*/
27,	 /*bullet*/
27,	 /*square*/
36,	 /*3/4 em*/
18,	 /*rule*/
29,	 /*1/4*/
29,	 /*1/2*/
29,	 /*3/4*/
36,	 /*minus*/
21,	 /*fi*/
21,	 /*fl*/
24,	 /*ff*/
32,	 /*ffi*/
32,	 /*ffl*/
15,	 /*degree*/
20,	 /*dagger*/
0,	 /*section*/
8,	 /*foot mark*/
0,	 /*'*/
0,	 /*`*/
0,	 /*_*/
0,
3,	/*half nar sp*/
0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,
20,	 /*registered*/
20,	 /*copyright*/
0,
19,	 /*cent*/
};

char W2[256-32] = {	/*Times Italic widths*/
12,	 /*space*/
13,	 /*!*/
0,	 /*"*/
0,	 /*#*/
19,	 /*$*/
27,	 /*%*/
26,	 /*&*/
11,	 /*' close*/
15,	 /*(*/
15,	 /*)*/
16,	 /***/
36,	 /*+*/
11,	 /*,*/
13,	 /*- hyphen*/
11,	 /*.*/
9,	 /*/*/
19+0200, /*0*/
19+0200, /*1*/
19+0200, /*2*/
19+0200, /*3*/
19+0200, /*4*/
19+0200, /*5*/
19+0200, /*6*/
19+0200, /*7*/
19+0200, /*8*/
19+0200, /*9*/
11,	 /*:*/
11,	 /*;*/
0,	 /*<*/
36,	 /*=*/
0,	 /*>*/
20,	 /*?*/
0,	 /*@*/
25+0200, /*A*/
24+0200, /*B*/
26+0200, /*C*/
27+0200, /*D*/
23+0200, /*E*/
21+0200, /*F*/
27+0200, /*G*/
29+0200, /*H*/
14+0200, /*I*/
16+0200, /*J*/
28+0200, /*K*/
24+0200, /*L*/
34+0200, /*M*/
27+0200, /*N*/
27+0200, /*O*/
22+0200, /*P*/
27+0300, /*Q*/
27+0200, /*R*/
20+0200, /*S*/
23+0200, /*T*/
28+0200, /*U*/
25+0200, /*V*/
36+0200, /*W*/
24+0200, /*X*/
24+0200, /*Y*/
25+0200, /*Z*/
13,	 /*[*/
0,	 /*\*/
13,	 /*]*/
0,	 /*^*/
0,	 /*_*/
11,	 /*` open*/
19,	 /*a*/
18+0200, /*b*/
15,	 /*c*/
18+0200, /*d*/
16,	 /*e*/
11+0200, /*f*/
17+0100, /*g*/
19+0200, /*h*/
9+0200, /*i*/
9+0300, /*j*/
19+0200, /*k*/
9+0200, /*l*/
28,	 /*m*/
19,	 /*n*/
18,	 /*o*/
17+0100, /*p*/
18+0100, /*q*/
13,	 /*r*/
14,	 /*s*/
10+0200, /*t*/
19,	 /*u*/
16,	 /*v*/
24,	 /*w*/
18,	 /*x*/
16+0100, /*y*/
14,	 /*z*/
0,	 /*{*/
2,	 /*|*/
0,	 /*}*/
0,	 /*~*/
6,	 /*narrow space*/
13,	 /*hyphen*/
27,	 /*bullet*/
27,	 /*square*/
36,	 /*3/4 em*/
18,	 /*rule*/
27,	 /*1/4*/
27,	 /*1/2*/
27,	 /*3/4*/
36,	 /*minus*/
21,	 /*fi*/
21,	 /*fl*/
21,	 /*ff*/
31,	 /*ffi*/
31,	 /*ffl*/
15,	 /*degree*/
19,	 /*dagger*/
16,	 /*section*/
7,	 /*foot mark*/
0,	 /*'*/
0,	 /*`*/
0,	 /*_*/
0,
3,	/*half nar sp*/
0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,
20,	 /*registered*/
20,	 /*copyright*/
0,
19,	 /*cent*/
};
char W3[256-32] = {	/*Times Bold widths*/
12,	 /*space*/
13,	 /*!*/
0,	 /*"*/
0,	 /*#*/
18,	 /*$*/
28,	 /*%*/
27,	 /*&*/
12,	 /*' close*/
16,	 /*(*/
16,	 /*)*/
18,	 /***/
36,	 /*+*/
12,	 /*,*/
14,	 /*- hyphen*/
12,	 /*.*/
18,	 /*/*/
19+0200, /*0*/
19+0200, /*1*/
19+0200, /*2*/
19+0200, /*3*/
19+0200, /*4*/
19+0200, /*5*/
19+0200, /*6*/
19+0200, /*7*/
19+0200, /*8*/
19+0200, /*9*/
13,	 /*:*/
13,	 /*;*/
0,	 /*<*/
36,	 /*=*/
0,	 /*>*/
22,	 /*?*/
0,	 /*@*/
28+0200, /*A*/
26+0200, /*B*/
26+0200, /*C*/
29+0200, /*D*/
25+0200, /*E*/
23+0200, /*F*/
28+0200, /*G*/
32+0200, /*H*/
16+0200, /*I*/
21+0200, /*J*/
28+0200, /*K*/
25+0200, /*L*/
36+0200, /*M*/
30+0200, /*N*/
29+0200, /*O*/
25+0200, /*P*/
29+0300, /*Q*/
28+0200, /*R*/
23+0200, /*S*/
25+0200, /*T*/
29+0200, /*U*/
27+0200, /*V*/
36+0200, /*W*/
27+0200, /*X*/
28+0200, /*Y*/
27+0200, /*Z*/
12,	 /*[*/
0,	 /*\*/
12,	 /*]*/
0,	 /*^*/
0,	 /*_*/
12,	 /*` open*/
19,	 /*a*/
19+0200, /*b*/
16,	 /*c*/
19+0200, /*d*/
17,	 /*e*/
13+0200, /*f*/
18+0100, /*g*/
22+0200, /*h*/
12+0200, /*i*/
12+0300, /*j*/
23+0200, /*k*/
12+0200, /*l*/
32,	 /*m*/
22,	 /*n*/
18,	 /*o*/
20+0100, /*p*/
19+0100, /*q*/
15,	 /*r*/
17,	 /*s*/
13+0200, /*t*/
21,	 /*u*/
19,	 /*v*/
27,	 /*w*/
21,	 /*x*/
19+0100, /*y*/
17,	 /*z*/
0,	 /*{*/
2,	 /*|*/
0,	 /*}*/
0,	 /*~*/
6,	 /*narrow space*/
14,	 /*hyphen*/
27,	 /*bullet*/
27,	 /*square*/
36,	 /*3/4 em*/
18,	 /*rule*/
28,	 /*1/4*/
28,	 /*1/2*/
28,	 /*3/4*/
36,	 /*minus*/
22,	 /*fi*/
22,	 /*fl*/
23,	 /*ff*/
33,	 /*ffi*/
33,	 /*ffl*/
15,	 /*degree*/
20,	 /*dagger*/
0,	 /*section*/
9,	 /*foot mark*/
0,	 /*'*/
0,	 /*`*/
0,	 /*_*/
0,
3,	/*half nar sp*/
0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,
20,	 /*registered*/
20,	 /*copyright*/
0,
19,	 /*cent*/
};

/*
Modified for Commercial II
and with +, -, and = for equations
*/
char W4[256-32] = {	/*Special font widths*/
0,0,	 	/*.=Sw+042-40*/
13,	 /*"*/
29,	 /*#*/
0,0,0,0,	 	/*.=Sw+074-40*/
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,
36,	 /*<*/
0,	 	/*.=Sw+076-40*/
36,	 /*>*/
0,	 	/*.=Sw+100-40*/
36,	 /*@*/
0,0,0,0,0,0,0,	/*.=Sw+134-40*/
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,
15,	 /*\\*/
0,	 	/*.=Sw+136-40*/
15,	 /*^*/
18,	 /*_ underrule*/
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,
14,	 /*{*/
0,	 	/*.=Sw+175-40*/
14,	 /*}*/
15,	 /*~*/
0,	 	/*.=Sw+220-40*/
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
17,	 /*section*/
0,		/*.=Sw+222-40*/
10,	 /*acute accent*/
10,	 /*grave accent*/
18,	 /*underrule*/
15,	 /*slash (longer)*/
0,	 /**/
0,	 /**/
24,	 /*alpha*/
23+0300, /*beta*/
23+0100, /*gamma*/
19+0200, /*delta*/
18,	 /*epsilon*/
18+0300, /*zeta*/
23+0100, /*eta*/
19+0200, /*theta*/
13,	 /*iota*/
21,	 /*kappa*/
22+0200, /*lambda*/
25+0100, /*mu*/
20,	 /*nu*/
20+0300, /*xi*/
20,	 /*omicron*/
27,	 /*pi*/
21+0100, /*rho*/
27,	 /*sigma*/
20,	 /*tau*/
21,	 /*upsilon*/
25+0300, /*phi*/
22+0100, /*chi*/
24+0300, /*psi*/
25,	 /*omega*/
24+0200, /*Gamma*/
26+0200, /*Delta*/
28+0200, /*Theta*/
28+0200, /*Lambda*/
27+0200, /*Xi*/
29+0200, /*Pi*/
25+0200, /*Sigma*/
0,	 /**/
28+0200, /*Upsilon*/
29+0200, /*Phi*/
32+0200, /*Psi*/
36+0200, /*Omega*/
30,	 /*square root*/
18+0100, /*terminal sigma*/
18,	 /*root en*/
36,	 /*>=*/
36,	 /*<=*/
36,	 /*identically equal*/
27,	 /*minus*/
36,	 /*approx =*/
36,	 /*approximates*/
36,	 /*not equal*/
36,	 /*right arrow*/
36,	 /*left arrow*/
18,	 /*up arrow*/
18,	 /*down arrow*/
27,	 /*equal*/
27,	 /*multiply*/
27,	 /*divide*/
36,	 /*plus-minus*/
36,	 /*cup (union)*/
36,	 /*cap (intersection)*/
36,	 /*subset of*/
36,	 /*superset of*/
36,	 /*improper subset*/
36,	 /*improper superset*/
34,	 /*infinity*/
21,	 /*partial derivative*/
36+0200, /*gradient*/
22,	 /*not*/
24,	 /*integral sign*/
27,	 /*proportional to*/
28,	 /*empty set*/
27,	 /*member of*/
27,	 /*plus*/
0,
0,
0,	 /*box vert rule (was 2.)*/
0,
17,	 /*dbl dagger*/
42,	 /*right hand*/
42,	 /*left hand*/
16,	 /*math * */
41,	 /*bell system sign*/
9,	 /*or*/
27,	 /*circle*/
9,	 /*left top (of big curly)*/
9,	 /*left bottom*/
9,	 /*right top*/
9,	 /*right bot*/
9,	 /*left center of big curly bracket*/
9,	 /*right center of big curly bracket*/
9,	 /*bold vertical*/
9,	 /*left floor (left bot of big sq bract)*/
9,	 /*right floor (rb of ")*/
9,	 /*left ceiling (lt of ")*/
9 }; /*right ceiling (rt of ")*/

extern int *olinep;
extern int oline[];
extern int *pslp;
extern int back;
extern int xpts;
extern int mpts;
extern int po;
extern int xflg;
extern int line[];
extern int lss;
extern int xbitf;
extern char obuf[];
extern char *obufp;
extern int esct;
extern int trflg;
extern int cs;
extern int smnt;
extern int mfont;
extern int xfont;
extern int code;
extern int mcase;
extern int esc;
extern int lead;
extern int paper;
extern int cps;
extern int psflg;
extern int ptid;
extern int verm;
extern int escm;
extern char pstab[], psctab[];
extern int dpn;
extern int ascii;
int mrail = 0; /*0=LR,1=UR*/
int mmag = 1; /*0=UM,1=LM*/
extern int nofeed;
extern int gflag;
extern int fontlab[];
int papflg;
extern int pfont;
extern int ppts;
extern int oldbits;
extern int bd;
extern int vflag;
extern int stopmesg;
extern int xxx;

ptinit(){

	if(ascii || gflag)return;
	oput(T_INIT);
	esc = T_IESC;
	ptesc();
	esct = 0;
	esc = po;
	oput(0140); /*some initial lead*/
}
ptout(i)
int i;
{
	register *k, lw, *j;
	int ds, de, inith, temp, *slp, dv;
	int psl[16];

	if((i & CMASK) != '\n'){
		*olinep++ = i;
		return;
	}
	if(olinep == oline){
		lead += lss;
		return;
	}
	pslp = psl;
	*pslp = lw = inith = dv = 0;
	for(k=oline; k<olinep; k++){
		trflg++;
		xbitf = 1;
		lw += width(*k);
		if((*k & (MOT | VMOT)) == (MOT | VMOT)){
			temp = *k & ~MOTV;
			if(*k & NMOT)temp = -temp;
			dv += temp;
		}
		if(!(*k & MOT) && xflg)for(j=psl; j<=pslp; j++){
			if(xpts == *j)break;
			if(j == pslp){
				*j = xpts;
				*++pslp = 0;
				break;
			}
		}
	}
	if(dv){
		vflag++;
		*olinep++ = makem(-dv);
		vflag = 0;
	}
	if(xflg){
	--pslp;
		for(j=psl; j<=pslp; j++){
			if(*j == mpts){
				temp = *j;
				*j = *pslp;
				*pslp = temp;
				break;
			}
		}
	}
	for(k=oline; k<olinep; k++){
		if(!(*k & MOT) || (*k & VMOT))break;
		*k &= ~MOT;
		if(*k & NMOT){
			*k &= ~NMOT;
			*k = -*k;
		}
		inith += *k;
	}
	lead += dip->blss + lss;
	dip->blss = 0;
	slp = k;
scan:
	temp = esct - po;
	if(mpts & DBL)temp -= 55;
	ds = temp - inith;
	de = lw - temp;
	if(de >= ds){
		back = 0;
		esc = -ds;
		for(k=slp; k<olinep; k++)ptout0(*k);
	}else{
		back = 1;
		esc = de;
		for(k = olinep-1; k>=slp; --k)ptout0(*k);
	}
	if(xflg && (--pslp >= psl))goto scan;
	olinep = oline;
	lead += dip->alss;
	dip->alss = 0;
}
ptout0(i)
int i;
{
	register j, k, w;
	int z;

	if(i & MOT){
		j = i & ~MOTV;
		if(i & NMOT)j = -j;
		if(back)j = -j;
		if(i & VMOT)lead += j;
		else esc += j;
		return;
	}
	xbitf = 2;
	if((i>>BYTE) == oldbits){
		xfont = pfont;
		xpts = ppts;
		xbitf = 0;
	}else xbits(i);
	if((k = (i & CMASK)) < 040){
		return;
	}
	w = getcw(k-32);
	if(cs){
		if(bd)w += bd - 1;
		j = (cs-w)/2;
		w = cs - j;
		if(bd)w -= bd - 1;
	}else j = 0;
	if(i & ZBIT){
		if(cs)w = -j; else w = 0;
		z = 1;
	}else z = 0;
	if(back){
		k = j;
		j = -w;
		w = -k;
	}
	esc += j;
	if((!xflg || (xpts == *pslp)) && (code & 077)){
		if(code & 0200){
			if(smnt)xfont = smnt -1;
			else goto p1;
		}
		if((k=(code>>6)&01)^mcase)oput((mcase=k)+0105);
		if(xfont != mfont){
			mfont = xfont;
			if(mrail != (xfont&01))
				oput(0101 + (mrail=xfont&01));
			if(mmag != (xfont<2))
				oput(0103 + (mmag=(xfont<2)));
		}
		if(xpts != mpts)ptps();
		if(lead)ptlead();
		if(esc)ptesc();
/*
		oput(code & 077);
*/
		*obufp++ = code & 077;
		if(obufp == (obuf + OBUFSZ + ascii - 1))flusho();
		if(bd){
			bd -= 1;
			if(back && !z)bd = -bd;
			if(esc += bd)ptesc();
			oput(code & 077);
			if(z)esc -= bd;
		}
	}else if(bd && !z){
		bd -= 1;
		if(back)bd = -bd;
		esc += bd;
	}
p1:
	esc += w;
	return;
}
ptps(){
	register i, j, k;

	if(psflg)return;
	if(cps){
		psflg++;
		i = findps(cps);
	}else i = xpts;
	for(j=0; (i&077) > (k = pstab[j]);j++)if(!k){k=pstab[--j];break;}
	j = psctab[j];
	oput((j & ~0200) | 0120);
	if((!(mpts & DBL))^(!(j & 0200))){
		if(j & 0200)k = 55;
			else k = -55;
		esc += k;
	}
	mpts = i;
}
ptlead(){
	register i, k;

	if(k = lead < 0)lead = -lead;
	if(k^verm)oput(0112 + ((verm=k)<<1));
	if(((k=lead)%3) == 2)k++;
	k /= 3;
	while(k > 0){
		if((i=31) > k)i = k;
		if(verm)paper -= i;
			else paper += i;
		oput(((~i) & 037) | 0140);
		if((paper > (11*144*15)) && !papflg && ptid != 1){
			prstr("Excessive paper use.\n");
			papflg++;
			if(ptid != 1){
				lead = 0;
				done2(0200);
			}
		}
		k -= i;
	}
	lead = 0;
}
ptesc(){
	register i, j, k;

	if(k = esc < 0)esc = -esc;
	if(k^escm)oput(0107 + (escm=k));
	k = esc;
	while(k > 0){
		if((i=127) > k)i = k;
		if(((j = (esct + i*(1-2*escm))) > (46*72+18-T_IESC)) ||
		   (j < 0))break;
/*
		oput(~i);
*/
		*obufp++ = ~i;
		if(obufp == (obuf + OBUFSZ + ascii - 1))flusho();
		esct = j;
		k -= i;
	}
	esc = 0;
}
dostop(){
	register i;

	if(ascii)return;
	if(!nofeed && !gflag)lead += TRAILER;
	ptlead();
	flusho();
	oput(T_INIT);
	oput(T_STOP);
	if(gflag){
		oput('f');
		for(i=0; i<4; i++){
			oput(fontlab[i] & BMASK);
			oput((fontlab[i]>>BYTE) & BMASK);
		}
	}else for(i=8; i>0; i--)oput(T_PAD);
	flusho();
	if(stopmesg)prstr("Pages finished.\n");
	mcase = mpts = mfont = mrail = verm = escm = 0;
	mmag = 1;
	report();
	paper = 0;
	esc = T_IESC;
	ptesc();
	esct = 0;
	esc = po;
}
