#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <ctype.h>

#define PA1      2
#define PA2      3
#define LINTCMD "/bin/lint"
#define NED     "/bin/ned"
#define EMAX    400
#define EFMAX   15
#define BIGBUF  1024
#define min(a,b) ((a < b)? a: b)
#define sname(path) ((ix=rindex(path, '/'))==NULL?path:ix+1)

char *ix;

union {
	int istat;
	struct { char b0, b1, b2, b3; } cstat;
} status;

char tmpa[40], tmpb[40];
char *getenv(), *index(), *rindex(), *malloc(), *xfgets();
char cmd[BUFSIZ];
char nedf[40];
int  pid;

struct xloc {
	int    pos;           /* position of this error in error file */
	int    lnum;          /* line number in source with error     */
};

struct errors {
	char   fname[100];    /* filename for these errors            */
	int    cnt;           /* number of errors for this file       */
	struct xloc eloc[EMAX];
};
struct errors *efil[EFMAX];
int ecnt;

/*ARGSUSED*/
main(argc,argv)
int argc;
char **argv;
{
	struct stat buf;
	extern int  quit();

	signal(PA1, quit);
	signal(PA2, quit);
	/*
	 * Create temp file name for tmpa.  tmpb will be filled in
	 * later when we know what file we are editing.
	 */
	pid = getpid();
	sprintf(tmpa, "/tmp/mlint%da", pid);
	/*
	 * Setup ned command file pointer (maybe they have their own)
	 */
	strcpy(nedf, getenv("HOME"));
	strcat(nedf, "/.../mcc");
	if (stat(nedf, &buf) < 0)
		strcpy(nedf, "/usr/lib/mcc");
	/*
	 * Copy command line into cmd array and go
	 */
	strcpy(cmd, "lint");
	while (*++argv) { strcat(cmd, " "); strcat(cmd, *argv); }
	mergelint(cmd);
	unlink(tmpa);
	unlink(tmpb);
	exit(status.istat);
}

quit()
{
	unlink(tmpa);
	unlink(tmpb);
	exit(1);
}

mergelint(cline)
char *cline;
{
	int i, changed;

	while (1) {
		xlint(cline,tmpa);
		builderr(tmpa);
		changed = 0;
		if (ecnt <= 0)
			break;
		for (i=0; i<ecnt; i++) {
			uniqueb(efil[i]->fname);
			merge(tmpa,efil[i],tmpb);
			ned(tmpb);
		/*
		 * ned returns a status of 2 in cases of errors like not
		 * being able to open the tube. someone may be running mcc
		 * in the background and be in a full screen program in
		 * the foreground. terminate if this happens.
		 *
		 * a status of 0 means that no write was done in ned.
		 * a status of 1 means a succesful write was done.
		 */
			if (status.cstat.b2 == 2) quit();
			if (status.cstat.b2 == 1) {
				changed++;
				filter(tmpb, efil[i]->fname);
			}
			unlink(tmpb);
			free((char *)efil[i]);
		}
		/*
		 * If no files were changed we can quit.
		 */
		if (!changed) quit();
		printf(": %s\n", cline);
		fflush(stdout);
	}
}

/*
 * Uniqueb makes a unique filename in the /tmp directory for the
 * given source name.
 */
uniqueb(source)
char *source;
{
	char *p;
	char append;

	p = sname(source);
	sprintf(tmpb,"/tmp/%.14s",p);
	if (access(tmpb,4) < 0)
		return;
	sprintf(tmpb,"/tmp/%.13s ",p);
	if (access(tmpb,4) < 0)
		return;
	append = 'A';
	for (append = 'A'; append <= 'Z'; append++) {
		sprintf(tmpb,"/tmp/%.12s.%c",p,append);
		if (access(tmpb,4) < 0)
			return;
	}
	error("cannot make tmpb\n");
}

xlint(cline, diag)
char *cline, *diag;
{
	int pid, rpid, fd;

	if ((pid = fork()) < 0)
		error("could not fork\n");
	if (pid == 0) {
		close(1);               /* redirect the standard output */
		fd = creat(diag,0600);  /* to the file diag             */
		close(2);               /* and the standard error       */
		dup(fd);                /* to the same file             */
		execl("/bin/sh", "sh", "-c", cline, 0);
		error("could not exec shell!\n");
	}
	while ((rpid = wait(&status.istat)) != pid && rpid >= 0);
	if (rpid < 0)
		error("no child to wait for\n");
}

builderr(dn)
char *dn;
{
	/*
	 * d stands for diagnostic
	 */
	FILE *df;
	char d[BIGBUF];
	char *p;
	char name[100], dlnum[20];
	int extra, i, dl, cpos, compar();

	if ((df = fopen(dn,"r")) == NULL)
		error("could not open %s\n",dn);
	/*
	 * "extra" messages may be compiler errors, errors from the
	 * assembler, or (quite possibly) an erroneous error message.
	 */
	extra = 0;
	ecnt = 0;
	while ((cpos=ftell(df))>=0 && xfgets(d,BIGBUF,df) != NULL) {
		i = sscanf(d, "\"%[^\"]\", line %[0123456789]:", name, dlnum);
		if (i == 2) {
			dl = atoi(dlnum);
			adderror(name, dl, cpos+(index(d,':')-d)+2);
			continue;
		}
		i = sscanf(d, "%*[^\"]\"%[^\"]\"(%[0123456789])", name, dlnum);
		/*
		 * if the file is in /usr/lib/lint look further.
		 *
		 * sometimes a filename of ??? is given when the name
		 * is unknown.  this message should be put on stdout.
		 */
		if (i == 2 && strncmp(name, "/usr/lib/lint", 13) != 0
                           && strcmp(name, "???") != 0) {
			dl = atoi(dlnum);
			adderror(name, dl, cpos);
			continue;
		}
		p = rindex(d, ':');
		i = sscanf(p, "%*[^\"]\"%[^\"]\"(%[0123456789])", name, dlnum);
		if (i==2) {
			dl = atoi(dlnum);
			adderror(name, dl, cpos);
			continue;
		}
		++extra;
		puts(d);
	}
	fclose(df);
	/*
	 * Sort the created error pointers by line number
	 */
	for (i=0; i<ecnt; i++) qsort(efil[i]->eloc, efil[i]->cnt,
			       sizeof(struct xloc), compar);
	/*
	 * if there were some extra diagnostics make it so
	 * the screen has to be cleared before going on to ned.
	 */
	if (extra && ecnt>0)
		for (i = 1; i <= 23; ++i)
			putchar('\n');
	fflush(stdout);
}

adderror(name, inum, ipos)
char *name;
{
	int i, j;

	for (i=0; i<ecnt; i++) {
		if (strcmp(name, efil[i]->fname)==0) {
			if (efil[i]->cnt == EMAX) return;
			j = efil[i]->cnt++;
			efil[i]->eloc[j].pos = ipos;
			efil[i]->eloc[j].lnum = inum;
			return;
		}
	}
	if (ecnt == EFMAX) return;
	j = ecnt++;
	efil[j] = (struct errors *) malloc(sizeof (struct errors));
	strcpy(efil[j]->fname, name);
	efil[j]->cnt = 1;
	efil[j]->eloc[0].pos  = ipos;
	efil[j]->eloc[0].lnum = inum;
}

compar(a,b)
struct xloc *a, *b;
{
	if (a->lnum > b->lnum) return(1);
	if (a->lnum < b->lnum) return(-1);
	return(0);
}

merge(dn, ep, mn)
char *dn, *mn;  struct errors *ep;
{
	/*
	 * d, s, and m stand for diagnostic, source, and merge
	 */
	FILE *df, *sf, *mf;
	int dl, sl;
	char s[BIGBUF], *sn;
	int eno;

	sn = ep->fname;
	if ((df = fopen(dn,"r")) == NULL)
		error("could not open %s\n",dn);
	if ((sf = fopen(sn,"r")) == NULL)
		error("could not open %s\n",sn);
	if ((mf = fopen(mn,"w")) == NULL)
		error("could not open %s\n",mn);
	sl = 0;
	for (eno=0; eno<ep->cnt; eno++) {
		dl = ep->eloc[eno].lnum;
		fseek(df, ep->eloc[eno].pos, 0);
		while (sl < dl && xfgets(s,BIGBUF,sf) != NULL) {
			xfputs(s,mf);
			++sl;
		}
		if (xfgets(&s[2],BIGBUF,df) != NULL) {
			s[0] = ':';
			s[1] = ' ';
			compress(s);
			xfputs(s,mf);
		}
	}
	while (xfgets(s,BIGBUF,sf) != NULL)
		xfputs(s,mf);
	fclose(df);
	fclose(sf);
	fclose(mf);
}

/*
 * Compress changes multiple occurences of blanks (or tabs) to a single
 * blank for the given string.
 */
compress(s)
register char *s;
{
	register char *t;
	register int  inblank;

	inblank = 0;
	for (t=s; *s; s++) {
		if (isspace(*s))  {
			if (inblank) continue;
			*t++ = ' ';
			inblank = 1;
		}
		else {
			*t++ = *s;
			inblank = 0;
		}
	}
	*t = NULL;
}


ned(fname)
char *fname;
{
	int pid, rpid;
	int (*pa1)(), (*pa2)();

	if ((pid = fork()) < 0)
		error("could not fork\n");
	if (pid == 0) {
		execl(NED, "ned", "-F", nedf, fname, 0);
		error("could not execl ned %s\n",fname);
	}
	pa1 = signal(PA1, SIG_IGN);
	pa2 = signal(PA2, SIG_IGN);
	while ((rpid = wait(&status.istat)) != pid && rpid >= 0);
	if (rpid < 0)
		error("no child to wait for\n");
	signal(PA1,pa1);
	signal(PA2,pa2);
}

filter(in,out)
char *in, *out;
{
	FILE *inf, *tmpoutf;
	char line[BIGBUF], tmpout[40];
	struct stat statbuf;

	maketmpout(out,tmpout);
	if ((inf = fopen(in,"r")) == NULL)
		error("could not open %s\n",in);
	if ((tmpoutf = fopen(tmpout,"w")) == NULL)
		error("could not open %s\n",tmpout);
	while (xfgets(line,BIGBUF,inf) != NULL)
		if (line[0] != ':' || line[1] != ' ')
			xfputs(line,tmpoutf);
	fclose(inf);
	fclose(tmpoutf);
	if (stat(out,&statbuf) < 0)
		error("cannot stat %s\n",out);
	if (chmod(tmpout,statbuf.st_mode) < 0)
		error("cannot chmod %s\n",tmpout);

	sync();
	unlink(out);
	if (link(tmpout,out) < 0)
		error("could not link %s to %s\n",tmpout,out);
	sync();
	unlink(tmpout);
}

/*
 * make a filename in t from s.
 * take up to 12 chars from the last component of s and then append X's.
 * then call mktemp to make sure it is unique.
 */

maketmpout(s,t)
char *s, *t;
{
	int nc, nX;
	char *p, *q;

	p = sname(s);
	nc = min(12,strlen(p));
	nX = min(6,14-nc);
	q = t;
	while (s < p)
		*q++ = *s++;
	while (nc--)
		*q++ = *p++;
	while (nX--)
		*q++ = 'X';
	*q = 0;
	mktemp(t);
}

char *
xfgets(s,n,f)
char *s;
int n;
FILE *f;
{
	char *os;
	int c;

	os = s;
	while (n > 0 && (c = getc(f)) != '\n' && c != EOF) {
		*s++ = c;
		--n;
	}
	if (n <= 0) {
		*s = 0;
		error("not enough room for chars in fgets\n%s\n",os);
	} else if (c == EOF)
		return((char *)NULL);
	*s = 0;
	return(os);
}

xfputs(s,f)
char *s;
FILE *f;
{
	while (*s)
		putc(*s++,f);
	putc('\n',f);
}

/*VARARGS*/ error(arglist)
char *arglist;
{
	fprintf(stderr,"%r",&arglist);
	quit();
}
