#include "defs"

/*  BASIC PROCEDURE.  RECURSIVE.  */

/*
p->done = 0   don't know what to do yet
p->done = 1   file in process of being updated
p->done = 2   file already exists in current state
p->done = 3   file make failed
*/

doname(p, reclevel, tval)
register struct nameblock *p;
int reclevel;
TIMETYPE *tval;
{
int errstat;
int okdel1;
int didwork;
TIMETYPE td, td1, tdep, ptime, ptime1, prestime();
register struct depblock *q;
struct depblock *qtemp, *srchdir(), *suffp, *suffp1, *d;
struct nameblock *p1, *p2;
struct shblock *implcom, *explcom;
register struct lineblock *lp;
struct lineblock *lp1, *lp2;
char sourcename[100], prefix[100], temp[100], concsuff[20];
char *rightptr;
char *sright;
char *target;
char *rtempptr;
char *orig1, *orig2;
char *pnamep, *p1namep;
char *mkqlist();
struct chain *qchain, *appendq();


if(p == 0)
	{
	*tval = 0;
	return(0);
	}

if(dbgflag)
	{
	printf("doname(%s,%d)\n",p->namep,reclevel);
	fflush(stdout);
	}

if(p->done > 0)
	{
	if (traceflag)
		{
		indent(reclevel);
		printf("%s previously processed\n",p->namep);
		}
	*tval = p->modtime;
	return(p->done == 3);
	}

errstat = 0;
tdep = 0;
implcom = 0;
explcom = 0;
ptime = exists(p->namep);
ptime1 = 0;
didwork = NO;
p->done = 1;	/* avoid infinite loops */

qchain = NULL;

/* Expand any names that have embedded metacharaters */

for(lp = p->linep ; lp ; lp = lp->nxtlineblock)
	for(q = lp->depp ; q ; q=qtemp )
		{
		qtemp = q->nxtdepblock;
		expand(q);
		}

/* make sure all dependents are up to date */

if (traceflag)
	{
	indent(reclevel);
	printf("Check dependents of %s\n",p->namep);
	}

for(lp = p->linep ; lp ; lp = lp->nxtlineblock)
	{
	td = 0;
	for(q = lp->depp ; q ; q = q->nxtdepblock)
		{
		if (traceflag && q->depname)
			{
			indent(reclevel);
			printf("Explicit dependent %s\n",q->depname->namep);
			}
		errstat += doname(q->depname, reclevel+1, &td1);
		if(dbgflag)
		    printf("TIME(%s)=%ld\n", q->depname->namep, td1);
		if(td1 > td) td = td1;
		if(ptime < td1)
			qchain = appendq(qchain, q->depname->namep);
		}
	if(p->septype == SOMEDEPS)
		{
		if(lp->shp!=0)
		     if( ptime<td || (ptime==0 && td==0) || lp->depp==0)
			{
			okdel1 = okdel;
			okdel = NO;
			setvar("@", p->namep);
			setvar("?", mkqlist(qchain) );
			qchain = NULL;
			if( !questflag )
				errstat += docom(lp->shp);
			setvar("@", "");
			okdel = okdel1;
			ptime1 = prestime();
			didwork = YES;
			}
		}

	else	{
		if(lp->shp != 0)
			{
			if(explcom)
				fprintf(stderr, "Too many command lines for '%s'\n",
					p->namep);
			else	explcom = lp->shp;
			}

		if(td > tdep) tdep = td;
		}
	}

/* Look for implicit dependents, using suffix rules */

for(lp = sufflist ; lp ; lp = lp->nxtlineblock)
    for(suffp = lp->depp ; suffp ; suffp = suffp->nxtdepblock)
	{
	pnamep = suffp->depname->namep;
	if(suffix(p->namep , pnamep , prefix))
		{
		srchdir( concat(prefix,"*",temp) , NO, NULL);
		for(lp1 = sufflist ; lp1 ; lp1 = lp1->nxtlineblock)
		    for(suffp1=lp1->depp ; suffp1 ; suffp1 = suffp1->nxtdepblock)
			{
			p1namep = suffp1->depname->namep;
			if( (p1=srchname(concat(p1namep, pnamep ,concsuff))) &&
			    (p2=srchname(concat(prefix, p1namep ,sourcename))) )
				{
				if (traceflag && p2)
					{
					indent(reclevel);
					printf("Implicit dependent %s\n",p2->namep);
					}
				errstat += doname(p2, reclevel+1, &td);
				if(ptime < td)
					qchain = appendq(qchain, p2->namep);
if(dbgflag) printf("TIME(%s)=%ld\n", p2->namep, td);
				if(td > tdep) tdep = td;
				setvar("*", prefix);
				setvar("<", copys(sourcename));
				for(lp2=p1->linep ; lp2 ; lp2 = lp2->nxtlineblock)
					if(implcom = lp2->shp) break;
				goto endloop;
				}
			}
		}
	}

endloop:


if (revflag) {                                  /*compute for test below*/
	rightptr = malloc(QBUFMAX);
	rtempptr = malloc(QBUFMAX);
	orig1 = rightptr;
	orig2 = rtempptr;
	target = sname(p->namep);
	if (p->linep) {
		*rightptr = '\0';
		for (d=p->linep->depp ; d ; d=d->nxtdepblock) {
			strcat(rightptr, d->depname->namep);
			strcat(rightptr, "  ");
		}
		sright = sname(rightptr);
	}
}

if ( (revflag)
    && (p->linep)
    && (!strncmp(target, substr(sright,rtempptr,2,QBUFMAX-2), strlen(target)))
    && (!strcmp("s.", substr(sright,rtempptr,0,2)))
    && (explcom) && (macro(explcom->shbp)) )
	{
	free(orig1);
	free(orig2);
	ptime = (tdep>0 ? tdep : prestime() );
	setvar("@", p->namep);
	setvar("?", mkqlist(qchain) );

	if (strcmp(get_src_id(p->namep),get_macro_id(explcom->shbp))) {
		if (traceflag) {
		        indent(reclevel);
		        printf("Explicit command based on revision numbers: ");
		}
	        errstat += docom(explcom);
	}
        setvar("@", "");
        if(noexflag || (ptime = exists(p->namep)) == 0)
	        ptime = prestime();
	}

else if(errstat==0 && (ptime<tdep || (ptime==0 && tdep==0) ) )
	{
	if (revflag) {
		free(orig1);
		free(orig2);
	}
	ptime = (tdep>0 ? tdep : prestime() );
	setvar("@", p->namep);
	setvar("?", mkqlist(qchain) );
	if(explcom)
		{
		if (traceflag)
			{
			indent(reclevel);
			printf("Explicit command: ");
			}
		errstat += docom(explcom);
		}
	else if(implcom)
		{
		if (traceflag)
			{
			indent(reclevel);
			printf("Implicit command: ");
			}
		errstat += docom(implcom);
		}
	else if(p->septype == 0)
		if(p1=srchname(".DEFAULT"))
			{
			setvar("<", p->namep);
			for(lp2 = p1->linep ; lp2 ; lp2 = lp2->nxtlineblock)
				if(implcom = lp2->shp)
					{
					if (traceflag)
						{
						indent(reclevel);
						printf("Implicit command from .DEFAULT: ");
						}
					errstat += docom(implcom);
					break;
					}
			}
		else if(keepgoing)
			{
			printf("Don't know how to make %s\n", p->namep);
			++errstat;
			}
		else
			fatal1(" Don't know how to make %s", p->namep);

	setvar("@", "");
	if(noexflag || (ptime = exists(p->namep)) == 0)
		ptime = prestime();
	}

else if(errstat!=0 && reclevel==0)
	printf("'%s' not remade because of errors\n", p->namep);

else if(!questflag && reclevel==0  &&  didwork==NO)
	printf("'%s' is up to date.\n", p->namep);

if(questflag && reclevel==0)
	exit(ndocoms>0 ? -1 : 0);

p->done = (errstat ? 3 : 2);
if(ptime1 > ptime) ptime = ptime1;
p->modtime = ptime;
*tval = ptime;
return(errstat);
}



docom(q)
struct shblock *q;
{
char *s;
struct varblock *varptr();
int ign, nopr;
char string[OUTMAX];

++ndocoms;
if(questflag)
	return(NO);

if(touchflag)
	{
	s = varptr("@")->varval;
	if(!silflag)
		printf("touch(%s)\n", s);
	if(!noexflag)
		touch(YES, s);
	}

else for( ; q ; q = q->nxtshblock )
	{
	subst(q->shbp,string);

	ign = ignerr;
	nopr = NO;
	for(s = string ; *s=='-' || *s=='@' ; ++s)
		if(*s == '-')  ign = YES;
		else nopr = YES;

	if( docom1(s, ign, nopr) && !ign)
		if(keepgoing)
			return(YES);
		else    fatal( NULL );
	}
return(NO);
}



docom1(comstring, nohalt, noprint)
register char *comstring;
int nohalt, noprint;
{
register int status;
char *pos;

if(comstring[0] == '\0') return(0);

if(!silflag && (!noprint || noexflag) &&
	(noteq(sname(comstring),"checkget") || traceflag) )
					/* checkget is not true command */
	{
	printf("%s%s\n", (noexflag ? "" : prompt), comstring);
	fflush(stdout);
	}

if(noexflag)
	if (pos = findstg(" make ", comstring)) {
	        addnoex(pos);
	        while (pos = findstg(" make ", pos)) /* >1 makes in stg */
	                addnoex(pos);
	        }
	else return (0);

if( status = dosys(comstring, nohalt) )
	{
	if( status>>8 )
		printf("*** Error code %d", (status>>8) & 0177 );
	else    printf("*** Termination code %d", status & 0177 );

	if(nohalt) printf(" (ignored)\n");
	else	printf("\n");
	fflush(stdout);
	}

return(status);
}



/*
 *  is there a revision macro after a "get" in the arg "shellcmd"
 */

macro(shellcmd)
char *shellcmd;
{
	char *s2;
	char macrostg[OUTMAX];
	char *ptr;
	int c;

	s2 = shellcmd;
	while (*s2 != '\0')
	        if ((*s2++ == 'g') && (*s2++ == 'e') && (*s2++ == 't')
		    && (*s2++ == ' ')) {
				while (*s2 == ' ') s2++;
				if (*s2 == '$') {               /* macro*/
				        subst(shellcmd, macrostg);
				        ptr = macrostg;
				        while (*ptr != '\0')  /*till end*/
					                      /*of macro*/
				                if ((*ptr++ == '-') &&
				                    (*ptr++ == 'r') &&
				                    (numcheck(ptr)) )
				                  return(YES);
				        return(NO);
				}
	        }

	return(NO);
}



/*
 *  search s2 for s1;  return pointer if found, else return 0
 */

findstg(s1,s2)
char *s1, *s2;
{
	char *a, *b, *pos;

	a = s1;     b = s2;
	while (*b != '\n') {
		pos = b;
		while (*b++ == *a++) {
			if (!*a) return (pos + strlen(s1));
			if (!*b) return (0);
		}
		b = pos + 1;
		a = s1;
	}
	return (0);
}



/*
 *  check for valid SCCS id number
 */

numcheck(ptr)
char *ptr;
{
	int c;

	c = *ptr++;                                     /* release      */
	if (!numeric(c))
		return(NO);
	c = *ptr++;
	if (numeric(c))
		c = *ptr++;
	if (c != '.')
		return(NO);
	c = *ptr++;                                     /* level        */
	if (!numeric(c))
		return(NO);
	c = *ptr++;
	if (numeric(c))
		c = *ptr++;
	if ((c == ' ') || (c == '\t'))                  /* rel.lev      */
		return(YES);

	if (c != '.')                                   /* branch ?     */
		return(NO);
	c = *ptr++;                                     /* branch       */
	if (!numeric(c))
		return(NO);
	c = *ptr++;
	if (c != '.')
		return(NO);
	c = *ptr++;                                     /* sequence     */
	if (!numeric(c))
		return(NO);
	if ((*ptr == ' ') || (*ptr == '\t'))
		return(YES);
	return(NO);
}



/*
 *  get sccsid number from line with "Rev" (caps or smalls)
 *    in file "filename"
 */

get_src_id(filename)
char *filename;
{
	FILE *fp;
	int c, rel1, rel, lev1, lev, br, seq, dot1, dot2;
	static char sccsid[9];
	char *rev;

	rev = sccsid;
	fp = fopen(filename,"r");
	if (fp == NULL)
	        if (!exists(filename))
		        return("0.0");
	        else fatal1("Cannot open %s to check for revision number",filename);
	while ((c=getc(fp)) != EOF)
	        if ( ((c == 'R') || (c == 'r'))
	            && (((c=getc(fp)) == 'E') || (c == 'e'))
		    && (((c=getc(fp)) == 'V') || (c == 'v'))) {
		        while ((rel1=getc(fp)) != '\n')
		                if ((rel=getnum(rel1,fp)) && (getc(fp) == '.')
		                    && ((lev1=getc(fp)) != EOF)
		                    && (lev=getnum(lev1,fp))) {
		                        dot1 = getc(fp);
		                        br   = getc(fp);
		                        dot2 = getc(fp);
		                        seq  = getc(fp);
		                        if ((dot1=='.') && (numeric(br)) &&
		                            (dot2=='.') && (numeric(seq)))
		                           sprintf(rev,"%d.%d.%c.%c",rel,lev,br,seq);
		                        else sprintf(rev,"%d.%d",rel,lev);
		                        return(rev);
		                }
	        }

        printf("Warning:  cannot find revision number in file %s\n",filename);
        return("0.0");
}



/*
 *  get sccsid number from value for macro in "shellcmd"
 */

get_macro_id(shellcmd)
char *shellcmd;
{
	static char macrostg[OUTMAX];
	char *rev, *ptr;
	char c;

	rev = macrostg+2;

	while (*shellcmd != '\0')
		if ((*shellcmd++ =='g') && (*shellcmd++ =='e') && (*shellcmd++ =='t'))
			break;
	while (*shellcmd++ != '$');
	shellcmd--;

	subst(shellcmd,macrostg);
	ptr = rev;
	while (((c=(*ptr++))=='.') || (numeric(c)));
	*--ptr = '\0';
	return(rev);
}



/*
 *  ascertain 1 or 2-digit sccsid release (or level) number
 */

getnum(c,fp)
char *c;
FILE *fp;
{
	int id;
	int unit;

	if (numeric(c))
	        id = c - '0';
	else return(NO);
	unit = getc(fp);
	if (numeric(unit))
	        id = id * 10 + (unit - '0');
	else ungetc(unit, fp);
	return(id);
}



/*
 *  expand string at pointer by inserting " -n" (no execute flag)
 */

addnoex(ptr)
char *ptr;
{
	char string[OUTMAX];
	char *s1;
	char *orig;

	orig=ptr;
	s1 = string;
	while (*s1++ = *ptr++);         /* copy rest of string to temp */
	*orig++ = '-';
	*orig++ = 'n';
	*orig++ = ' ';

	s1 = string;
	while (*orig++ = *s1++);
}



/*
 *  are strings same for length of second string
 */

noteq(x,y)
char *x;
char *y;
{
	while (*x++ == *y++);
	y--;                            /* was incr. after failed test */
	if (*y == '\0')  return(0);
	else return(1);
}



/*
 *  simple name is last part of path name in first argument
 */

sname(s)
char *s;
{
        register char *p;
 
        for(p=s; *p && (*p != ' ') ; p++) if(*p == '/') s = p + 1;
        return(s);
}



/*
   If there are any Shell meta characters in the name,
   expand into a list, after searching directory
*/

expand(q)
register struct depblock *q;
{
register char *s;
char *s1;
struct depblock *p, *srchdir();

s1 = q->depname->namep;
for(s=s1 ; ;) switch(*s++)
	{
	case '\0':
		return;

	case '*':
	case '?':
	case '[':
		if( p = srchdir(s1 , YES, q->nxtdepblock) )
			{
			q->nxtdepblock = p;
			q->depname = 0;
			}
		return;
	}
}



/*
 *  for trace output, indent 4 spaces per recursion level to show nesting
 */

indent(reclevel)
int reclevel;
{
	while (reclevel--)
		printf("    ");
}
